/*
 * Decompiled with CFR 0.152.
 */
package javaPlay;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import javaPlay.GameCanvas;
import javaPlay.GameEngine;
import javaPlay.GameObject;
import javaPlay.TileInfo;
import javax.imageio.ImageIO;

public class Scene {
    private Image backDrop;
    private Image[] tiles;
    private ArrayList tileLayer;
    private ArrayList overlays;
    private int drawStartX = 0;
    private int drawStartY = 0;

    public void loadFromFile(String sceneFile) throws InterruptedException, FileNotFoundException, IOException, Exception {
        this.tileLayer = new ArrayList();
        this.overlays = new ArrayList();
        BufferedReader input = new BufferedReader(new FileReader(new File(sceneFile)));
        String line = input.readLine();
        int numOfTileImages = Integer.parseInt(line, 10);
        this.tiles = new Image[numOfTileImages];
        for (int i = 0; i < numOfTileImages; ++i) {
            line = input.readLine();
            this.tiles[i] = ImageIO.read(new File(line));
        }
        String endTileSet = "%";
        line = input.readLine();
        while (!line.equals(endTileSet)) {
            ArrayList<Integer> tileLine = new ArrayList<Integer>();
            String[] tileIndices = line.split(",");
            for (int i = 0; i < tileIndices.length; ++i) {
                tileLine.add(Integer.parseInt(tileIndices[i]));
            }
            this.tileLayer.add(tileLine);
            line = input.readLine();
        }
        line = input.readLine();
        this.backDrop = ImageIO.read(new File(line));
    }

    public void addOverlay(GameObject overlay) {
        this.overlays.add(overlay);
    }

    public void removeOverlay(GameObject overlay) {
        this.overlays.remove(overlay);
    }

    public void setDrawStartPos(int drawStartX, int drawStartY) {
        this.drawStartX = drawStartX;
        this.drawStartY = drawStartY;
    }

    public void draw(Graphics g) {
        GameCanvas canvas = GameEngine.getInstance().getGameCanvas();
        g.setColor(Color.BLACK);
        g.clearRect(0, 0, canvas.getWidth(), canvas.getHeight());
        int startDrawX = canvas.getRenderScreenStartX() - this.drawStartX;
        int startDrawY = canvas.getRenderScreenStartY() - this.drawStartY;
        g.drawImage(this.backDrop, startDrawX, startDrawY, null);
        for (int i = 0; i < this.overlays.size(); ++i) {
            GameObject element = (GameObject)this.overlays.get(i);
            element.draw(g);
        }
    }

    public Vector getTilesFromRect(Point min, Point max) {
        Vector<TileInfo> v = new Vector<TileInfo>();
        GameCanvas canvas = GameEngine.getInstance().getGameCanvas();
        int startDrawX = canvas.getRenderScreenStartX() - this.drawStartX;
        int startDrawY = canvas.getRenderScreenStartY() - this.drawStartY;
        int tileWidth = this.tiles[0].getWidth(null);
        int tileHeight = this.tiles[0].getHeight(null);
        int line = 0;
        int drawY = startDrawY;
        do {
            ArrayList tileLine = (ArrayList)this.tileLayer.get(line);
            int drawX = startDrawX;
            int c = 0;
            while (c < tileLine.size()) {
                TileInfo tile = new TileInfo();
                tile.id = (Integer)tileLine.get(c);
                tile.min.x = drawX - canvas.getRenderScreenStartX();
                tile.min.y = drawY - canvas.getRenderScreenStartY();
                tile.max.x = drawX - canvas.getRenderScreenStartX() + tileWidth - 1;
                tile.max.y = drawY - canvas.getRenderScreenStartY() + tileHeight - 1;
                if (min.x <= tile.max.x && max.x >= tile.min.x && min.y <= tile.max.y && max.y >= tile.min.y) {
                    v.add(tile);
                }
                ++c;
                drawX += tileWidth;
            }
            drawY += tileHeight;
        } while (++line < this.tileLayer.size());
        return v;
    }

    public void step(int timeElapsed) {
        for (int i = 0; i < this.overlays.size(); ++i) {
            GameObject element = (GameObject)this.overlays.get(i);
            element.step(timeElapsed);
        }
    }
}

