/*
 * Decompiled with CFR 0.152.
 */
package javaPlay;

import java.awt.Graphics;
import java.awt.Image;
import java.io.File;
import java.util.ArrayList;
import javaPlay.GameCanvas;
import javaPlay.GameEngine;
import javax.imageio.ImageIO;

public class Sprite {
    private Image image;
    private int animFrameCount;
    private int currAnimFrame;
    private int animFrameWidth;
    private int animFrameHeight;
    private Boolean multiFileMode;
    private ArrayList fileList;

    public Sprite(String filename, int animFrameCount, int animFrameWidth, int animFrameHeight) throws Exception {
        this.multiFileMode = false;
        this.image = ImageIO.read(new File(filename));
        this.animFrameCount = animFrameCount;
        this.animFrameWidth = animFrameWidth;
        this.animFrameHeight = animFrameHeight;
        this.currAnimFrame = 0;
    }

    public Sprite(String filenamePrefix, int animFrameCount, int animFrameWidth, int animFrameHeight, Boolean multiFileModeIndicator) throws Exception {
        this.multiFileMode = true;
        this.fileList = new ArrayList();
        for (int i = 0; i < animFrameCount; ++i) {
            this.image = ImageIO.read(new File(filenamePrefix + "-" + i + ".png"));
            this.fileList.add(this.image);
        }
        this.animFrameCount = animFrameCount;
        this.animFrameWidth = animFrameWidth;
        this.animFrameHeight = animFrameHeight;
        this.currAnimFrame = 0;
    }

    public void setCurrAnimFrame(int frame) {
        this.currAnimFrame = frame;
    }

    public void draw(Graphics g, int x, int y) {
        GameCanvas canvas = GameEngine.getInstance().getGameCanvas();
        int xpos = canvas.getRenderScreenStartX() + x;
        int ypos = canvas.getRenderScreenStartY() + y;
        if (!this.multiFileMode.booleanValue()) {
            g.drawImage(this.image, xpos, ypos, xpos + this.animFrameWidth, ypos + this.animFrameHeight, this.currAnimFrame * this.animFrameWidth, 0, (this.currAnimFrame + 1) * this.animFrameWidth, this.animFrameHeight, null);
        } else {
            this.image = (Image)this.fileList.get(this.currAnimFrame);
            g.drawImage(this.image, xpos, ypos, null);
        }
    }

    private Sprite(Image image, int animFrameCount, int currAnimFrame, int animFrameWidth, int animFrameHeight) {
        this.image = image;
        this.animFrameCount = animFrameCount;
        this.currAnimFrame = currAnimFrame;
        this.animFrameWidth = animFrameWidth;
        this.animFrameHeight = animFrameHeight;
    }

    public Sprite clone() {
        return new Sprite(this.image, this.animFrameCount, this.currAnimFrame, this.animFrameWidth, this.animFrameHeight);
    }
}

