---LuaRSS Reader para TV Digital<br/>
---@author Manoel Campos da Silva Filho<br/> 
---Professor do Instituto Federal de Educação, Ciência e Tecnologia do Tocantins<br/>
---http://manoelcampos.com



dofile("LuaXML/handler.lua")

---Imprime uma tabela, de forma recursiva
--@param tb A tabela a ser impressa
--@param level Apenas usado internamente para 
--imprimir espaços para representar os níveis
--dentro da tabela.
function printable(tb, level)
  level = level or 1
  local spaces = string.rep(' ', level*2)
  for k,v in pairs(tb) do
      if type(v) ~= "table" then
         print(spaces .. k..'='..v)
      else
         print(spaces .. k)
         level = level + 1
         printable(v, level)
      end
  end  
end

---Número da notícia a ser exibida no momento
local itemIndex = -1

---Instancia o objeto que é responsável por
--armazenar o XML em forma de uma table lua
local xmlhandler = simpleTreeHandler()

function moveItemIndex(index, forward)
  if index < 0 then
     return index
  end
  
  if forward then
  	 index = index + 1
  	 if index > 3 then
  	    index = 1
  	 end
  else
  	 index = index - 1
  	 if index <= 0 then
  	    index = 3
  	 end;
  end
  return index
end 
function Control(keys)
	event.post("in",{class="key",type="press",key=keys})
end

---Avança para a próxima notícia.
--Função utilizada para fazer o 
--avanço automático para a próxima notícia
--depois de um determinado tempo. 
function autoForward()
	itemIndex = moveItemIndex(itemIndex, true)
	showItem()  
end

---Quebra uma string para que a mesma tenha linhas
--com um comprimento máximo definido, não quebrando
--a mesma no meio das palavras.
--@param str String a ser quebrada
--@param maxLineSize Quantidade máxima de caracteres por linha
--@returns Retorna uma tabela onde cada item é uma linha
--da string quebrada.
function breakString(str, maxLineSize)
	local t = {}
	local i, fim, countLns = 1, 0, 0

	if (str == nil) or (str == "") then
		return t
	end 

	str = string.gsub(str, "\n", " ")
	str = string.gsub(str, "\r", " ")
    
  while i < #str do
     countLns = countLns + 1
     if i > #str then
        t[countLns] = str
        i = #str 
     else
        fim = i+34
        if fim > #str then
           fim = #str
        else
	        --se o caracter onde a string deve ser quebrada
	        --não for um espaço, procura o próximo espaço
	        if string.byte(str, fim) ~= 32 then
	           fim = string.find(str, ' ', i+34-3)
	           if fim == nil then
	              fim = #str
	           end
	        end
			if fim>i+34 then
	           fim = string.find(str, ' ', i+34-6)
	           if fim == nil then
	              fim = #str
	           end
	        end
			if fim>i+34 then
	           fim = string.find(str, ' ', i+34-9)
	           if fim == nil then
	              fim = #str
	           end
	        end
						if fim>i+34 then
	           fim = string.find(str, ' ', i+34-12)
	           if fim == nil then
	              fim = #str
	           end
	        end
			if fim>i+34 then
	           fim = string.find(str, ' ', i+34-15)
	           if fim == nil then
	              fim = #str
	           end
	        end

        end
        t[countLns]=string.sub(str, i, fim)
        i=fim+1
     end
  end
  
  return t
end

function drawApplication()
	  itemIndex = 1
	  showItem()	  
end





---Função para converter uma string para o formato URL-Encode,
--também chamado de Percent Encode, segundo RFC 3986.
--Fonte: http://www.lua.org/pil/20.3.html
--@param s String a ser codificada
--@returns Returna a string codificada
function escape (s)
  s = string.gsub(s, "([&=+%c])", function (c)
        return string.format("%%%02X", string.byte(c))
      end)
  s = string.gsub(s, " ", "+")
  return s
end


---Cria um arquivo com o conteúdo informado em text.
--Se o arquivo já existir, substitui.
--@param text Texto a ser adicionado no arquivo
--@param fileName Nome do arquivo a ser gerado.

---Função tratadora de eventos
--@param evt Tabela contendo dados sobre o evento disparado
function handler(evt)
   if (evt.class == 'key' and evt.type == 'press') then
	  print("key:", evt.key)
	  local ok = false
      --Se a tecla pressionada foi a seta para direita ou esquerda,
      --altera o índice da notícia a ser exibida.
      --Implementa uma "lista circular" para exibição das notícias.
	  if evt.key == "CURSOR_RIGHT" then
	     ok = true
	     itemIndex = moveItemIndex(itemIndex, true)
	  elseif evt.key == "CURSOR_LEFT" then
	     ok = true
	     itemIndex = moveItemIndex(itemIndex, false)
	  end
	  
	  if ok then
	     showItem()
	  end
	  if evt.key == "CURSOR_DOWN" or evt.key == "CURSOR_UP"   then
	     itemIndex = -2
	     showItem()
	     return
	  end
	  if evt.key == "ENTER"  then
	     itemIndex = 1
	     showItem()
	     return
	  end
   end	 

	
	--Só executa o código depois do if se a aplicação
	--está inicializando, para baixar o XML do feed
	--e iniciar a exibição das notícias.
    if (evt.class == "ncl" and evt.type=="presentation" 
    and evt.action == "start") == false then
       return
    end
    
		            drawApplication()
end

---Exibe uma notícia na tela

function showItem()
local i = itemIndex
if itemIndex < -1 then
title = ''
  end
if itemIndex > 0 then
dathor = 'LENTIDO DO TRNSITO'
title = 'MARGINAL TIET:'
transito2 = 'A. Senna - Castelo : 2,1 km'
transito3 = 'Castelo - A. Senna : 0,0 km'
end
if itemIndex > 1 then
dathor = 'LENTIDO DO TRNSITO'
title = 'MARGINAL PINHEIROS:'
transito2 = 'Castelo - Interlagos : 0,0 km'
transito3 = 'Interlagos - Castelo : 0,8 km'
end
if itemIndex > 2 then
dathor = 'LENTIDO DO TRNSITO'
title = 'AV. BANDEIRANTES:'
transito2 = 'Imigrantes-Marginal : 1,2 km'
transito3 = 'Marginal-Imigrantes : 2,9 km'
end
if itemIndex > 3 then
dathor = 'LENTIDO DO TRNSITO'
title = 'EIXO NORTE - SUL :'
transito2 = 'Aeroporto-Santana : 0,0 km'
transito3 = 'Santana-Aeroporto : 1,0 km'
end
if itemIndex > 4 then
dathor = 'LENTIDO DO TRNSITO'
title = 'EIXO LESTE - OESTE :'
transito2 = 'Lapa-Penha : 0,0 km'
transito3 = 'Penha-Lapa : 1,3 km'
end
--width e height do canvas atual
local cw, ch = canvas:attrSize()
canvas:attrColor(0, 0, 0, 0)
  --canvas : attrColor(255,255,255,255)
canvas : clear()
canvas:drawRect('fill', 0, 0, cw, ch)
canvas:attrColor(255,255,255,255)
canvas:attrFont('Tiresias', .1*ch)
  --width e height de um caractere maiúsculo
local tw, th = canvas:measureText('a')
  --total de caracteres a serem exibidos por linha, dentro
  --da largura do canvas
local charsByLine = tonumber(string.format('%d', .8*cw / tw))
local desc = title
  --Quebra o texto da notícia em diversas linhas, 
  --gerando uma tabela onde cada item é uma linha que
  --foi quebrada. Isto é usado para que o texto seja
  --exibido sem sair da tela. 
local desctb = breakString(desc, charsByLine)
canvas:attrColor(255,255,255,255)
canvas:attrFont('Tiresias', .1*ch,'bold')
local y = 4
canvas : drawText(.001*cw, .001*ch, 'TRNSITO')
canvas:attrColor('yellow')
canvas:attrFont('Tiresias', .1*ch, 'bold')
canvas : drawText(.06*cw, .2*ch , dathor)
canvas:attrColor(255,255,255,255)
 --Percorre a tabela gerada a partir da quebra do texto
--em linhas, e imprime cada linha na tela
for k,ln in pairs(desctb) do
canvas : drawText(.06*cw,.4*ch , title)
canvas:attrFont('Tiresias', .1*ch)
canvas:drawText(.06*cw, .6*ch, transito2)
canvas:drawText(.06*cw, .7*ch, transito3)
end
local imgFechar = canvas:new('media/fechar.png')
local imw, imh = imgFechar:attrSize()
canvas:compose(cw - imw, ch - imh, imgFechar)
local imgEsq = canvas:new('media/esq.png')
local imw, imh = imgEsq:attrSize()
canvas:compose(cw - imw * 2, 0, imgEsq)
local imgDir = canvas:new('media/dir.png')
canvas:compose(cw - imw, 0, imgDir)
canvas:flush()
  --Variável que aponta para uma função
  --utilizada para interromper
  --o avanço automático de notícias
  --quando o usuário pressiona uma 
  --tecla e assim, reiniciar
  --a contagem de tempo.
if cancelTimerFunc then
	 cancelTimerFunc() --cancela o timer anteriormente criado
end
cancelTimerFunc = event.timer(6000, autoForward)
end
event.register(handler)