/*  Departamento de Informatica, PUC-Rio, INF1761 Computer Graphhics
*    
*   @file color.h TAD: Generic colorimetry computarioms (implementation).
*   @author Marcelo Gattass and others
*
*   @date
*         Last versio:     08/2011.
*
*   @version 1.1
* 
*   @Copyright/License
*   DI PUC-Rio Educational Software
*   All the products under this license are free software: they can be used for both academic and commercial purposes at absolutely no cost. 
*   There are no paperwork, no royalties, no GNU-like "copyleft" restrictions, either. Just download and use it. 
*   They are licensed under the terms of the MIT license reproduced below, and so are compatible with GPL and also qualifies as Open Source software. 
*   They are not in the public domain, PUC-Rio keeps their copyright. The legal details are below. 
* 
*   The spirit of this license is that you are free to use the libraries for any purpose at no cost without having to ask us. 
*   The only requirement is that if you do use them, then you should give us credit by including the copyright notice below somewhere in your product or its documentation. 
*   
*   Copyright  2010-2011 DI PUC-Rio Educational Software
*
*   Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software 
*   without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sub license, and/or sell copies of the Software, and to permit 
*   persons to whom the Software is furnished to do so, subject to the following conditions: 
*   
*   The above copyright notice and this permission notice shall be included in all copies or suavlantial portions of the Software. 
*
*   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
*   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
*   WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE. 
*
*/

#include<stdio.h>
#include<assert.h>
#include<math.h>

#include"color.h"

#define RAD2DEG(xX) (180.0f/3.14159265358979f * (xX))
#define DEG2RAD(xX) (3.14159265358979f/180.0f * (xX))

/* COLOR CONSTANT DATA */

/*  Reference white CIEXYZ values for 2 degrees observer CIE 1931 */
const float reference_white[n_illuminants][3] = {
	/* A  */  {1.09850f,  1.0f, 0.35585f},
	/* C  */  {0.98074f,  1.0f, 1.18232f},
	/* D50 */ {0.96422f,  1.0f, 0.82521f},
	/* D55 */ {0.95682f,  1.0f, 0.92149f},
	/* D65 */ {0.95047f,  1.0f, 1.08883f},
	/* D75 */ {0.94972f,  1.0f, 1.22638f},
	/* F2 */  {0.99187f,  1.0f, 0.67395f},
	/* F7 */  {0.95044f,  1.0f, 1.08755f},
	/* F11 */ {1.00966f,  1.0f, 0.64370f},
	/* test*/ {1.00000f,  1.0f, 1.0f    } };

/* Standard monitor */
struct BT709 {
	float r[2];
	float g[2];
	float b[2];
	float w[2];
} monitor =  { {0.64f,0.33f}, {0.30f, 0.60f}, {0.15f,0.06f}, {0.3127f,0.3290f} };

 

/* values for 2 degrees observer CIE 1931 */
const struct CIEXYZ_A_D65_spectrum {   float x_bar;    float y_bar;     float z_bar;  float A;  float D65; } spec[401]= {
	{0.00137f,0.00004f,0.00645f,0.10542f,0.48032f},
	{0.00150f,0.00004f,0.00708f,0.10773f,0.48481f},
	{0.00164f,0.00005f,0.00775f,0.11008f,0.48930f},
	{0.00180f,0.00005f,0.00850f,0.11245f,0.49379f},
	{0.00200f,0.00006f,0.00941f,0.11486f,0.49829f},
	{0.00224f,0.00006f,0.01055f,0.11731f,0.50278f},
	{0.00254f,0.00007f,0.01197f,0.11979f,0.50727f},
	{0.00289f,0.00008f,0.01366f,0.12231f,0.51176f},
	{0.00330f,0.00009f,0.01559f,0.12486f,0.51625f},
	{0.00375f,0.00011f,0.01773f,0.12745f,0.52074f},
	{0.00424f,0.00012f,0.02005f,0.13007f,0.52523f},
	{0.00476f,0.00013f,0.02251f,0.13273f,0.55225f},
	{0.00533f,0.00015f,0.02520f,0.13543f,0.57926f},
	{0.00598f,0.00017f,0.02828f,0.13816f,0.60627f},
	{0.00674f,0.00019f,0.03190f,0.14093f,0.63329f},
	{0.00765f,0.00022f,0.03621f,0.14373f,0.66030f},
	{0.00875f,0.00025f,0.04144f,0.14657f,0.68731f},
	{0.01003f,0.00028f,0.04750f,0.14945f,0.71433f},
	{0.01142f,0.00032f,0.05412f,0.15236f,0.74134f},
	{0.01287f,0.00036f,0.06100f,0.15531f,0.76835f},
	{0.01431f,0.00040f,0.06785f,0.15830f,0.79537f},
	{0.01570f,0.00043f,0.07449f,0.16133f,0.80376f},
	{0.01715f,0.00047f,0.08136f,0.16439f,0.81215f},
	{0.01878f,0.00052f,0.08915f,0.16749f,0.82054f},
	{0.02075f,0.00057f,0.09854f,0.17062f,0.82893f},
	{0.02319f,0.00064f,0.11020f,0.17380f,0.83733f},
	{0.02621f,0.00072f,0.12461f,0.17701f,0.84572f},
	{0.02978f,0.00083f,0.14170f,0.18026f,0.85411f},
	{0.03388f,0.00094f,0.16130f,0.18355f,0.86250f},
	{0.03847f,0.00107f,0.18326f,0.18687f,0.87089f},
	{0.04351f,0.00121f,0.20740f,0.19024f,0.87928f},
	{0.04900f,0.00136f,0.23369f,0.19364f,0.88115f},
	{0.05502f,0.00153f,0.26261f,0.19708f,0.88302f},
	{0.06172f,0.00172f,0.29477f,0.20055f,0.88489f},
	{0.06921f,0.00194f,0.33080f,0.20407f,0.88676f},
	{0.07763f,0.00218f,0.37130f,0.20762f,0.88863f},
	{0.08696f,0.00245f,0.41621f,0.21121f,0.89051f},
	{0.09718f,0.00276f,0.46546f,0.21485f,0.89238f},
	{0.10841f,0.00312f,0.51969f,0.21851f,0.89424f},
	{0.12077f,0.00353f,0.57953f,0.22222f,0.89612f},
	{0.13438f,0.00400f,0.64560f,0.22597f,0.89799f},
	{0.14936f,0.00455f,0.71848f,0.22975f,0.89150f},
	{0.16540f,0.00516f,0.79671f,0.23357f,0.88501f},
	{0.18198f,0.00583f,0.87785f,0.23743f,0.87852f},
	{0.19861f,0.00655f,0.95944f,0.24133f,0.87204f},
	{0.21477f,0.00730f,1.03905f,0.24527f,0.86555f},
	{0.23019f,0.00809f,1.11537f,0.24924f,0.85906f},
	{0.24488f,0.00891f,1.18850f,0.25326f,0.85258f},
	{0.25878f,0.00977f,1.25812f,0.25731f,0.84609f},
	{0.27181f,0.01066f,1.32393f,0.26140f,0.83960f},
	{0.28390f,0.01160f,1.38560f,0.26553f,0.83312f},
	{0.29494f,0.01257f,1.44264f,0.26970f,0.85059f},
	{0.30490f,0.01358f,1.49480f,0.27390f,0.86807f},
	{0.31379f,0.01463f,1.54219f,0.27815f,0.88554f},
	{0.32165f,0.01572f,1.58488f,0.28243f,0.90302f},
	{0.32850f,0.01684f,1.62296f,0.28675f,0.92049f},
	{0.33435f,0.01801f,1.65640f,0.29111f,0.93797f},
	{0.33921f,0.01921f,1.68530f,0.29551f,0.95544f},
	{0.34312f,0.02045f,1.70987f,0.29994f,0.97292f},
	{0.34613f,0.02172f,1.73038f,0.30441f,0.99040f},
	{0.34828f,0.02300f,1.74706f,0.30892f,1.00787f},
	{0.34960f,0.02429f,1.76004f,0.31347f,1.01954f},
	{0.35015f,0.02561f,1.76962f,0.31806f,1.03122f},
	{0.35001f,0.02696f,1.77626f,0.32268f,1.04288f},
	{0.34929f,0.02835f,1.78043f,0.32734f,1.05455f},
	{0.34806f,0.02980f,1.78260f,0.33204f,1.06622f},
	{0.34637f,0.03131f,1.78297f,0.33678f,1.07790f},
	{0.34426f,0.03288f,1.78170f,0.34155f,1.08957f},
	{0.34181f,0.03452f,1.77920f,0.34637f,1.10123f},
	{0.33909f,0.03623f,1.77587f,0.35121f,1.11291f},
	{0.33620f,0.03800f,1.77211f,0.35610f,1.12458f},
	{0.33320f,0.03985f,1.76826f,0.36102f,1.12535f},
	{0.33004f,0.04177f,1.76404f,0.36598f,1.12613f},
	{0.32664f,0.04377f,1.75894f,0.37098f,1.12690f},
	{0.32289f,0.04584f,1.75247f,0.37601f,1.12767f},
	{0.31870f,0.04800f,1.74410f,0.38108f,1.12844f},
	{0.31403f,0.05024f,1.73356f,0.38618f,1.12921f},
	{0.30888f,0.05257f,1.72086f,0.39133f,1.12999f},
	{0.30329f,0.05498f,1.70594f,0.39650f,1.13076f},
	{0.29726f,0.05746f,1.68874f,0.40172f,1.13154f},
	{0.29080f,0.06000f,1.66920f,0.40697f,1.13231f},
	{0.28397f,0.06260f,1.64753f,0.41225f,1.12947f},
	{0.27672f,0.06528f,1.62341f,0.41757f,1.12664f},
	{0.26892f,0.06804f,1.59602f,0.42293f,1.12380f},
	{0.26042f,0.07091f,1.56453f,0.42832f,1.12097f},
	{0.25110f,0.07390f,1.52810f,0.43375f,1.11812f},
	{0.24085f,0.07702f,1.48611f,0.43921f,1.11529f},
	{0.22985f,0.08027f,1.43952f,0.44470f,1.11245f},
	{0.21841f,0.08367f,1.38988f,0.45023f,1.10961f},
	{0.20681f,0.08723f,1.33874f,0.45580f,1.10678f},
	{0.19536f,0.09098f,1.28764f,0.46140f,1.10394f},
	{0.18421f,0.09492f,1.23742f,0.46703f,1.10496f},
	{0.17333f,0.09905f,1.18782f,0.47270f,1.10598f},
	{0.16269f,0.10337f,1.13876f,0.47840f,1.10701f},
	{0.15228f,0.10788f,1.09015f,0.48413f,1.10803f},
	{0.14210f,0.11260f,1.04190f,0.48990f,1.10905f},
	{0.13218f,0.11753f,0.99420f,0.49570f,1.11007f},
	{0.12257f,0.12267f,0.94735f,0.50153f,1.11109f},
	{0.11328f,0.12799f,0.90145f,0.50740f,1.11211f},
	{0.10430f,0.13345f,0.85662f,0.51330f,1.11313f},
	{0.09564f,0.13902f,0.81295f,0.51923f,1.11415f},
	{0.08730f,0.14468f,0.77052f,0.52519f,1.10732f},
	{0.07931f,0.15047f,0.72944f,0.53118f,1.10048f},
	{0.07172f,0.15646f,0.68991f,0.53721f,1.09364f},
	{0.06458f,0.16272f,0.65210f,0.54327f,1.08681f},
	{0.05795f,0.16930f,0.61620f,0.54936f,1.07997f},
	{0.05186f,0.17624f,0.58233f,0.55548f,1.07314f},
	{0.04628f,0.18356f,0.55042f,0.56163f,1.06631f},
	{0.04115f,0.19127f,0.52034f,0.56781f,1.05946f},
	{0.03641f,0.19942f,0.49197f,0.57402f,1.05263f},
	{0.03201f,0.20802f,0.46518f,0.58026f,1.04580f},
	{0.02792f,0.21712f,0.43992f,0.58653f,1.04632f},
	{0.02414f,0.22673f,0.41618f,0.59283f,1.04684f},
	{0.02069f,0.23686f,0.39388f,0.59916f,1.04736f},
	{0.01754f,0.24748f,0.37295f,0.60552f,1.04788f},
	{0.01470f,0.25860f,0.35330f,0.61191f,1.04840f},
	{0.01216f,0.27018f,0.33486f,0.61833f,1.04893f},
	{0.00992f,0.28229f,0.31755f,0.62477f,1.04945f},
	{0.00797f,0.29505f,0.30134f,0.63125f,1.04997f},
	{0.00630f,0.30858f,0.28617f,0.63775f,1.05050f},
	{0.00490f,0.32300f,0.27200f,0.64428f,1.05102f},
	{0.00378f,0.33840f,0.25882f,0.65083f,1.04953f},
	{0.00295f,0.35469f,0.24648f,0.65742f,1.04804f},
	{0.00242f,0.37170f,0.23477f,0.66403f,1.04654f},
	{0.00224f,0.38929f,0.22345f,0.67066f,1.04505f},
	{0.00240f,0.40730f,0.21230f,0.67733f,1.04356f},
	{0.00293f,0.42563f,0.20117f,0.68402f,1.04207f},
	{0.00384f,0.44431f,0.19012f,0.69073f,1.04058f},
	{0.00517f,0.46339f,0.17923f,0.69748f,1.03908f},
	{0.00698f,0.48294f,0.16856f,0.70424f,1.03759f},
	{0.00930f,0.50300f,0.15820f,0.71103f,1.03610f},
	{0.01215f,0.52357f,0.14814f,0.71785f,1.03321f},
	{0.01554f,0.54451f,0.13838f,0.72469f,1.03031f},
	{0.01948f,0.56569f,0.12899f,0.73155f,1.02741f},
	{0.02399f,0.58697f,0.12008f,0.73844f,1.02452f},
	{0.02910f,0.60820f,0.11170f,0.74536f,1.02163f},
	{0.03481f,0.62935f,0.10390f,0.75229f,1.01873f},
	{0.04112f,0.65031f,0.09667f,0.75925f,1.01584f},
	{0.04799f,0.67088f,0.08998f,0.76623f,1.01294f},
	{0.05538f,0.69084f,0.08385f,0.77324f,1.01004f},
	{0.06327f,0.71000f,0.07825f,0.78026f,1.00715f},
	{0.07164f,0.72819f,0.07321f,0.78731f,1.00994f},
	{0.08046f,0.74546f,0.06868f,0.79438f,1.01273f},
	{0.08974f,0.76197f,0.06457f,0.80147f,1.01551f},
	{0.09946f,0.77784f,0.06079f,0.80859f,1.01830f},
	{0.10960f,0.79320f,0.05725f,0.81572f,1.02108f},
	{0.12017f,0.80811f,0.05390f,0.82288f,1.02386f},
	{0.13111f,0.82250f,0.05075f,0.83005f,1.02665f},
	{0.14237f,0.83631f,0.04775f,0.83725f,1.02944f},
	{0.15385f,0.84949f,0.04490f,0.84446f,1.03223f},
	{0.16550f,0.86200f,0.04216f,0.85169f,1.03501f},
	{0.17726f,0.87381f,0.03951f,0.85895f,1.03186f},
	{0.18914f,0.88496f,0.03694f,0.86622f,1.02870f},
	{0.20117f,0.89549f,0.03446f,0.87351f,1.02555f},
	{0.21337f,0.90544f,0.03209f,0.88082f,1.02238f},
	{0.22575f,0.91485f,0.02984f,0.88814f,1.01923f},
	{0.23832f,0.92373f,0.02771f,0.89549f,1.01608f},
	{0.25107f,0.93209f,0.02569f,0.90285f,1.01292f},
	{0.26399f,0.93992f,0.02379f,0.91023f,1.00976f},
	{0.27710f,0.94723f,0.02199f,0.91763f,1.00660f},
	{0.29040f,0.95400f,0.02030f,0.92504f,1.00345f},
	{0.30389f,0.96026f,0.01872f,0.93247f,1.00310f},
	{0.31757f,0.96601f,0.01724f,0.93991f,1.00276f},
	{0.33144f,0.97126f,0.01586f,0.94737f,1.00241f},
	{0.34548f,0.97602f,0.01458f,0.95484f,1.00207f},
	{0.35970f,0.98030f,0.01340f,0.96233f,1.00172f},
	{0.37408f,0.98409f,0.01231f,0.96984f,1.00138f},
	{0.38864f,0.98742f,0.01130f,0.97736f,1.00104f},
	{0.40338f,0.99031f,0.01038f,0.98489f,1.00069f},
	{0.41831f,0.99281f,0.00953f,0.99244f,1.00035f},
	{0.43345f,0.99495f,0.00875f,1.00000f,1.00000f},
	{0.44880f,0.99671f,0.00804f,1.00757f,0.99611f},
	{0.46434f,0.99810f,0.00738f,1.01516f,0.99222f},
	{0.48006f,0.99911f,0.00679f,1.02276f,0.98833f},
	{0.49597f,0.99975f,0.00624f,1.03037f,0.98445f},
	{0.51205f,1.00000f,0.00575f,1.03800f,0.98056f},
	{0.52830f,0.99986f,0.00530f,1.04563f,0.97666f},
	{0.54469f,0.99930f,0.00490f,1.05328f,0.97278f},
	{0.56121f,0.99833f,0.00453f,1.06094f,0.96889f},
	{0.57782f,0.99690f,0.00420f,1.06861f,0.96501f},
	{0.59450f,0.99500f,0.00390f,1.07629f,0.96111f},
	{0.61122f,0.99260f,0.00362f,1.08398f,0.95759f},
	{0.62798f,0.98974f,0.00337f,1.09168f,0.95407f},
	{0.64476f,0.98644f,0.00314f,1.09938f,0.95054f},
	{0.66157f,0.98272f,0.00293f,1.10711f,0.94702f},
	{0.67840f,0.97860f,0.00275f,1.11484f,0.94350f},
	{0.69524f,0.97408f,0.00259f,1.12258f,0.93997f},
	{0.71206f,0.96917f,0.00244f,1.13032f,0.93645f},
	{0.72883f,0.96386f,0.00231f,1.13808f,0.93293f},
	{0.74552f,0.95813f,0.00220f,1.14584f,0.92940f},
	{0.76210f,0.95200f,0.00210f,1.15361f,0.92588f},
	{0.77854f,0.94545f,0.00202f,1.16138f,0.92536f},
	{0.79483f,0.93850f,0.00195f,1.16917f,0.92483f},
	{0.81093f,0.93116f,0.00189f,1.17696f,0.92431f},
	{0.82682f,0.92346f,0.00184f,1.18476f,0.92378f},
	{0.84250f,0.91540f,0.00180f,1.19256f,0.92326f},
	{0.85793f,0.90701f,0.00177f,1.20037f,0.92273f},
	{0.87308f,0.89828f,0.00174f,1.20819f,0.92221f},
	{0.88789f,0.88920f,0.00171f,1.21601f,0.92168f},
	{0.90232f,0.87978f,0.00168f,1.22384f,0.92116f},
	{0.91630f,0.87000f,0.00165f,1.23166f,0.92063f},
	{0.92980f,0.85986f,0.00161f,1.23950f,0.91381f},
	{0.94280f,0.84939f,0.00156f,1.24734f,0.90698f},
	{0.95528f,0.83862f,0.00151f,1.25519f,0.90015f},
	{0.96722f,0.82758f,0.00146f,1.26303f,0.89333f},
	{0.97860f,0.81630f,0.00140f,1.27088f,0.88650f},
	{0.98939f,0.80479f,0.00134f,1.27874f,0.87967f},
	{0.99955f,0.79308f,0.00127f,1.28659f,0.87285f},
	{1.00909f,0.78119f,0.00120f,1.29445f,0.86602f},
	{1.01801f,0.76915f,0.00115f,1.30232f,0.85919f},
	{1.02630f,0.75700f,0.00110f,1.31018f,0.85237f},
	{1.03398f,0.74475f,0.00107f,1.31804f,0.85364f},
	{1.04099f,0.73242f,0.00105f,1.32591f,0.85491f},
	{1.04719f,0.72000f,0.00104f,1.33378f,0.85618f},
	{1.05247f,0.70750f,0.00102f,1.34165f,0.85745f},
	{1.05670f,0.69490f,0.00100f,1.34951f,0.85872f},
	{1.05979f,0.68222f,0.00097f,1.35739f,0.85999f},
	{1.06180f,0.66947f,0.00093f,1.36526f,0.86125f},
	{1.06281f,0.65667f,0.00089f,1.37313f,0.86252f},
	{1.06291f,0.64384f,0.00084f,1.38101f,0.86379f},
	{1.06220f,0.63100f,0.00080f,1.38887f,0.86506f},
	{1.06074f,0.61816f,0.00076f,1.39674f,0.86467f},
	{1.05844f,0.60531f,0.00072f,1.40461f,0.86428f},
	{1.05522f,0.59248f,0.00069f,1.41248f,0.86389f},
	{1.05098f,0.57964f,0.00065f,1.42033f,0.86350f},
	{1.04560f,0.56680f,0.00060f,1.42820f,0.86310f},
	{1.03904f,0.55396f,0.00055f,1.43606f,0.86271f},
	{1.03136f,0.54114f,0.00049f,1.44391f,0.86232f},
	{1.02267f,0.52835f,0.00044f,1.45177f,0.86193f},
	{1.01305f,0.51563f,0.00038f,1.45963f,0.86154f},
	{1.00260f,0.50300f,0.00034f,1.46747f,0.86115f},
	{0.99137f,0.49047f,0.00031f,1.47532f,0.85932f},
	{0.97933f,0.47803f,0.00028f,1.48317f,0.85750f},
	{0.96649f,0.46568f,0.00027f,1.49100f,0.85567f},
	{0.95285f,0.45340f,0.00025f,1.49884f,0.85384f},
	{0.93840f,0.44120f,0.00024f,1.50667f,0.85202f},
	{0.92319f,0.42908f,0.00023f,1.51450f,0.85019f},
	{0.90724f,0.41704f,0.00022f,1.52231f,0.84836f},
	{0.89050f,0.40503f,0.00021f,1.53013f,0.84654f},
	{0.87292f,0.39303f,0.00020f,1.53794f,0.84471f},
	{0.85445f,0.38100f,0.00019f,1.54574f,0.84288f},
	{0.83508f,0.36892f,0.00017f,1.55355f,0.83865f},
	{0.81495f,0.35683f,0.00016f,1.56134f,0.83441f},
	{0.79419f,0.34478f,0.00014f,1.56912f,0.83017f},
	{0.77295f,0.33282f,0.00012f,1.57690f,0.82593f},
	{0.75140f,0.32100f,0.00010f,1.58467f,0.82169f},
	{0.72958f,0.30934f,0.00009f,1.59244f,0.81745f},
	{0.70759f,0.29785f,0.00007f,1.60020f,0.81321f},
	{0.68560f,0.28659f,0.00007f,1.60795f,0.80897f},
	{0.66381f,0.27562f,0.00006f,1.61569f,0.80474f},
	{0.64240f,0.26500f,0.00005f,1.62343f,0.80050f},
	{0.62151f,0.25476f,0.00004f,1.63116f,0.80089f},
	{0.60111f,0.24489f,0.00004f,1.63887f,0.80129f},
	{0.58111f,0.23533f,0.00004f,1.64659f,0.80168f},
	{0.56140f,0.22605f,0.00003f,1.65430f,0.80208f},
	{0.54190f,0.21700f,0.00003f,1.66198f,0.80247f},
	{0.52260f,0.20816f,0.00003f,1.66967f,0.80287f},
	{0.50355f,0.19955f,0.00003f,1.67734f,0.80326f},
	{0.48474f,0.19116f,0.00002f,1.68501f,0.80366f},
	{0.46619f,0.18297f,0.00002f,1.69267f,0.80405f},
	{0.44790f,0.17500f,0.00002f,1.70031f,0.80444f},
	{0.42986f,0.16722f,0.00002f,1.70795f,0.80091f},
	{0.41210f,0.15965f,0.00002f,1.71557f,0.79738f},
	{0.39464f,0.15228f,0.00001f,1.72318f,0.79386f},
	{0.37753f,0.14513f,0.00001f,1.73079f,0.79033f},
	{0.36080f,0.13820f,0.00001f,1.73838f,0.78680f},
	{0.34446f,0.13150f,0.00001f,1.74596f,0.78327f},
	{0.32852f,0.12502f,0.00001f,1.75353f,0.77974f},
	{0.31302f,0.11878f,0.00000f,1.76109f,0.77621f},
	{0.29800f,0.11277f,0.00000f,1.76863f,0.77268f},
	{0.28350f,0.10700f,0.00000f,1.77618f,0.76915f},
	{0.26954f,0.10148f,0.00000f,1.78369f,0.76933f},
	{0.25612f,0.09619f,0.00000f,1.79120f,0.76951f},
	{0.24319f,0.09112f,0.00000f,1.79870f,0.76969f},
	{0.23073f,0.08626f,0.00000f,1.80618f,0.76987f},
	{0.21870f,0.08160f,0.00000f,1.81365f,0.77005f},
	{0.20710f,0.07712f,0.00000f,1.82111f,0.77023f},
	{0.19592f,0.07283f,0.00000f,1.82856f,0.77041f},
	{0.18517f,0.06871f,0.00000f,1.83600f,0.77059f},
	{0.17483f,0.06477f,0.00000f,1.84341f,0.77077f},
	{0.16490f,0.06100f,0.00000f,1.85082f,0.77095f},
	{0.15537f,0.05740f,0.00000f,1.85821f,0.77294f},
	{0.14623f,0.05396f,0.00000f,1.86558f,0.77492f},
	{0.13749f,0.05067f,0.00000f,1.87294f,0.77690f},
	{0.12915f,0.04755f,0.00000f,1.88030f,0.77889f},
	{0.12120f,0.04458f,0.00000f,1.88762f,0.78087f},
	{0.11364f,0.04176f,0.00000f,1.89494f,0.78285f},
	{0.10646f,0.03908f,0.00000f,1.90224f,0.78483f},
	{0.09969f,0.03656f,0.00000f,1.90954f,0.78682f},
	{0.09333f,0.03420f,0.00000f,1.91680f,0.78880f},
	{0.08740f,0.03200f,0.00000f,1.92407f,0.79078f},
	{0.08190f,0.02996f,0.00000f,1.93130f,0.78694f},
	{0.07680f,0.02808f,0.00000f,1.93853f,0.78311f},
	{0.07208f,0.02633f,0.00000f,1.94574f,0.77927f},
	{0.06769f,0.02471f,0.00000f,1.95293f,0.77543f},
	{0.06360f,0.02320f,0.00000f,1.96011f,0.77159f},
	{0.05981f,0.02180f,0.00000f,1.96727f,0.76775f},
	{0.05628f,0.02050f,0.00000f,1.97442f,0.76391f},
	{0.05297f,0.01928f,0.00000f,1.98154f,0.76008f},
	{0.04982f,0.01812f,0.00000f,1.98866f,0.75624f},
	{0.04677f,0.01700f,0.00000f,1.99575f,0.75240f},
	{0.04378f,0.01590f,0.00000f,2.00283f,0.74417f},
	{0.04088f,0.01484f,0.00000f,2.00989f,0.73594f},
	{0.03807f,0.01381f,0.00000f,2.01693f,0.72771f},
	{0.03540f,0.01283f,0.00000f,2.02396f,0.71948f},
	{0.03290f,0.01192f,0.00000f,2.03096f,0.71125f},
	{0.03056f,0.01107f,0.00000f,2.03795f,0.70302f},
	{0.02838f,0.01027f,0.00000f,2.04492f,0.69479f},
	{0.02634f,0.00953f,0.00000f,2.05188f,0.68656f},
	{0.02445f,0.00885f,0.00000f,2.05881f,0.67833f},
	{0.02270f,0.00821f,0.00000f,2.06573f,0.67010f},
	{0.02108f,0.00762f,0.00000f,2.07263f,0.67192f},
	{0.01960f,0.00709f,0.00000f,2.07951f,0.67373f},
	{0.01824f,0.00659f,0.00000f,2.08637f,0.67554f},
	{0.01699f,0.00614f,0.00000f,2.09321f,0.67736f},
	{0.01584f,0.00572f,0.00000f,2.10003f,0.67917f},
	{0.01479f,0.00534f,0.00000f,2.10683f,0.68099f},
	{0.01383f,0.00500f,0.00000f,2.11362f,0.68280f},
	{0.01295f,0.00468f,0.00000f,2.12038f,0.68462f},
	{0.01213f,0.00438f,0.00000f,2.12713f,0.68643f},
	{0.01136f,0.00410f,0.00000f,2.13386f,0.68824f},
	{0.01063f,0.00384f,0.00000f,2.14056f,0.69088f},
	{0.00994f,0.00359f,0.00000f,2.14726f,0.69351f},
	{0.00929f,0.00335f,0.00000f,2.15392f,0.69614f},
	{0.00868f,0.00313f,0.00000f,2.16057f,0.69878f},
	{0.00811f,0.00293f,0.00000f,2.16720f,0.70141f},
	{0.00758f,0.00274f,0.00000f,2.17380f,0.70404f},
	{0.00709f,0.00256f,0.00000f,2.18039f,0.70668f},
	{0.00663f,0.00239f,0.00000f,2.18696f,0.70931f},
	{0.00620f,0.00224f,0.00000f,2.19351f,0.71194f},
	{0.00579f,0.00209f,0.00000f,2.20003f,0.71458f},
	{0.00541f,0.00195f,0.00000f,2.20653f,0.70233f},
	{0.00505f,0.00182f,0.00000f,2.21302f,0.69008f},
	{0.00472f,0.00170f,0.00000f,2.21948f,0.67783f},
	{0.00440f,0.00159f,0.00000f,2.22592f,0.66558f},
	{0.00411f,0.00148f,0.00000f,2.23234f,0.65333f},
	{0.00383f,0.00138f,0.00000f,2.23874f,0.64108f},
	{0.00358f,0.00129f,0.00000f,2.24512f,0.62883f},
	{0.00333f,0.00120f,0.00000f,2.25147f,0.61658f},
	{0.00311f,0.00112f,0.00000f,2.25781f,0.60433f},
	{0.00290f,0.00105f,0.00000f,2.26413f,0.59208f},
	{0.00270f,0.00098f,0.00000f,2.27042f,0.60004f},
	{0.00252f,0.00091f,0.00000f,2.27669f,0.60800f},
	{0.00235f,0.00085f,0.00000f,2.28293f,0.61596f},
	{0.00220f,0.00079f,0.00000f,2.28917f,0.62392f},
	{0.00205f,0.00074f,0.00000f,2.29538f,0.63188f},
	{0.00191f,0.00069f,0.00000f,2.30155f,0.63984f},
	{0.00178f,0.00064f,0.00000f,2.30772f,0.64780f},
	{0.00166f,0.00060f,0.00000f,2.31386f,0.65576f},
	{0.00155f,0.00056f,0.00000f,2.31997f,0.66372f},
	{0.00144f,0.00052f,0.00000f,2.32607f,0.67168f},
	{0.00134f,0.00048f,0.00000f,2.33214f,0.67668f},
	{0.00125f,0.00045f,0.00000f,2.33819f,0.68168f},
	{0.00116f,0.00042f,0.00000f,2.34422f,0.68668f},
	{0.00108f,0.00039f,0.00000f,2.35022f,0.69168f},
	{0.00100f,0.00036f,0.00000f,2.35621f,0.69668f},
	{0.00093f,0.00034f,0.00000f,2.36216f,0.70167f},
	{0.00086f,0.00031f,0.00000f,2.36810f,0.70667f},
	{0.00080f,0.00029f,0.00000f,2.37401f,0.71167f},
	{0.00074f,0.00027f,0.00000f,2.37991f,0.71667f},
	{0.00069f,0.00025f,0.00000f,2.38577f,0.72167f},
	{0.00064f,0.00023f,0.00000f,2.39162f,0.71062f},
	{0.00059f,0.00021f,0.00000f,2.39744f,0.69958f},
	{0.00055f,0.00020f,0.00000f,2.40324f,0.68853f},
	{0.00051f,0.00019f,0.00000f,2.40901f,0.67748f},
	{0.00048f,0.00017f,0.00000f,2.41477f,0.66643f},
	{0.00044f,0.00016f,0.00000f,2.42049f,0.65539f},
	{0.00041f,0.00015f,0.00000f,2.42620f,0.64434f},
	{0.00038f,0.00014f,0.00000f,2.43188f,0.63329f},
	{0.00036f,0.00013f,0.00000f,2.43754f,0.62224f},
	{0.00033f,0.00012f,0.00000f,2.44317f,0.61120f},
	{0.00031f,0.00011f,0.00000f,2.44879f,0.59469f},
	{0.00029f,0.00010f,0.00000f,2.45438f,0.57818f},
	{0.00027f,0.00010f,0.00000f,2.45994f,0.56168f},
	{0.00025f,0.00009f,0.00000f,2.46548f,0.54517f},
	{0.00023f,0.00008f,0.00000f,2.47099f,0.52866f},
	{0.00022f,0.00008f,0.00000f,2.47649f,0.51216f},
	{0.00020f,0.00007f,0.00000f,2.48196f,0.49565f},
	{0.00019f,0.00007f,0.00000f,2.48741f,0.47914f},
	{0.00018f,0.00006f,0.00000f,2.49283f,0.46264f},
	{0.00017f,0.00006f,0.00000f,2.49822f,0.44613f},
	{0.00016f,0.00006f,0.00000f,2.50361f,0.46573f},
	{0.00014f,0.00005f,0.00000f,2.50895f,0.48532f},
	{0.00013f,0.00005f,0.00000f,2.51427f,0.50492f},
	{0.00013f,0.00005f,0.00000f,2.51958f,0.52451f},
	{0.00012f,0.00004f,0.00000f,2.52485f,0.54410f},
	{0.00011f,0.00004f,0.00000f,2.53011f,0.56370f},
	{0.00010f,0.00004f,0.00000f,2.53535f,0.58329f},
	{0.00010f,0.00003f,0.00000f,2.54054f,0.60289f},
	{0.00009f,0.00003f,0.00000f,2.54573f,0.62248f},
	{0.00008f,0.00003f,0.00000f,2.55089f,0.64208f},
	{0.00008f,0.00003f,0.00000f,2.55602f,0.63879f},
	{0.00007f,0.00003f,0.00000f,2.56112f,0.63550f},
	{0.00007f,0.00002f,0.00000f,2.56621f,0.63221f},
	{0.00006f,0.00002f,0.00000f,2.57127f,0.62892f},
	{0.00006f,0.00002f,0.00000f,2.57631f,0.62563f},
	{0.00005f,0.00002f,0.00000f,2.58132f,0.62234f},
	{0.00005f,0.00002f,0.00000f,2.58631f,0.61905f},
	{0.00005f,0.00002f,0.00000f,2.59127f,0.61576f},
	{0.00004f,0.00002f,0.00000f,2.59621f,0.61247f},
	{0.00004f,0.00001f,0.00000f,2.60112f,0.60918f}
};

/* "l,nm",Standard Illuminant A,Standard Illuminant D65,Illuminant C,IlluminantD50,IlluminantD55,IlluminantD75 */
const struct Illuminat_spectrum {   float lambda, A, D65, C, D50, D55, D75;  } illum[97]= {
      {300,0.00930f,0.00034f,0.00000f,0.00019f,0.00024f,0.00043f}, 
      {305,0.01128f,0.01664f,0.00000f,0.01035f,0.01048f,0.02588f}, 
      {310,0.01358f,0.03295f,0.00000f,0.02051f,0.02072f,0.05133f}, 
      {315,0.01622f,0.11765f,0.00000f,0.04914f,0.06648f,0.17470f}, 
      {320,0.01925f,0.20236f,0.00010f,0.07778f,0.11224f,0.29808f}, 
      {325,0.02270f,0.28645f,0.00200f,0.11263f,0.15936f,0.42369f}, 
      {330,0.02660f,0.37054f,0.00400f,0.14748f,0.20647f,0.54930f}, 
      {335,0.03099f,0.38501f,0.01550f,0.16348f,0.22266f,0.56095f}, 
      {340,0.03590f,0.39949f,0.02700f,0.17948f,0.23885f,0.57259f}, 
      {345,0.04136f,0.42430f,0.04850f,0.19479f,0.25851f,0.60000f}, 
      {350,0.04742f,0.44912f,0.07000f,0.21010f,0.27817f,0.62740f}, 
      {355,0.05411f,0.45775f,0.09950f,0.22476f,0.29219f,0.62861f}, 
      {360,0.06145f,0.46638f,0.12900f,0.23942f,0.30621f,0.62982f}, 
      {365,0.06947f,0.49364f,0.17200f,0.25451f,0.32464f,0.66647f}, 
      {370,0.07821f,0.52089f,0.21400f,0.26961f,0.34308f,0.70312f}, 
      {375,0.08770f,0.51032f,0.27500f,0.25724f,0.33446f,0.68507f}, 
      {380,0.09795f,0.49976f,0.33000f,0.24488f,0.32584f,0.66703f}, 
      {385,0.10900f,0.52312f,0.39920f,0.27179f,0.35335f,0.68333f}, 
      {390,0.12085f,0.54648f,0.47400f,0.29871f,0.38087f,0.69963f}, 
      {395,0.13354f,0.68702f,0.55170f,0.39589f,0.49518f,0.85946f}, 
      {400,0.14708f,0.82755f,0.63300f,0.49308f,0.60949f,1.01929f}, 
      {405,0.16148f,0.87120f,0.71810f,0.52910f,0.64751f,1.06911f}, 
      {410,0.17675f,0.91486f,0.80600f,0.56513f,0.68554f,1.11894f}, 
      {415,0.19291f,0.92459f,0.89530f,0.58273f,0.70065f,1.12346f}, 
      {420,0.20995f,0.93432f,0.98100f,0.60034f,0.71577f,1.12798f}, 
      {425,0.22788f,0.90057f,1.05800f,0.58926f,0.69746f,1.07945f}, 
      {430,0.24671f,0.86682f,1.12400f,0.57818f,0.67914f,1.03092f}, 
      {435,0.26643f,0.95774f,1.17750f,0.66321f,0.76760f,1.12145f}, 
      {440,0.28703f,1.04865f,1.21500f,0.74825f,0.85605f,1.21198f}, 
      {445,0.30851f,1.10936f,1.23450f,0.81036f,0.91799f,1.27104f}, 
      {450,0.33086f,1.17008f,1.24000f,0.87247f,0.97993f,1.33010f}, 
      {455,0.35407f,1.17410f,1.23600f,0.88930f,0.99228f,1.32682f}, 
      {460,0.37812f,1.17812f,1.23100f,0.90612f,1.00463f,1.32355f}, 
      {465,0.40300f,1.16336f,1.23300f,0.90990f,1.00188f,1.29838f}, 
      {470,0.42869f,1.14861f,1.23800f,0.91368f,0.99913f,1.27322f}, 
      {475,0.45517f,1.15392f,1.24090f,0.93238f,1.01326f,1.27061f}, 
      {480,0.48242f,1.15923f,1.23900f,0.95109f,1.02739f,1.26800f}, 
      {485,0.51042f,1.12367f,1.22920f,0.93536f,1.00409f,1.22291f}, 
      {490,0.53913f,1.08811f,1.20700f,0.91963f,0.98078f,1.17783f}, 
      {495,0.56854f,1.09082f,1.16900f,0.93843f,0.99379f,1.17186f}, 
      {500,0.59861f,1.09354f,1.12100f,0.95724f,1.00680f,1.16589f}, 
      {505,0.62932f,1.08578f,1.06980f,0.96169f,1.00688f,1.15146f}, 
      {510,0.66064f,1.07802f,1.02300f,0.96613f,1.00695f,1.13702f}, 
      {515,0.69253f,1.06296f,0.98810f,0.96871f,1.00341f,1.11181f}, 
      {520,0.72496f,1.04790f,0.96900f,0.97129f,0.99987f,1.08659f}, 
      {525,0.75790f,1.06239f,0.96780f,0.99614f,1.02098f,1.09552f}, 
      {530,0.79133f,1.07689f,0.98000f,1.02099f,1.04210f,1.10445f}, 
      {535,0.82519f,1.06047f,0.99940f,1.01427f,1.03156f,1.08367f}, 
      {540,0.85947f,1.04405f,1.02100f,1.00755f,1.02102f,1.06289f}, 
      {545,0.89412f,1.04225f,1.03950f,1.01536f,1.02535f,1.05596f}, 
      {550,0.92912f,1.04046f,1.05200f,1.02317f,1.02968f,1.04904f}, 
      {555,0.96442f,1.02023f,1.05670f,1.01159f,1.01484f,1.02452f}, 
      {560,1.00000f,1.00000f,1.05300f,1.00000f,1.00000f,1.00000f}, 
      {565,1.03582f,0.98167f,1.04110f,0.98868f,0.98608f,0.97808f}, 
      {570,1.07184f,0.96334f,1.02300f,0.97735f,0.97216f,0.95616f}, 
      {575,1.10803f,0.96061f,1.00150f,0.98327f,0.97482f,0.94914f}, 
      {580,1.14436f,0.95788f,0.97800f,0.98918f,0.97749f,0.94213f}, 
      {585,1.18080f,0.92237f,0.95430f,0.96208f,0.94590f,0.90605f}, 
      {590,1.21731f,0.88686f,0.93200f,0.93499f,0.91432f,0.86997f}, 
      {595,1.25386f,0.89346f,0.91220f,0.95593f,0.92926f,0.87112f}, 
      {600,1.29043f,0.90006f,0.89700f,0.97688f,0.94419f,0.87227f}, 
      {605,1.32697f,0.89803f,0.88830f,0.98478f,0.94780f,0.86684f}, 
      {610,1.36346f,0.89599f,0.88400f,0.99269f,0.95140f,0.86140f}, 
      {615,1.39988f,0.88649f,0.88190f,0.99155f,0.94680f,0.84861f}, 
      {620,1.43618f,0.87699f,0.88100f,0.99042f,0.94220f,0.83581f}, 
      {625,1.47235f,0.85494f,0.88060f,0.97382f,0.92334f,0.81164f}, 
      {630,1.50836f,0.83289f,0.88000f,0.95722f,0.90448f,0.78747f}, 
      {635,1.54418f,0.83494f,0.87860f,0.97290f,0.91389f,0.78587f}, 
      {640,1.57979f,0.83699f,0.87800f,0.98857f,0.92330f,0.78428f}, 
      {645,1.61516f,0.81863f,0.87990f,0.97262f,0.90592f,0.76614f}, 
      {650,1.65028f,0.80027f,0.88200f,0.95667f,0.88854f,0.74801f}, 
      {655,1.68510f,0.80121f,0.88200f,0.96929f,0.89586f,0.74562f}, 
      {660,1.71963f,0.80215f,0.87900f,0.98190f,0.90317f,0.74324f}, 
      {665,1.75383f,0.81246f,0.87220f,1.00597f,0.92133f,0.74873f}, 
      {670,1.78769f,0.82278f,0.86300f,1.03003f,0.93950f,0.75422f}, 
      {675,1.82118f,0.80281f,0.85300f,1.01068f,0.91953f,0.73499f}, 
      {680,1.85429f,0.78284f,0.84000f,0.99133f,0.89956f,0.71576f}, 
      {685,1.88701f,0.74003f,0.82210f,0.93257f,0.84817f,0.67714f}, 
      {690,1.91931f,0.69721f,0.80200f,0.87381f,0.79677f,0.63852f}, 
      {695,1.95118f,0.70665f,0.78240f,0.89492f,0.81258f,0.64464f}, 
      {700,1.98261f,0.71609f,0.76300f,0.91604f,0.82840f,0.65076f}, 
      {705,2.01359f,0.72979f,0.74360f,0.92246f,0.83842f,0.66573f}, 
      {710,2.04409f,0.74349f,0.72400f,0.92889f,0.84844f,0.68070f}, 
      {715,2.07411f,0.67977f,0.70400f,0.84872f,0.77539f,0.62256f}, 
      {720,2.10365f,0.61604f,0.68300f,0.76854f,0.70235f,0.56443f}, 
      {725,2.13268f,0.65745f,0.66300f,0.81683f,0.74768f,0.60343f}, 
      {730,2.16120f,0.69886f,0.64400f,0.86511f,0.79301f,0.64242f}, 
      {735,2.18920f,0.72486f,0.62800f,0.89546f,0.82147f,0.66697f}, 
      {740,2.21667f,0.75087f,0.61500f,0.92580f,0.84993f,0.69151f}, 
      {745,2.24361f,0.69340f,0.60200f,0.85405f,0.78437f,0.63890f}, 
      {750,2.27000f,0.63593f,0.59200f,0.78230f,0.71880f,0.58629f}, 
      {755,2.29585f,0.55005f,0.58500f,0.67961f,0.62337f,0.50623f}, 
      {760,2.32115f,0.46418f,0.58100f,0.57692f,0.52793f,0.42617f}, 
      {765,2.34589f,0.56612f,0.58000f,0.70307f,0.64360f,0.51985f}, 
      {770,2.37008f,0.66805f,0.58200f,0.82923f,0.75927f,0.61352f}, 
      {775,2.39370f,0.65094f,0.58500f,0.80599f,0.73872f,0.59838f}, 
      {780,2.41675f,0.63383f,0.59100f,0.78274f,0.71818f,0.58324f}};
 
 

/************************ exported functions */
int corCIEXYZtoCIERGB(float X,float Y, float Z, float* R, float* G, float* B){
    double m[3*3] = {2.960135, -0.471621, -0.563455, -0.500461, 1.287182, 0.086082, 0.036281, -0.052922, 0.528317};
    *R = (float) (m[0]*X+m[1]*Y+m[2]*Z);
    *G = (float) (m[3]*X+m[4]*Y+m[5]*Z);
    *B = (float) (m[6]*X+m[7]*Y+m[8]*Z);
    return 1;
}

int corCIERGBtoCIEXYZ(float r_bar, float g_bar, float b_bar, float* x_bar, float* y_bar, float* z_bar) {
	double m[3*3] = { 0.490, 0.310, 0.200,  0.177, 0.813, 0.011, 0.000, 0.010, 0.990 }; 
	*x_bar = (float) (m[0]*r_bar+m[1]*g_bar+m[2]*b_bar);
	*y_bar = (float) (m[3]*r_bar+m[4]*g_bar+m[5]*b_bar);
	*z_bar = (float) (m[6]*r_bar+m[7]*g_bar+m[8]*b_bar);
	return 1;
}

int corCIEXYZtoxyY(float X, float Y, float Z,  float* x, float* y ) {
    double sum = (double)X+Y+Z;
    if (sum<1.e-6) return 0;
    *x = (float)(X/sum);
    *y = (float)(Y/sum);
    return 1;
}


int corCIExyYtoXYZ(float x, float y, float Y, float* X, float* Z) {
  double scale = (double)Y/y;
  double z = 1.0-x-y;
  if (y<1.e-6f) return 0;
  *X = (float)(x*scale);
  *Z = (float)(z*scale);
  return 1;
}

static double gamma_sRGB(double x){
	double ft,t = (x>0)?x:-x;
	if (t>0.0031308) 
		ft = 1.055*pow(t,1.0/2.4)-0.055;
	else                  
		ft = 12.92*t;

	return (x>0)?ft:-ft;
}


/* Usar essa tambem e fechou! T0 */
/* r,g,b from 0 to 1 */ 
int corCIEXYZtosRGB(float X, float Y, float Z, float* pR, float* pG, float* pB, int reference_light) {
  double r,g,b;
  int error = 0;
  if (reference_light==D50) {  
    r = 3.3921940*X - 1.6168667*Y - 0.4906146*Z;
    g =-0.9787684*X + 1.9161415*Y + 0.0334540*Z;
    b = 0.0719453*X - 0.2289914*Y + 1.4052427*Z;
  } else {  /* default D65 */
    r = 3.2404542*X - 1.5371385*Y - 0.4985314*Z;
    g =-0.9692660*X + 1.8760108*Y + 0.0415560*Z;
    b = 0.0556434*X - 0.2040259*Y + 1.0572252*Z;
  }

  r = gamma_sRGB(r);
  g = gamma_sRGB(g);
  b = gamma_sRGB(b);

  *pR = (float) r;
  *pG = (float) g;
  *pB = (float) b;

  if (r<0||g<0||b<0||r>1||g>1||b>1)  error = 1;

  return error;
}

static double inv_gamma_sRGB( float x) {
	double ft,t=(double) (x>0)?x:-x;
	if ( t > 0.04045 ) 
	   ft = pow((t+0.055)/1.055,2.4);
	else
           ft =  t/12.92;
           
    return (x>0)?ft:-ft;
}

   
int corsRGBtoCIEXYZ(float R, float G, float B, float* X, float* Y, float* Z, int reference_light){
   double Rc = inv_gamma_sRGB(R);
   double Gc = inv_gamma_sRGB(G);
   double Bc = inv_gamma_sRGB(B);

   *X = (float) (Rc*0.4124564 + Gc*0.3575761 + Bc*0.1804375);
   *Y = (float) (Rc*0.2126729 + Gc*0.7151522 + Bc*0.0721750);
   *Z = (float) (Rc*0.0193339 + Gc*0.1191920 + Bc*0.9503041);

  return (*X<0||*Y<0||*Z<0) ? 0 : 1;
}

static double gamma_Lab(double t) {
	double ft, e=216.0/24389, k= 24389.0/27;
	if (t>e) 
		ft=pow(t,1.0/3); 
	else
		ft=(k*t+16)/116;
	return ft;
}

int corCIEXYZtoLab(float X, float Y, float Z, float* L, float* a, float* b, int reference_light) {
  double xr = (double)X/reference_white[reference_light][0];
  double yr = (double)Y/reference_white[reference_light][1];
  double zr = (double)Z/reference_white[reference_light][2];

  double fx = gamma_Lab(xr);
  double fy = gamma_Lab(yr);
  double fz = gamma_Lab(zr);

  *L = (float)(116*fy-16);
  *a = (float)(500*(fx-fy));
  *b = (float)(200*(fy-fz));

  return (*L<0||*L>100)?0:1;
}

int corCIELabtoXYZ(float L, float a, float b, float* X, float* Y, float* Z, int reference_light) {
  double fx,fy,fz, fx3,fy3,fz3, xr,yr,zr;
  double e=216.0/24389;
  double k=24389.0/27;

  fy = (L + 16.0)/116;
  fx = a/500.0 + fy;
  fz = fy - b/200;

  fx3 = fx*fx*fx;
  fy3 = fy*fy*fy;
  fz3 = fz*fz*fz;

  xr=(fx3>e)?fx3:(116*fx-16)/k;
  yr=((double)L>k*e)?fy3:L/k;
  zr=(fz3>e)?fz3:(116*fz-16)/k;

  *X = (float) (reference_white[reference_light][0] * xr);
  *Y = (float) (reference_white[reference_light][1] * yr);
  *Z = (float) (reference_white[reference_light][2] * zr);

  return (*X<0||*Y<0||*Z<0) ? 0 : 1;
}


float corDelta_2000_Lab( float L1, float a1, float b1, float L2, float a2, float b2 )
{
	float C1, C2;
	float h1, h2;
	float dL, dC, dH;
	float dsq;

	/* Compute Cromanance and Hue angles */
	{
		float C1ab, C2ab;
		float Cab, Cab7, G;
		float var_a1, var_a2;

		C1ab = (float)sqrt(a1*a1 + b1*b1);
		C2ab = (float)sqrt(a2*a2 + b2*b2);
		Cab = (C1ab + C2ab)/2;
		Cab7 = (float) pow(Cab,7.0);
		G =  (float) (0.5 * (1.0 - sqrt(Cab7/(Cab7 + 6103515625.0))));
		var_a1 = (1 + G) * a1;
		var_a2 = (1 + G) * a2;
		C1 = (float) sqrt(var_a1 * var_a1 + b1*b1);
		C2 = (float) sqrt(var_a2 * var_a2 + b2*b2);

		if (C1 < 1e-9f)
			h1 = 0;
		else {
			h1 = (float) RAD2DEG(atan2(b1, var_a1));
			if (h1 < 0)
				h1 += 360;
		}

		if (C2 < 1e-9f)
			h2 = 0;
		else {
			h2 = (float) RAD2DEG(atan2(b2, var_a2));
			if (h2 < 0)
				h2 += 360;
		}
	}

	/* Compute delta L, C and H */
	{
		float dh;

		dL = L2 - L2;
		dC = C2 - C1;
		if (C1 < 1e-6f || C2 < 1e-6f) {
			dh = 0;
		} else {
			dh = h2 - h1;
			if (dh > 180)
				dh -= 360;
			else if (dh < -180)
				dh += 360;
		}

		dH = (float) (2 * sqrt(C1 * C2) * sin(DEG2RAD(0.5 * dh)));
	}

	{
		float L, C, h, T;
		float hh, ddeg;
		float C7, RC, L50sq, SL, SC, SH, RT;
		float dLsq, dCsq, dHsq, RCH;

		L = (L1  + L2)/2;
		C = (C1 + C2)/2;
		if (C1 < 1e-6f || C2 < 1e-6f) {
			h = h1 + h2;
		} else {
			h = h1 + h2;
			if (fabs(h1 - h2) > 180) {
				if (h < 360)
					h += 360;
				else if (h >= 360)
					h -= 360;
			}
			h *= 0.5f;
		}
		T = (float)(1.0 - 0.17*cos(DEG2RAD(h-30)) + 0.24*cos(DEG2RAD(2*h))
			            + 0.32*cos(DEG2RAD(3*h+6)) - 0.2*cos(DEG2RAD(4*h-63)));
		hh = (h - 275)/25;
		ddeg = (float) (30*exp(-hh * hh));
		C7 = (float) pow(C,7.0);
		RC = (float) (2*sqrt(C7/(C7 + 6103515625.0)));
		L50sq = (L - 50) * (L - 50);
		SL = (float)(1 + (0.015 * L50sq)/sqrt(20.0 + L50sq));
		SC = (float)(1+0.045*C);
		SH = (float)(1+0.015*C*T);
		RT = (float)(-sin(DEG2RAD(2*ddeg))*RC);

		dLsq = dL/SL;
		dCsq = dC/SC;
		dHsq = dH/SH;

		RCH = RT * dCsq * dHsq;

		dLsq *= dLsq;
		dCsq *= dCsq;
		dHsq *= dHsq;

		dsq = dLsq + dCsq + dHsq + RCH;
	}

	return dsq;

}

int corGetCIExyz(float lambda, float* x_bar, float* y_bar, float* z_bar)
{
	 if (lambda<380.01 || lambda>779.99) {
		if (x_bar) *x_bar=0;
	    if (y_bar) *y_bar=0;
	    if (z_bar) *z_bar=0;
	 	return 0;
	} else {
		int   lambda_i = (int) lambda;
		float delta = lambda - lambda_i;
	    int   i = lambda_i-380;
		if (x_bar) *x_bar= spec[i].x_bar+delta*(spec[i+1].x_bar-spec[i].x_bar);
		if (y_bar) *y_bar= spec[i].y_bar+delta*(spec[i+1].y_bar-spec[i].y_bar);
		if (z_bar) *z_bar= spec[i].z_bar+delta*(spec[i+1].z_bar-spec[i].z_bar);
		return 1;
	 }
 }


float corGetD65(float lambda)
{
	 if (lambda<380.01 || lambda>779.99)  
		 return 0;
     else {
    	int   lambda_i = (int) lambda;
		float delta = lambda - lambda_i;
		int i = lambda_i-380;
		return spec[i].D65+delta*(spec[i+1].D65-spec[i].D65);
	}
}

float corGetA(float lambda)
{
	 if (lambda<380.01 || lambda>779.99)  
		 return 0;
     else {
    	int   lambda_i = (int) lambda;
		float delta = lambda - lambda_i;
		int i = lambda_i-380;
		return spec[i].A+delta*(spec[i+1].A-spec[i].A);
	}
}


float corGetD50(float lambda)
{
	 if (lambda<380.01 || lambda>779.99)  
		 return 0;
     else {
		 float delta;
		 int i;
		 for (i=0;i<96;i++) 
			 if (lambda > illum[i].lambda) break;
		delta = lambda - illum[i].lambda;
		return illum[i].D50+delta*(illum[i+1].D50-illum[i].D50);
	}
}


float corGetIllum(float lambda, int reference_light) {
	if (reference_light==A)  return corGetA(lambda); 
	else if (reference_light==D50) return corGetD50(lambda);
	else return corGetD65(lambda);
}

int corGetCIExyfromLambda(float lambda, float* x, float* y) {
    float x_bar,y_bar,z_bar;
	if (corGetCIExyz(lambda,&x_bar,&y_bar,&z_bar)) {  
		*x = x_bar/(x_bar+y_bar+z_bar);  /* Cromaticity coord.  */
		*y = y_bar/(x_bar+y_bar+z_bar);
 		return 1;
	} else 
		return 0;
 }

static float getFunctionValue(float x, float xmin, int npoints, float delta_x, float* yv)
{
	float xmax = xmin+(npoints-1)*delta_x;
	float y=0;
	if (x>=xmin && x<=xmax) { 
		 int i = (int) floor((x-xmin)/delta_x);
		 float r = (x - (xmin+i*delta_x))/delta_x;
		 if (i==npoints-1) 
			 y=yv[i];
		 else 
			 y=(1-r)*yv[i]+r*yv[i+1];
	 }
	return y;
}
 

/* Deve ser essa funcao aqui! T0 */
int corCIEXYZfromSurfaceReflectance(float lambda_min, int n_points, int delta_lambda, float* reflectance, float *X, float *Y, float* Z, int reference_light) 
{
        float sum_x=0, sum_y=0, sum_z=0, sum_w=0;
        float lambda, lambda_max = lambda_min + (n_points-1)*delta_lambda;

// room for some optimizations?
// 	for (lambda=lambda_min; lambda<lambda_max; lambda += delta_lambda) {
	for (lambda=lambda_min; lambda<lambda_max; lambda += 1) {
		float Lw = corGetIllum(lambda, reference_light);
		float betha = getFunctionValue(lambda,lambda_min,n_points,delta_lambda,reflectance);
		float x_bar,y_bar,z_bar;
		corGetCIExyz(lambda,&x_bar,&y_bar,&z_bar);
		sum_x += Lw*betha*x_bar;
		sum_y += Lw*betha*y_bar;
		sum_z += Lw*betha*z_bar;
		sum_w += Lw*y_bar;
	}
	*X = sum_x/sum_w;
	*Y = sum_y/sum_w;      
	*Z = sum_z/sum_w;
	return 1;
}

int corCIELabtosRGB(float L, float a, float b, float* R, float* G, float* B, int reference_light) {
	float X,Y,Z;
	int ok=corCIELabtoXYZ(L,a,b,&X,&Y,&Z,reference_light);
	if (ok) 
		ok = corCIEXYZtosRGB(X,Y,Z,R,G,B,reference_light);
	else {*R=*G=*B=0;}
	return ok;
}

int corCIEab_tosRGBwithMaxL(float a, float b, float* R, float* G, float* B, float* L, int reference_light) {
	float R1=0,G1=0,B1=0,lum=0;
	int ok=0;

	*R=0;*G=0;*B=0;*L=0;

	/* while the L is not rendering sRGB color */
	for (lum=0; !ok && lum<=100; lum+=1) 
		ok = corCIELabtosRGB(lum,a,b,&R1,&G1,&B1,reference_light);

	/* while L can be increased */
	if (ok) {
	    for (;ok && lum<=100;lum+=1) 
		    ok = corCIELabtosRGB(lum,a,b,&R1,&G1,&B1,reference_light);
	    *R=R1; *G=G1; *B=B1; *L=lum;
	}
	return ok;	
}

#undef RAD2DEG
#undef DEG2RAD

