#ifndef _CIMAGE_H_
#define _CIMAGE_H_

// #include "image.h"
#include "color.h" 

typedef struct _pixel {
  int x,y;
} Pixel;

typedef struct _image {
  int *val;
  int ncols,nrows;
  int *tbrow;
} Image;

typedef struct cimage {
  Image *C[3];
} CImage;

Image  *CreateImage(int ncols,int nrows);
void    DestroyImage(Image **img);
Image  *Scale(Image *img, float Sx, float Sy); 
char    ValidPixel(Image *img, int x, int y);


CImage *CreateCImage(int ncols, int nrows);
void    DestroyCImage(CImage **cimg);
CImage *ReadCImage(char *filename);
void    WriteCImage(CImage *cimg, char *filename);
CImage *CScale(CImage *cimg, float Sx, float Sy);
CImage *CImageRGBtoYCbCr(CImage *cimg);
CImage *CImageYCbCrtoRGB(CImage *cimg);
CImage *CImageRGBtoHSV(CImage *cimg);
CImage *CImageHSVtoRGB(CImage *cimg);

#endif
