<ncl id="radioWidget" xmlns="http://www.ncl.org.br/NCL3.0/EDTVProfile">
  <head>
    <regionBase>
      <region id="rgBackground" width="600" height="400" zIndex="1">
        <region id="rgCurrent" width="316" height="96" left="63" top="127" zIndex="2"/>
        <region id="rgPrevOrNext" width="232" height="49" left="75" top="224" zIndex="2"/>
        <region id="rgWeather" width="146" height="102" left="379" top="140" zIndex="2"/>
        <region id="rgPrev" width="25" height="25" left="318" top="252" zIndex="2"/>
        <region id="rgNext" width="25" height="25" left="350" top="252" zIndex="2"/>
        <region id="rgQuit" width="25" height="25" left="500" top="252" zIndex="2"/>
      </region>
    </regionBase>
    <descriptorBase>
      <descriptor id="dBackground" region="rgBackground"/>
      <descriptor id="dCurrent" region="rgCurrent"/>
      <descriptor id="dPrevOrNext" region="rgPrevOrNext"/>
      <descriptor id="dWeather" region="rgWeather"/>
      <descriptor id="dPrev" region="rgPrev"
                  focusIndex="1" moveLeft="3" moveRight="2" focusBorderWidth="0"
                  focusSrc="media/b-prev-focus.png"
                  focusSelSrc="media/b-prev-press.png"/>
      <descriptor id="dNext" region="rgNext"
                  focusIndex="2" moveLeft="1" moveRight="3" focusBorderWidth="0"
                  focusSrc="media/b-next-focus.png"
                  focusSelSrc="media/b-next-press.png"/>
      <descriptor id="dQuit" region="rgQuit"
                  focusIndex="3" moveLeft="2" moveRight="1" focusBorderWidth="0"
                  focusSrc="media/b-quit-focus.png"/>
    </descriptorBase>
    <connectorBase>
      <causalConnector id="onSelectionStopStart">
        <simpleCondition role="onSelection"/>
        <compoundAction operator="seq">
          <simpleAction role="stop" qualifier="seq" max="unbounded"/>
          <simpleAction role="start" qualifier="seq" max="unbounded"/>
        </compoundAction>
      </causalConnector>
      <causalConnector id="onSelectionStop">
        <simpleCondition role="onSelection"/>
        <simpleAction role="stop" qualifier="seq" max="unbounded"/>
      </causalConnector>
      <causalConnector id="onSetTestStopStart">
        <connectorParam name="val"/>
        <compoundCondition operator="and">
          <simpleCondition role="onEndAttribution"/>
          <assessmentStatement comparator="eq">
            <attributeAssessment role="test" eventType="attribution"/>
            <valueAssessment value="$val"/>
          </assessmentStatement>
        </compoundCondition>
        <compoundAction operator="seq">
          <simpleAction role="stop" max="unbounded" qualifier="seq"/>
          <simpleAction role="start" max="unbounded" qualifier="seq"/>
        </compoundAction>
      </causalConnector>
    </connectorBase>
  </head>
  <body>
    <port id="pBackground" component="background"/>
    <port id="pCurrMusic" component="currMusic"/>
    <port id="pNextMusic" component="nextMusic"/>
    <port id="pPrev" component="prev"/>
    <port id="pNext" component="next"/>
    <port id="pQuit" component="quit"/>
    <port id="pWeather" component="weather"/>
    <media id="background" src="media/background.png" descriptor="dBackground"/>
    <media id="currMusic" src="media/curr-music.png" descriptor="dCurrent"/>
    <media id="nextMusic" src="media/next-music.png" descriptor="dPrevOrNext"/>
    <media id="prevMusic" src="media/prev-music.png" descriptor="dPrevOrNext"/>
    <media id="prev" src="media/b-prev.png" descriptor="dPrev"/>
    <media id="next" src="media/b-next.png" descriptor="dNext"/>
    <media id="quit" src="media/b-quit.png" descriptor="dQuit"/>
    <link xconnector="onSelectionStopStart">
      <bind role="onSelection" component="prev"/>
      <bind role="stop" component="nextMusic"/>
      <bind role="stop" component="prevMusic"/>
      <bind role="start" component="prevMusic"/>
    </link>
    <link xconnector="onSelectionStopStart">
      <bind role="onSelection" component="next"/>
      <bind role="stop" component="nextMusic"/>
      <bind role="stop" component="prevMusic"/>
      <bind role="start" component="nextMusic"/>
    </link>
    <link xconnector="onSelectionStop">
      <bind role="onSelection" component="quit"/>
      <bind role="stop" component="quit"/>
      <bind role="stop" component="prev"/>
      <bind role="stop" component="next"/>
      <bind role="stop" component="currMusic"/>
      <bind role="stop" component="prevMusic"/>
      <bind role="stop" component="nextMusic"/>
      <bind role="stop" component="weather"/>
      <bind role="stop" component="background"/>
    </link>
    <context id="weather">
      <port id="pUpdateWeather" component="updateWeather"/>
      <media id="updateWeather" src="media/update-weather.lua">
        <property name="city"/>
      </media>
      <media id="rio" src="media/weather-rio.png" descriptor="dWeather"/>
      <media id="sampa" src="media/weather-sampa.png" descriptor="dWeather"/>
      <link xconnector="onSetTestStopStart">
        <bind role="onEndAttribution" component="updateWeather" interface="city"/>
        <bind role="test" component="updateWeather" interface="city">
          <bindParam name="val" value="rio"/>
        </bind>
        <bind role="stop" component="sampa"/>
        <bind role="start" component="rio"/>
      </link>
      <link xconnector="onSetTestStopStart">
        <bind role="onEndAttribution" component="updateWeather" interface="city"/>
        <bind role="test" component="updateWeather" interface="city">
          <bindParam name="val" value="sampa"/>
        </bind>
        <bind role="stop" component="rio"/>
        <bind role="start" component="sampa"/>
      </link>
    </context>
  </body>
</ncl>
