<?xml version="1.0" encoding="ISO-8859-1"?>
<ncl id="demo1" xmlns="http://www.ncl.org.br/NCL3.1/DRProfile">
<head>

  <connectorBase>
    <causalConnector id="onBeginStart">
      <simpleCondition role="onBegin" />
      <simpleAction role="start" max="unbounded" />
    </causalConnector>

    <causalConnector id="onSelectionStop">
      <connectorParam name="value"/>
      <simpleCondition role="onSelection"/>
      <simpleAction role="stop" max="unbounded" />
    </causalConnector>

    <causalConnector id="onSelectionStopStart">
      <connectorParam name="value"/>
      <simpleCondition role="onSelection"/>
      <compoundAction operator="seq">
        <simpleAction role="stop" max="unbounded" />
        <simpleAction role="start" max="unbounded" />
      </compoundAction>
    </causalConnector>
    
    <causalConnector id="onSelectionVarStart">
      <compoundCondition operator="and">
	<simpleCondition role="onSelection" />
	<assessmentStatement comparator="eq">
	  <attributeAssessment role="var" attributeType="nodeProperty" eventType="attribution" />
	  <valueAssessment value="true"/>
	</assessmentStatement>
      </compoundCondition>
      <compoundAction operator="seq">
        <simpleAction role="stop" max="unbounded" />
        <simpleAction role="start" max="unbounded" />
      </compoundAction>
    </causalConnector>	

    <causalConnector id="onSelectionNotVarStart">
      <compoundCondition operator="and">
	<simpleCondition role="onSelection" />
	<assessmentStatement comparator="eq">
	  <attributeAssessment role="var" attributeType="nodeProperty" eventType="attribution"/>
	  <valueAssessment value="false"/>
	</assessmentStatement>
      </compoundCondition>
      <compoundAction operator="seq">
        <simpleAction role="stop" max="unbounded" />
        <simpleAction role="start" max="unbounded" />
      </compoundAction>
    </causalConnector>	
    
  </connectorBase>

</head>

<body>
  <port id="entrada" component="ibbTest"/>

  <!-- Test to check if there is Internet connection to the station website -->
  <media id="ibbTest" src="ping.lua">
    <property name="left" value="2%" />
    <property name="top" value="23%" />
    <property name="width" value="90%" />
    <property name="height" value="10%" />
    <property name="zIndex" value="1" />
    <property name="has_connection" />
  </media>

  <!-- menu itens -->
  <media id="m1" src="bemvindo.txt">
    <property name="right" value="2%" />
    <property name="top" value="40%" />
    <property name="width" value="15%" />
    <property name="height" value="10%" />
    <property name="zIndex" value="0" />

    <property name="fontColor" value="yellow"/>
    <property name="fontStyle" value="text-align:center"/>
    <property name="fontSize" value="17"/>

    <property name="focusIndex" value="0"/>
    <property name="moveUp" value="2"/>
    <property name="moveDown" value="1"/>
    
  </media>

  <media id="m2" src="informacoes.txt">
    <property name="right" value="2%" />
    <property name="top" value="60%" />
    <property name="width" value="15%" />
    <property name="height" value="10%" />
    <property name="zIndex" value="0" />

    <property name="fontColor" value="yellow"/>
    <property name="fontStyle" value="text-align:center"/>
    <property name="fontSize" value="17"/>
    
    <property name="focusIndex" value="1"/>
    <property name="moveUp" value="0"/>
    <property name="moveDown" value="2"/>
    <property name="moveLeft" value="3"/>
  </media>

  <media id="m3" src="sair.txt">
    <property name="right" value="2%" />
    <property name="top" value="80%" />
    <property name="width" value="15%" />
    <property name="height" value="10%" />
    <property name="zIndex" value="0" />

    <property name="fontColor" value="yellow"/>
    <property name="fontStyle" value="text-align:center"/>
    <property name="fontSize" value="17"/>

    <property name="focusIndex" value="2"/>
    <property name="moveUp" value="1"/>
    <property name="moveDown" value="0"/>    
  </media>

  <!-- medias -->
  <media id="logo" src="logo.bpg">
    <property name="left" value="5%" />
    <property name="top" value="5%" />
    <property name="width" value="90%" />
    <property name="height" value="20%" />
    <property name="zIndex" value="0" />
  </media>
  
  <media id="c1" src="bemvindo.bpg">
    <property name="left" value="2%" />
    <property name="top" value="35%" />
    <property name="width" value="75%" />
    <property name="height" value="64%" />
    <property name="zIndex" value="0" />
  </media>

  <media id="c2" src="http://www.telemidia.puc-rio.br/~rafaeldiniz/radio">
    <property name="left" value="2%" />
    <property name="top" value="35%" />
    <property name="width" value="75%" />
    <property name="height" value="64%" />
    <property name="zIndex" value="0" />
    <property name="focusIndex" value="3"/>
    <property name="moveRight" value="1"/>
  </media>

  <media id="c3" src="info.txt">
    <property name="left" value="2%" />
    <property name="top" value="35%" />
    <property name="width" value="70%" />
    <property name="height" value="64%" />
    <property name="zIndex" value="0" />
    
    <property name="fontColor" value="yellow"/>
    <property name="fontStyle" value="text-align:justify"/>
    <property name="fontSize" value="17"/>
  </media>


  <link id="linkInicio" xconnector="onBeginStart">
    <bind role="onBegin" component="ibbTest" />
    <bind role="start"   component="logo" />
    <bind role="start"   component="c1" />
    <bind role="start"   component="m1" />
    <bind role="start"   component="m2" />
    <bind role="start"   component="m3" />
  </link>

  <link id="link1" xconnector="onSelectionStopStart">
    <bind role="onSelection" component="m1" />
    <bind role="start" component="c1" />
    <bind role="stop" component="c2" />
    <bind role="stop" component="c3" />
  </link>

  <link id="ibbLink" xconnector="onSelectionVarStart">
    <bind role="onSelection" component="m2" />
    <bind role="var" component="ibbTest" interface="has_connection"/>			
    <bind role="start" component="c2" />
    <bind role="stop" component="c1" />
    <bind role="stop" component="c3" />
  </link>

  <link id="ibbLink2" xconnector="onSelectionNotVarStart">
    <bind role="onSelection" component="m2" />
    <bind role="var" component="ibbTest" interface="has_connection"/>			
    <bind role="start" component="c3"/>
    <bind role="stop" component="c1" />
    <bind role="stop" component="c2" />
  </link>

  <link id="linkFim" xconnector="onSelectionStop">
    <bind role="onSelection" component="m3" />
    <bind role="stop" component="logo" />
    <bind role="stop" component="m1" />
    <bind role="stop" component="m2" />
    <bind role="stop" component="m3" />
    <bind role="stop" component="c1" />
    <bind role="stop" component="c2" />
    <bind role="stop" component="c3" />
    <bind role="stop" component="ibbTest" />
  </link>

</body>
</ncl>
