local HOST = 'www.telemidia.puc-rio.br'
local PORT = 80
local TIMEOUT = 10 -- seconds


local t0 = event.uptime ()
local function ack (e)
   local HAS_CONNECTION = false
   local dt = (event.uptime () - t0) / 1000
   if e.connection then
      msg = ('You have connection to the TeleMidia WebSite! Connection established in %gs'):format (dt)
      HAS_CONNECTION = true
   else
      msg = ("You DON'T have a connection after %gs"):format (dt)
   end

   print (msg)
   canvas:attrColor ('yellow')
   local W,H = canvas:attrSize ()
   local w,h = canvas:measureText (msg)
   canvas:drawText ((W - w) / 2, (H - h) / 2, msg)
   canvas:flush ()

   local e = {
      class='ncl',
      type='attribution',
      action='start',
      name='has_connection',
      value=tostring (HAS_CONNECTION),
   }
   assert (event.post (e))
   e.action = 'stop'
   assert (event.post (e))
end

event.register (ack, {class='tcp', type='connect', host=HOST, port=PORT})
event.post {
   class='tcp',
   type='connect',
   host=HOST,
   port=PORT,
   timeout=TIMEOUT
}
