/*
 * Decompiled with CFR 0.152.
 */
package br.ufma.deinf.laws.ncleclipse.club.wizards;

import br.ufma.deinf.laws.ncleclipse.club.ClubNCLMessages;
import br.ufma.deinf.laws.ncleclipse.club.rss.RSSItem;
import br.ufma.deinf.laws.ncleclipse.club.rss.RSSReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.xml.sax.SAXException;

public class NCLClubListExamplesPage
extends WizardPage {
    private List listExamples;
    private Browser selectedDescription;
    private ISelection selection;
    private RSSReader rssReader;
    private Vector<RSSItem> items;
    private RSSItem selectedItem;

    public NCLClubListExamplesPage(ISelection selection) {
        super("wizardPage");
        this.setTitle(ClubNCLMessages.getInstance().getString("WizardPage.title"));
        this.setDescription(ClubNCLMessages.getInstance().getString("WizardPage.description"));
        this.selection = selection;
    }

    public RSSItem getSelectedItem() {
        return this.selectedItem;
    }

    public void setSelectedItem(RSSItem selectedItem) {
        this.selectedItem = selectedItem;
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
    }

    public RSSReader getRssReader() {
        return this.rssReader;
    }

    public void setRssReader(RSSReader rssReader) {
        this.rssReader = rssReader;
    }

    public void createControl(Composite parent) {
        parent.setBounds(0, 0, 800, 500);
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.makeColumnsEqualWidth = true;
        layout.numColumns = 2;
        GridData data = new GridData(1808);
        this.listExamples = new List(container, 2816);
        this.listExamples.setLayoutData((Object)data);
        data = new GridData(1808);
        this.selectedDescription = new Browser(container, 2048);
        this.selectedDescription.setLayoutData((Object)data);
        this.selectedDescription.setBounds(0, 0, 500, 500);
        try {
            URL url = new URL(ClubNCLMessages.getInstance().getString("RSS_LOCATION"));
            this.rssReader = new RSSReader(url);
            this.rssReader.parse();
            this.items = this.rssReader.getRssRoot().getAllItems();
            int i = 0;
            while (i < this.items.size()) {
                this.listExamples.add(this.items.get(i).getTitle());
                ++i;
            }
            this.selectedDescription.setText(ClubNCLMessages.getInstance().getString("SelectedDescription.empty"));
            this.selectedDescription.setSize(200, 200);
            this.listExamples.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent event) {
                    int sel = NCLClubListExamplesPage.this.listExamples.getSelectionIndex();
                    if (sel == -1) {
                        return;
                    }
                    String descr = "";
                    descr = "<img src='" + ((RSSItem)NCLClubListExamplesPage.this.items.get(sel)).getImageUrl().toString() + "'/>";
                    descr = String.valueOf(descr) + ((RSSItem)NCLClubListExamplesPage.this.items.get(sel)).getDescription();
                    NCLClubListExamplesPage.this.selectedDescription.setText(descr);
                    NCLClubListExamplesPage.this.selectedItem = (RSSItem)NCLClubListExamplesPage.this.items.get(sel);
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                    int selectedItem = NCLClubListExamplesPage.this.listExamples.getSelectionIndex();
                    if (selectedItem == -1) {
                        return;
                    }
                    NCLClubListExamplesPage.this.selectedDescription.setText(((RSSItem)NCLClubListExamplesPage.this.items.get(selectedItem)).getDescription());
                }
            });
        }
        catch (MalformedURLException e) {
            this.selectedDescription.setText(ClubNCLMessages.getInstance().getString("SelectedDescription.ConnectionError"));
            e.printStackTrace();
        }
        catch (SAXException e) {
            this.selectedDescription.setText(ClubNCLMessages.getInstance().getString("SelectedDescription.ConnectionError"));
            e.printStackTrace();
        }
        catch (IOException e) {
            this.selectedDescription.setText("NCL Club can't be contacted. Please, check your internet connection. If you are sure that your connection is Ok send an e-mail to ncleclipse@laws.deinf.ufma.br");
            e.printStackTrace();
        }
        container.setBounds(0, 0, 1200, 800);
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    private void initialize() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof IResource) {
                if (obj instanceof IContainer) {
                    IContainer cfr_ignored_0 = (IContainer)obj;
                } else {
                    ((IResource)obj).getParent();
                }
            }
        }
    }

    private void handleBrowse() {
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, "Select new file container");
        if (dialog.open() == 0) {
            Object[] result = dialog.getResult();
            int cfr_ignored_0 = result.length;
        }
    }

    private void dialogChanged() {
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }
}

