/*
 * Decompiled with CFR 0.152.
 */
package br.ufma.deinf.laws.ncl;

import br.ufma.deinf.laws.ncl.AttributeValues;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * Exception performing whole class analysis ignored.
 */
public class DataType {
    public static final int UNKNOWN = -1;
    public static final int ID = 0;
    public static final int STRING = 1;
    public static final int INTEGER = 2;
    public static final int DOUBLE = 3;
    public static final int COORDINATE = 4;
    public static final int TIME = 5;
    public static final int URI = 6;
    public static final int MIME_TYPE = 7;
    public static final int SIZE = 8;
    public static final int XMLNS = 9;
    public static final int QUANTITY = 10;
    public static final int XCONNECTOR = 11;
    public static final int BOOLEAN_OPERATOR = 12;
    public static final int SYNCHRONISM_OPERATOR = 13;
    public static final int INSTANCE = 14;
    public static final int DEVICE = 15;
    public static final int COMPARATOR = 16;
    public static final int SIMPLEACTION_ROLE = 17;
    public static final int SIMPLECONDITION_ROLE = 18;
    public static final int COLOR = 19;
    public static final int EVENT = 20;
    public static final int TRANSITION = 21;
    public static final int KEY = 22;
    public static final int ACTION = 23;
    public static final int TRANSITION_TYPE = 24;
    public static final int TRANSITION_SUBTYPE = 25;
    public static final int DIRECTION = 26;
    public static final int BOOLEAN_VALUE = 27;
    public static final int PROPERTY_NAME = 28;
    public static final int ZINDEX = 29;
    public static final int FIT_VALUE = 30;
    public static final int SCROLL = 31;
    public static final int FONT_VARIANT = 32;
    public static final int FONT_WEIGHT = 33;
    public static final int PLAYER_LIFE = 34;
    public static final int PARAM_VALUES = 35;
    public static final int TRANSITION_BORDER_COLOR = 36;

    public static int getType(String str) {
        if (DataType.isInteger((String)str)) {
            return 2;
        }
        if (DataType.isDouble((String)str)) {
            return 3;
        }
        if (DataType.isCoordinate((String)str)) {
            return 4;
        }
        if (DataType.isId((String)str)) {
            return 0;
        }
        if (DataType.isTime((String)str)) {
            return 5;
        }
        if (DataType.isUri((String)str)) {
            return 6;
        }
        return 1;
    }

    public static boolean isInteger(String str) {
        Pattern p = Pattern.compile("^[0-9]*$");
        Matcher m = p.matcher(str);
        return m.matches();
    }

    public static boolean isString(String str) {
        return true;
    }

    public static boolean isDouble(String str) {
        return true;
    }

    public static boolean isCoordinate(String str) {
        Pattern p = Pattern.compile("^[0-9]*(,[0-9]*){2,}");
        Matcher m = p.matcher(str);
        return m.matches();
    }

    public static boolean isTime(String str) {
        Pattern p = Pattern.compile("^((([01]?[0-9])|2[0-3])[:])?([0-5][0-9][:])?([0-5][0-9])$");
        Pattern p2 = Pattern.compile("^[0-9]*$");
        Pattern p3 = Pattern.compile("^[0-9]+([.][0-9]+)?[s]$");
        Matcher m = p.matcher(str);
        Matcher m2 = p2.matcher(str);
        Matcher m3 = p3.matcher(str);
        return m.matches() && !m2.matches() || m3.matches();
    }

    public static boolean isUri(String str) {
        try {
            URI uri = new URI(URLEncoder.encode(str, "UTF-8"));
            return true;
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean isId(String str) {
        Pattern p = Pattern.compile("^[_a-zA-Z].*$");
        Matcher m = p.matcher(str);
        return m.matches();
    }

    public static boolean isSize(String str) {
        if (DataType.isInteger((String)str)) {
            return true;
        }
        Pattern p = Pattern.compile("^[0-9]*px$");
        Matcher m = p.matcher(str);
        if (m.matches()) {
            return true;
        }
        p = Pattern.compile("^[0-9]*[.]?[0-9]*[%]$");
        m = p.matcher(str);
        return m.matches();
    }

    public static boolean isMIME_TYPE(String value) {
        return true;
    }

    public static boolean isXMLNS(String value) {
        return value.equals("http://www.ncl.org.br/NCL3.0/EDTVProfile") || value.equals("http://www.ncl.org.br/NCL3.0/BDTVProfile") || value.equals("http://www.ncl.org.br/NCL3.0/CausalConnectorProfile") || value.equals("http://www.ncl.org.br/NCL3.0/LanguageProfile");
    }

    public static boolean isInstance(String value) {
        return value.equals("new") || value.equals("instSame") || value.equals("gradSame");
    }

    public static boolean isComparator(String value) {
        Vector values = AttributeValues.getValues((int)16);
        return values.contains(value);
    }

    public static boolean isDataType(int dataType, String value) {
        boolean ok = true;
        switch (dataType) {
            case 4: {
                if (DataType.isCoordinate((String)value)) break;
                ok = false;
                break;
            }
            case 2: {
                if (DataType.isInteger((String)value)) break;
                ok = false;
                break;
            }
            case 1: {
                if (DataType.isString((String)value)) break;
                ok = false;
                break;
            }
            case 3: {
                if (DataType.isDouble((String)value)) break;
                ok = false;
                break;
            }
            case 0: {
                if (DataType.isId((String)value)) break;
                ok = false;
                break;
            }
            case 5: {
                if (DataType.isTime((String)value)) break;
                ok = false;
                break;
            }
            case 6: {
                if (DataType.isUri((String)value)) break;
                ok = false;
                break;
            }
            case 7: {
                if (DataType.isMIME_TYPE((String)value)) break;
                ok = false;
                break;
            }
            case 8: {
                if (DataType.isSize((String)value)) break;
                ok = false;
                break;
            }
            case 9: {
                if (DataType.isXMLNS((String)value)) break;
                ok = false;
                break;
            }
            case 10: {
                if (DataType.isQuantity((String)value)) break;
                ok = false;
                break;
            }
            case 11: {
                if (DataType.isXConnector((String)value)) break;
                ok = false;
                break;
            }
            case 12: {
                if (DataType.isBoleanOperator((String)value)) break;
                ok = false;
                break;
            }
            case 13: {
                if (DataType.isSyncronismOperator((String)value)) break;
                ok = false;
                break;
            }
            case 14: {
                if (DataType.isInstance((String)value)) break;
                ok = false;
                break;
            }
            case 16: {
                if (DataType.isComparator((String)value)) break;
                ok = false;
                break;
            }
            case 19: {
                if (DataType.isColor((String)value)) break;
                ok = false;
                break;
            }
            case 20: {
                if (DataType.isEvent((String)value)) break;
                ok = false;
                break;
            }
            case 21: {
                if (DataType.isTransition((String)value)) break;
                ok = false;
                break;
            }
            case 22: {
                if (DataType.isKey((String)value)) break;
                ok = false;
                break;
            }
            case 23: {
                if (DataType.isAction((String)value)) break;
                ok = false;
                break;
            }
            case 24: {
                if (DataType.isTransitionType((String)value)) break;
                ok = false;
                break;
            }
            case 26: {
                if (DataType.isDirection((String)value)) break;
                ok = false;
                break;
            }
            case 25: {
                if (DataType.isTransitionSubType((String)value)) break;
                ok = false;
                break;
            }
            case 27: {
                if (DataType.isBooleanValue((String)value)) break;
                ok = false;
                break;
            }
            case 28: {
                if (DataType.isPropertyNameValue((String)value)) break;
                ok = false;
                break;
            }
            case 29: {
                if (DataType.isZIndex((String)value)) break;
                ok = false;
                break;
            }
            case 36: {
                if (DataType.isTransitionBorderColor((String)value)) break;
                ok = false;
            }
        }
        return ok;
    }

    private static boolean isTransitionBorderColor(String value) {
        Vector values = AttributeValues.getValues((int)36);
        return values.contains(value);
    }

    private static boolean isPropertyNameValue(String value) {
        return DataType.isId((String)value);
    }

    private static boolean isBooleanValue(String value) {
        Vector values = AttributeValues.getValues((int)27);
        return values.contains(value);
    }

    private static boolean isDirection(String value) {
        Vector values = AttributeValues.getValues((int)26);
        return values.contains(value);
    }

    private static boolean isTransitionSubType(String value) {
        return DataType.isId((String)value);
    }

    private static boolean isTransitionType(String value) {
        Vector values = AttributeValues.getValues((int)24);
        return values.contains(value);
    }

    private static boolean isAction(String value) {
        Vector values = AttributeValues.getValues((int)23);
        return values.contains(value);
    }

    private static boolean isKey(String value) {
        return true;
    }

    private static boolean isTransition(String value) {
        Vector values = AttributeValues.getValues((int)21);
        return values.contains(value);
    }

    private static boolean isEvent(String value) {
        Vector values = AttributeValues.getValues((int)20);
        return values.contains(value);
    }

    private static boolean isColor(String value) {
        Vector values = AttributeValues.getValues((int)19);
        return values.contains(value);
    }

    private static boolean isSyncronismOperator(String value) {
        return value.equals("par") || value.equals("seq");
    }

    private static boolean isBoleanOperator(String value) {
        return value.equals("and") || value.equals("or");
    }

    private static boolean isXConnector(String value) {
        return true;
    }

    private static boolean isQuantity(String value) {
        try {
            Integer t = new Integer(value);
            return t >= 1;
        }
        catch (Exception e) {
            return value.equals("unbounded");
        }
    }

    private static boolean isZIndex(String value) {
        try {
            Integer t = new Integer(value);
            return t >= 0 && t <= 255;
        }
        catch (Exception e) {
            return false;
        }
    }
}

