/*
 * Decompiled with CFR 0.152.
 */
package br.ufma.deinf.laws.ncleclipse.club.rss;

import br.ufma.deinf.laws.ncleclipse.club.rss.RSSChannel;
import br.ufma.deinf.laws.ncleclipse.club.rss.RSSItem;
import br.ufma.deinf.laws.ncleclipse.club.rss.RSSRoot;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.xerces.dom.NamedNodeMapImpl;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RSSReader {
    protected URL url;
    protected RSSRoot rssRoot;
    protected DOMParser parser;
    protected Document doc;
    private boolean log = false;

    public RSSReader() {
    }

    public RSSReader(File file) {
    }

    public RSSReader(URL url) {
        this.url = url;
    }

    public boolean parse() throws SAXException, IOException {
        this.parser = new DOMParser();
        this.parser.parse(new InputSource(this.url.openStream()));
        Document doc = this.parser.getDocument();
        NodeList nodeList = doc.getChildNodes();
        this.parser.parse(new InputSource(this.url.openStream()));
        doc = this.parser.getDocument();
        if (this.log) {
            System.out.println("log#RSSReader::parse # Parsing rss file: " + this.url);
        }
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node.getNodeName().equals("rss")) {
                this.parseRSS(node);
            }
            ++i;
        }
        return true;
    }

    public boolean parse(URL url) throws SAXException, IOException {
        this.url = url;
        this.parse();
        return true;
    }

    protected boolean parseRSS(Node nodeRSS) {
        this.rssRoot = new RSSRoot();
        if (this.log) {
            System.out.println("log#RSSReader::parseRSS # Parsing rss root Element");
        }
        NodeList nodeList = nodeRSS.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node.getNodeName().equals("channel")) {
                this.parseChannel(node);
            }
            ++i;
        }
        return true;
    }

    protected boolean parseChannel(Node nodeChannel) {
        RSSChannel channel = new RSSChannel();
        NodeList nodeList = nodeChannel.getChildNodes();
        if (this.log) {
            System.out.println("log#RSSReader::parseChannel $ Parsing channel element");
        }
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node.getNodeName().equals("title")) {
                channel.setTitle(node.getTextContent());
            } else if (node.getNodeName().equals("link")) {
                try {
                    channel.setLink(new URL(node.getTextContent()));
                }
                catch (MalformedURLException malformedURLException) {
                    System.out.println("MalformedURLException");
                }
                catch (DOMException dOMException) {
                    System.out.println("DOMException");
                }
            } else if (node.getNodeName().equals("description")) {
                channel.setDescription(node.getTextContent());
            } else if (node.getNodeName().equals("language")) {
                channel.setLanguage(node.getTextContent());
            } else if (node.getNodeName().equals("item")) {
                this.parseItem(channel, node);
            }
            ++i;
        }
        this.rssRoot.addChannel(channel);
        return true;
    }

    protected boolean parseItem(RSSChannel channel, Node nodeItem) {
        RSSItem item = new RSSItem();
        NodeList nodeList = nodeItem.getChildNodes();
        if (this.log) {
            System.out.println("log#RSSReader::parseItem $ Parsing item element");
        }
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node.getNodeName().equals("title")) {
                item.setTitle(node.getTextContent());
                if (this.log) {
                    System.out.println("\tTitle = " + item.getTitle());
                }
            } else if (node.getNodeName().equals("link")) {
                try {
                    item.setLink(new URL(node.getTextContent()));
                }
                catch (MalformedURLException malformedURLException) {
                    System.out.println("MalformedURLException");
                }
                catch (DOMException dOMException) {
                    System.out.println("DOMException");
                }
            } else if (node.getNodeName().equals("description")) {
                item.setDescription(node.getTextContent());
            } else if (node.getNodeName().equals("comments")) {
                item.setComments(node.getTextContent());
            } else if (node.getNodeName().equals("enclosure")) {
                this.parseEnclosure(item, node);
            } else if (node.getNodeName().equals("category")) {
                this.parseCategory(item, node);
            } else if (node.getNodeName().equals("dc:creator")) {
                item.setAuthor(node.getTextContent());
            }
            ++i;
        }
        channel.addItem(item);
        return true;
    }

    protected boolean parseEnclosure(RSSItem item, Node node) {
        NamedNodeMapImpl attrList = (NamedNodeMapImpl)node.getAttributes();
        if (this.log) {
            System.out.println("log#RSSReader::parseEnclosure $ Parsing enclosure element");
        }
        URL url = null;
        try {
            url = new URL(attrList.getNamedItem("url").getNodeValue());
            if (this.log) {
                System.out.println("log#RSSReader::parseEnclosure $ URL = " + attrList.getNamedItem("url").getNodeValue());
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (DOMException e) {
            e.printStackTrace();
        }
        if (attrList.getNamedItem("type").getNodeValue().startsWith("image")) {
            item.setImageUrl(url);
        } else {
            item.setResourcesZipUrl(url);
        }
        return true;
    }

    protected boolean parseCategory(RSSItem item, Node node) {
        return true;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public RSSRoot getRssRoot() {
        return this.rssRoot;
    }

    public void setRssRoot(RSSRoot rssRoot) {
        this.rssRoot = rssRoot;
    }

    public static void main(String[] args) {
        try {
            URL url = new URL("http://club.ncl.org.br/?q=rss.xml");
            RSSReader reader = new RSSReader(url);
            reader.parse();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

