/*
 * Decompiled with CFR 0.152.
 */
package br.ufma.deinf.laws.ncl;

import br.ufma.deinf.laws.ncl.NCLReference;
import br.ufma.deinf.laws.util.MultiHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;

public class NCLStructure {
    private static NCLStructure instance = null;
    private Map<String, Map<String, Boolean>> attributes = new HashMap();
    private Map<String, Map<String, Integer>> dataTypes = new HashMap();
    private Map<String, Map<String, Character>> nesting = new HashMap();
    private MultiHashMap references = new MultiHashMap();

    private NCLStructure() {
        this.att("ncl", "id", true, 0);
        this.att("ncl", "title", false, 1);
        this.att("ncl", "xmlns", false, 9);
        this.att("ncl", "xmlns:xsi", false, 6);
        this.att("ncl", "xsi:schemaLocation", false);
        this.ct("ncl", "head", '?');
        this.ct("ncl", "body", '?');
        this.att("head", null, false);
        this.ct("head", "importedDocumentBase", '?');
        this.ct("head", "ruleBase", '?');
        this.ct("head", "transitionBase", '?');
        this.ct("head", "regionBase", '*');
        this.ct("head", "descriptorBase", '?');
        this.ct("head", "connectorBase", '?');
        this.att("body", "id", false, 0);
        this.ct("body", "port", '*');
        this.ct("body", "property", '*');
        this.ct("body", "media", '*');
        this.ct("body", "context", '*');
        this.ct("body", "switch", '*');
        this.ct("body", "link", '*');
        this.att("regionBase", "id", false, 0);
        this.att("regionBase", "device", false, 15);
        this.att("regionBase", "region", false, 0);
        this.ct("regionBase", "importBase", '#');
        this.ct("regionBase", "region", '#');
        this.att("region", "id", true, 0);
        this.att("region", "title", false, 1);
        this.att("region", "left", false, 8);
        this.att("region", "right", false, 8);
        this.att("region", "top", false, 8);
        this.att("region", "bottom", false, 8);
        this.att("region", "height", false, 8);
        this.att("region", "width", false, 8);
        this.att("region", "zIndex", false, 29);
        this.ct("region", "region", '*');
        this.att("media", "id", true, 0);
        this.att("media", "src", false, 6);
        this.att("media", "refer", false, 0);
        this.att("media", "instance", false, 14);
        this.att("media", "type", false, 7);
        this.att("media", "descriptor", false, 0);
        this.ct("media", "area", '*');
        this.ct("media", "property", '*');
        this.att("context", "id", true, 0);
        this.att("context", "refer", false, 0);
        this.ct("context", "port", '*');
        this.ct("context", "property", '*');
        this.ct("context", "media", '*');
        this.ct("context", "context", '*');
        this.ct("context", "link", '*');
        this.ct("context", "switch", '*');
        this.att("area", "id", true, 0);
        this.att("area", "coords", false, 4);
        this.att("area", "begin", false, 5);
        this.att("area", "end", false, 5);
        this.att("area", "text", false, 1);
        this.att("area", "position", false, 2);
        this.att("area", "first", false, 1);
        this.att("area", "last", false, 1);
        this.att("area", "label", false, 1);
        this.att("area", "clip", false, 1);
        this.att("area", "beginOffset", false, 1);
        this.att("area", "endOffset", false, 1);
        this.att("port", "id", true, 0);
        this.att("port", "component", true, 0);
        this.att("port", "interface", false, 0);
        this.att("property", "name", true, 28);
        this.att("property", "value", false, 1);
        this.att("switchPort", "id", true, 0);
        this.ct("switchPort", "mapping", '+');
        this.att("mapping", "component", true, 0);
        this.att("mapping", "interface", false, 0);
        this.att("descriptor", "id", true, 0);
        this.att("descriptor", "player", false, 1);
        this.att("descriptor", "explicitDur", false, 5);
        this.att("descriptor", "region", false, 0);
        this.att("descriptor", "freeze", false);
        this.att("descriptor", "moveLeft", false);
        this.att("descriptor", "moveRight", false);
        this.att("descriptor", "moveDown", false);
        this.att("descriptor", "moveUp", false);
        this.att("descriptor", "focusIndex", false);
        this.att("descriptor", "focusBorderColor", false, 19);
        this.att("descriptor", "focusBorderWidth", false);
        this.att("descriptor", "focusBorderTransparency", false);
        this.att("descriptor", "focusSrc", false, 6);
        this.att("descriptor", "focusSelSrc", false, 6);
        this.att("descriptor", "selBorderColor", false, 19);
        this.att("descriptor", "transIn", false);
        this.att("descriptor", "transOut", false);
        this.ct("descriptor", "descriptorParam", '*');
        this.att("descriptorParam", "name", true, 35);
        this.att("descriptorParam", "value", true, 1);
        this.att("descriptorBase", "id", false, 0);
        this.ct("descriptorBase", "importBase", '#');
        this.ct("descriptorBase", "descriptor", '#');
        this.ct("descriptorBase", "descriptorSwitch", '#');
        this.att("bind", "role", true, 0);
        this.att("bind", "component", true, 0);
        this.att("bind", "interface", false, 0);
        this.att("bind", "descriptor", false, 0);
        this.ct("bind", "bindParam", '*');
        this.att("bindParam", "name", true, 0);
        this.att("bindParam", "value", true, 1);
        this.att("linkParam", "name", true, 0);
        this.att("linkParam", "value", true, 1);
        this.att("link", "id", false, 0);
        this.att("link", "xconnector", true, 11);
        this.ct("link", "linkParam", '*');
        this.ct("link", "bind", '+');
        this.att("causalConnector", "id", true, 0);
        this.ct("causalConnector", "connectorParam", '*');
        this.ct("causalConnector", "simpleCondition", 'a');
        this.ct("causalConnector", "compoundCondition", 'a');
        this.ct("causalConnector", "simpleAction", 'b');
        this.ct("causalConnector", "compoundAction", 'b');
        this.att("connectorParam", "name", true, 0);
        this.att("connectorParam", "type", false);
        this.att("simpleCondition", "role", true, 18);
        this.att("simpleCondition", "delay", false);
        this.att("simpleCondition", "eventType", false, 20);
        this.att("simpleCondition", "key", false, 22);
        this.att("simpleCondition", "transition", false, 21);
        this.att("simpleCondition", "min", false, 39);
        this.att("simpleCondition", "max", false, 40);
        this.att("simpleCondition", "qualifier", false, 12);
        this.att("compoundCondition", "operator", true, 12);
        this.att("compoundCondition", "delay", false, 5);
        this.ct("compoundCondition", "simpleCondition", '#');
        this.ct("compoundCondition", "compoundCondition", '#');
        this.ct("compoundCondition", "assessmentStatement", '*');
        this.ct("compoundCondition", "compoundStatement", '*');
        this.att("simpleAction", "role", true, 17);
        this.att("simpleAction", "delay", false);
        this.att("simpleAction", "eventType", false, 20);
        this.att("simpleAction", "actionType", false, 23);
        this.att("simpleAction", "value", false);
        this.att("simpleAction", "min", false, 39);
        this.att("simpleAction", "max", false, 40);
        this.att("simpleAction", "qualifier", false, 13);
        this.att("simpleAction", "repeat", false);
        this.att("simpleAction", "repeatDelay", false);
        this.att("simpleAction", "duration", false);
        this.att("simpleAction", "by", false);
        this.att("compoundAction", "operator", true, 13);
        this.att("compoundAction", "delay", false);
        this.ct("compoundAction", "simpleAction", '#');
        this.ct("compoundAction", "compoundAction", '#');
        this.att("assessmentStatement", "comparator", true, 16);
        this.ct("assessmentStatement", "attributeAssessment", '*');
        this.ct("assessmentStatement", "valueAssessment", '*');
        this.att("attributeAssessment", "role", true);
        this.att("attributeAssessment", "eventType", true, 20);
        this.att("attributeAssessment", "key", false, 22);
        this.att("attributeAssessment", "attributeType", false);
        this.att("attributeAssessment", "offset", false);
        this.att("valueAssessment", "value", true);
        this.att("compoundStatement", "operator", true, 12);
        this.att("compoundStatement", "isNegated", false, 27);
        this.ct("compoundStatement", "assessmentStatement", '#');
        this.ct("compoundStatement", "compoundStatement", '#');
        this.att("connectorBase", "id", false, 0);
        this.ct("connectorBase", "importBase", '*');
        this.ct("connectorBase", "causalConnector", '*');
        this.att("ruleBase", "id", false, 0);
        this.ct("ruleBase", "importBase", '#');
        this.ct("ruleBase", "rule", '#');
        this.ct("ruleBase", "compositeRule", '#');
        this.att("rule", "id", true, 0);
        this.att("rule", "var", true, 37);
        this.att("rule", "comparator", true, 16);
        this.att("rule", "value", true);
        this.att("compositeRule", "id", true, 0);
        this.att("compositeRule", "operator", true, 12);
        this.ct("compositeRule", "rule", '#');
        this.ct("compositeRule", "compositeRule", '#');
        this.att("bindRule", "constituent", true);
        this.att("bindRule", "rule", true);
        this.att("switch", "id", true, 0);
        this.att("switch", "refer", false);
        this.ct("switch", "defaultComponent", '?');
        this.ct("switch", "switchPort", '*');
        this.ct("switch", "bindRule", '*');
        this.ct("switch", "media", '*');
        this.ct("switch", "context", '*');
        this.ct("switch", "switch", '*');
        this.att("defaultComponent", "component", true);
        this.att("descriptorSwitch", "id", true, 0);
        this.ct("descriptorSwitch", "defaultDescriptor", '?');
        this.ct("descriptorSwitch", "descriptor", '*');
        this.ct("descriptorSwitch", "bindRule", '*');
        this.att("defaultDescriptor", "descriptor", true);
        this.att("importBase", "alias", true);
        this.att("importBase", "documentURI", true, 6);
        this.att("importBase", "region", false);
        this.att("importedDocumentBase", "id", false, 0);
        this.ct("importedDocumentBase", "importNCL", '+');
        this.att("importNCL", "alias", true);
        this.att("importNCL", "documentURI", true, 6);
        this.att("transitionBase", "id", false, 0);
        this.ct("transitionBase", "importBase", '#');
        this.ct("transitionBase", "transition", '#');
        this.att("transition", "id", true, 0);
        this.att("transition", "type", true, 24);
        this.att("transition", "subtype", false, 25);
        this.att("transition", "dur", false, 5);
        this.att("transition", "startProgress", false);
        this.att("transition", "endProgress", false);
        this.att("transition", "direction", false, 26);
        this.att("transition", "fadeColor", false, 19);
        this.att("transition", "horRepeat", false, 2);
        this.att("transition", "vertRepeat", false, 2);
        this.att("transition", "borderWidth", false, 2);
        this.att("transition", "borderColor", false, 36);
        this.ct("head", "meta", '*');
        this.ct("body", "meta", '*');
        this.ct("context", "meta", '*');
        this.att("meta", "name", true);
        this.att("meta", "content", true);
        this.ct("head", "metadata", '*');
        this.ct("body", "metadata", '*');
        this.ct("context", "metadata", '*');
        this.att("metadata", null, false);
        this.ref("regionBase", "region", "region", "id");
        this.ref("media", "descriptor", "descriptor", "id");
        this.ref("media", "descriptor", "descriptorSwitch", "id");
        this.ref("media", "refer", "media", "id");
        this.ref("context", "refer", "context", "id");
        this.ref("context", "refer", "body", "id");
        this.ref("descriptor", "region", "region", "id");
        this.ref("descriptor", "transIn", "transition", "id");
        this.ref("descriptor", "transOut", "transition", "id");
        this.ref("port", "component", "media", "id");
        this.ref("port", "component", "context", "id");
        this.ref("port", "component", "switch", "id");
        this.ref("port", "interface", "area", "id");
        this.ref("port", "interface", "port", "id");
        this.ref("port", "interface", "property", "name");
        this.ref("bind", "component", "media", "id");
        this.ref("bind", "component", "context", "id");
        this.ref("bind", "component", "switch", "id");
        this.ref("bind", "role", "simpleCondition", "role");
        this.ref("bind", "role", "simpleAction", "role");
        this.ref("bind", "role", "attributeAssessment", "role");
        this.ref("bind", "interface", "area", "id");
        this.ref("bind", "interface", "port", "id");
        this.ref("bind", "interface", "property", "name");
        this.ref("bind", "interface", "switchPort", "id");
        this.ref("bind", "descriptor", "descriptor", "id");
        this.ref("bind", "descriptor", "descriptorSwitch", "id");
        this.ref("bindRule", "constituent", "media", "id");
        this.ref("bindRule", "constituent", "context", "id");
        this.ref("bindRule", "constituent", "switch", "id");
        this.ref("bindRule", "constituent", "descriptor", "id");
        this.ref("bindRule", "rule", "rule", "id");
        this.ref("bindRule", "rule", "compositeRule", "id");
        this.ref("link", "xconnector", "causalConnector", "id");
        this.ref("linkParam", "name", "connectorParam", "name");
        this.ref("bindParam", "name", "connectorParam", "name");
        this.ref("switch", "refer", "switch", "id");
        this.ref("mapping", "component", "media", "id");
        this.ref("mapping", "component", "context", "id");
        this.ref("mapping", "component", "switch", "id");
        this.ref("mapping", "interface", "area", "id");
        this.ref("mapping", "interface", "port", "id");
        this.ref("mapping", "interface", "property", "name");
        this.ref("defaultComponent", "component", "media", "id");
        this.ref("defaultComponent", "component", "context", "id");
        this.ref("defaultComponent", "component", "switch", "id");
        this.ref("defaultDescriptor", "descriptor", "descriptor", "id");
    }

    public static NCLStructure getInstance() {
        if (instance == null) {
            instance = new NCLStructure();
        }
        return instance;
    }

    public Map<String, Map<String, Boolean>> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, Map<String, Boolean>> attributes) {
        this.attributes = attributes;
    }

    public Map<String, Map<String, Character>> getNesting() {
        return this.nesting;
    }

    public void setNesting(Map<String, Map<String, Character>> nesting) {
        this.nesting = nesting;
    }

    private void att(String elementName, String attributeName, boolean required) {
        HashMap<String, Boolean> atts;
        if (!this.attributes.containsKey(elementName)) {
            this.attributes.put(elementName, new HashMap());
        }
        if ((atts = (HashMap<String, Boolean>)this.attributes.get(elementName)) == null) {
            atts = new HashMap<String, Boolean>();
            this.attributes.put(elementName, atts);
        }
        atts.put(attributeName, required);
    }

    private void att(String elementName, String attributeName, boolean required, int type) {
        if (!this.attributes.containsKey(elementName)) {
            this.attributes.put(elementName, new LinkedHashMap());
            this.dataTypes.put(elementName, new HashMap());
        }
        HashMap<String, Boolean> atts = (HashMap<String, Boolean>)this.attributes.get(elementName);
        HashMap<String, Integer> dt = (HashMap<String, Integer>)this.dataTypes.get(elementName);
        if (atts == null) {
            atts = new HashMap<String, Boolean>();
            this.attributes.put(elementName, atts);
        }
        if (dt == null) {
            dt = new HashMap<String, Integer>();
            this.dataTypes.put(elementName, dt);
        }
        atts.put(attributeName, required);
        dt.put(attributeName, type);
    }

    private void ct(String elementName, String childElementName, char cardinality) {
        HashMap<String, Character> childElement;
        if (!this.nesting.containsKey(elementName)) {
            this.nesting.put(elementName, new HashMap());
        }
        if ((childElement = (HashMap<String, Character>)this.nesting.get(elementName)) == null) {
            childElement = new HashMap<String, Character>();
            this.nesting.put(elementName, childElement);
        }
        childElement.put(childElementName, Character.valueOf(cardinality));
    }

    private void ref(String elementName, String attributeName, String refElementName, String refAttributeName) {
        NCLReference nclReference = new NCLReference(elementName, attributeName, refElementName, refAttributeName);
        this.references.put((Object)elementName, (Object)nclReference);
    }

    public boolean isElement(String elementName) {
        return this.attributes.containsKey(elementName) || this.nesting.containsKey(elementName);
    }

    public boolean isAttribute(String elementName, String attributeName) {
        if (!this.getAttributes().containsKey(elementName)) {
            return false;
        }
        return ((Map)this.getAttributes().get(elementName)).containsKey(attributeName);
    }

    public Map<String, Map<String, Integer>> getDataTypes() {
        return this.dataTypes;
    }

    public void setDataTypes(Map<String, Map<String, Integer>> dataTypes) {
        this.dataTypes = dataTypes;
    }

    public Integer getDataType(String elementName, String attributeName) {
        if (!this.getDataTypes().containsKey(elementName) || !((Map)this.getDataTypes().get(elementName)).containsKey(attributeName)) {
            return new Integer(-1);
        }
        return (Integer)((Map)this.getDataTypes().get(elementName)).get(attributeName);
    }

    public boolean isChild(String parentElementName, String childElementName) {
        if (!this.nesting.containsKey(parentElementName)) {
            return false;
        }
        return ((Map)this.nesting.get(parentElementName)).containsKey(childElementName);
    }

    public Map<String, Character> getChildrenCardinality(String elementName) {
        HashMap<String, Character> empty = new HashMap<String, Character>();
        if (!this.nesting.containsKey(elementName)) {
            return empty;
        }
        return (Map)this.nesting.get(elementName);
    }

    public Map<String, Boolean> getAttributes(String elementName) {
        HashMap<String, Boolean> empty = new HashMap<String, Boolean>();
        if (!this.attributes.containsKey(elementName)) {
            return empty;
        }
        return (Map)this.attributes.get(elementName);
    }

    public Map<String, Integer> getDataTypes(String elementName) {
        HashMap<String, Integer> empty = new HashMap<String, Integer>();
        if (!this.attributes.containsKey(elementName)) {
            return empty;
        }
        return (Map)this.dataTypes.get(elementName);
    }

    public boolean isRequiredId(String elementName) {
        if (!this.getAttributes().containsKey(elementName)) {
            return false;
        }
        if (!((Map)this.getAttributes().get(elementName)).containsKey("id")) {
            return false;
        }
        return ((Map)this.getAttributes().get(elementName)).containsKey("id");
    }

    public boolean isReference(String elementName, String attributeName) {
        if (this.references.containsKey((Object)elementName)) {
            Collection collection = this.references.get(elementName);
            for (NCLReference ref : collection) {
                if (!ref.getAttribute().equals(attributeName)) continue;
                return true;
            }
        }
        return false;
    }

    public Collection getNCLReference(String elementName, String attributeName) {
        if (this.references.containsKey((Object)elementName)) {
            ArrayList<NCLReference> ret = new ArrayList<NCLReference>();
            Collection collection = this.references.get(elementName);
            for (NCLReference ref : collection) {
                if (!ref.getAttribute().equals(attributeName)) continue;
                ret.add(ref);
            }
            return ret;
        }
        return null;
    }

    public Collection<NCLReference> getNCLReverseReference(String elementName, String attributeName) {
        Iterator it = this.references.keySet().iterator();
        ArrayList<NCLReference> ret = new ArrayList<NCLReference>();
        while (it.hasNext()) {
            Collection collection = (Collection)this.references.get(it.next());
            for (NCLReference ref : collection) {
                if (!ref.getRefAttribute().equals(attributeName) || !ref.getRefTagname().equals(elementName)) continue;
                ret.add(ref);
            }
        }
        return ret;
    }

    public Vector<String> getRootElements() {
        Vector<String> vet = new Vector<String>();
        for (String tagname : this.nesting.keySet()) {
            Iterator it2 = this.nesting.keySet().iterator();
            boolean isRoot = true;
            while (it2.hasNext()) {
                if (!((Map)this.nesting.get((String)it2.next())).containsKey(tagname)) continue;
                isRoot = false;
            }
            if (!isRoot) continue;
            vet.add(tagname);
        }
        return vet;
    }
}

