/*
 * Decompiled with CFR 0.152.
 */
package br.ufma.deinf.laws.ncleclipse.club.wizards;

import br.ufma.deinf.laws.ncleclipse.club.wizards.NCLClubListExamplesPage;
import br.ufma.deinf.laws.ncleclipse.club.wizards.NCLClubNewWizardPage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NCLClubNewWizard
extends Wizard
implements INewWizard {
    private NCLClubListExamplesPage pageList;
    private NCLClubNewWizardPage page;
    private ISelection selection;
    private IProject project;
    private String containerName;

    public NCLClubNewWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.pageList = new NCLClubListExamplesPage(this.selection);
        this.page = new NCLClubNewWizardPage(this.selection);
        this.addPage((IWizardPage)this.pageList);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        this.containerName = this.page.getContainerName();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        NCLClubNewWizard.this.doFinish(NCLClubNewWizard.this.containerName, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private void doFinish(String containerName, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Creating project " + containerName, 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(containerName);
        if (!project.exists()) {
            project.create(monitor);
            if (!project.isOpen()) {
                project.open(monitor);
            }
        }
        monitor.worked(1);
        try {
            this.createResourcesFromUrl(this.pageList.getSelectedItem().getResourcesZipUrl(), monitor);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        root.refreshLocal(2, monitor);
    }

    private void createResourcesFromUrl(URL url, IProgressMonitor monitor) throws IOException, CoreException {
        monitor.setTaskName("Getting zip file...");
        InputStream is = url.openStream();
        monitor.worked(1);
        this.createResourcesFromZip(is, monitor);
    }

    private void createResourcesFromZip(InputStream in, IProgressMonitor monitor) throws FileNotFoundException, IOException, CoreException {
        ZipEntry entry;
        ZipInputStream zis = new ZipInputStream(in);
        while ((entry = zis.getNextEntry()) != null) {
            int size;
            monitor.setTaskName("Unzipping: " + entry.getName());
            byte[] buffer = new byte[2048];
            monitor.worked(1);
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IProject project = root.getProject(this.containerName);
            System.out.println(String.valueOf(project.getFullPath().toOSString()) + "/" + entry.getName());
            IPath workspacePath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
            if (entry.isDirectory()) {
                IFolder folder = project.getFolder(entry.getName());
                if (folder.exists()) continue;
                folder.create(0, true, null);
                continue;
            }
            System.out.println(workspacePath.toOSString());
            FileOutputStream fos = new FileOutputStream(String.valueOf(workspacePath.toOSString()) + "/" + project.getFullPath() + "/" + entry.getName());
            BufferedOutputStream bos = new BufferedOutputStream(fos, buffer.length);
            while ((size = zis.read(buffer, 0, buffer.length)) != -1) {
                bos.write(buffer, 0, size);
            }
            bos.flush();
            bos.close();
        }
        zis.close();
    }

    private InputStream openContentStream() {
        String contents = "This is the initial file contents for *.mpe file that should be word-sorted in the Preview page of the multi-page editor";
        return new ByteArrayInputStream(contents.getBytes());
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "ncl30_eclipse_club", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }
}

