/******************************************************************************
Este arquivo  parte da implementao do ambiente declarativo do middleware 
Ginga (Ginga-NCL).

Direitos Autorais Reservados (c) 1989-2007 PUC-Rio/Laboratrio TeleMdia

Este programa  software livre; voc pode redistribu-lo e/ou modific-lo sob 
os termos da Licena Pblica Geral GNU verso 2 conforme publicada pela Free 
Software Foundation.

Este programa  distribudo na expectativa de que seja til, porm, SEM 
NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU 
ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral do 
GNU verso 2 para mais detalhes. 

Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU verso 2 junto 
com este programa; se no, escreva para a Free Software Foundation, Inc., no 
endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA. 

Para maiores informaes:
ncl @ telemidia.puc-rio.br
http://www.ncl.org.br
http://www.ginga.org.br
http://www.telemidia.puc-rio.br
******************************************************************************
This file is part of the declarative environment of middleware Ginga (Ginga-NCL)

Copyright: 1989-2007 PUC-RIO/LABORATORIO TELEMIDIA, All Rights Reserved.

This program is free software; you can redistribute it and/or modify it under 
the terms of the GNU General Public License version 2 as published by
the Free Software Foundation.

This program is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
PARTICULAR PURPOSE.  See the GNU General Public License version 2 for more 
details.

You should have received a copy of the GNU General Public License version 2
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

For further information contact:
ncl @ telemidia.puc-rio.br
http://www.ncl.org.br
http://www.ginga.org.br
http://www.telemidia.puc-rio.br
*******************************************************************************/
package br.org.ginga.ncl;

import java.util.List;

import br.org.ginga.ncl.model.event.IFormatterEvent;
import br.org.ginga.ncl.model.presentation.IFormatterLayout;

/**
 * The scheduler interface. The scheduler is the main component in the 
 * presentation engine runtime control.
 */
public interface IFormatterScheduler {
	/**
	 * Starts executing a formatter event.
	 * @param event the event to be put in the occurring state.
	 */
	void startEvent(IFormatterEvent event);

	/**
	 * Stops executing a formatter event.
	 * @param event the event to be put in the sleeping state.
	 */
	void stopEvent(IFormatterEvent event);

	/**
	 * Pauses executing a formatter event.
	 * @param event the event to be put in the paused state.
	 */
	void pauseEvent(IFormatterEvent event);

	/**
	 * Resumes executing a formatter event.
	 * @param event the event to be put in the occurring state again.
	 */
	void resumeEvent(IFormatterEvent event);

	void startDocument(IFormatterEvent documentEvent, List entryEvents);

	void stopDocument(IFormatterEvent documentEvent);

	void pauseDocument(IFormatterEvent documentEvent);

	void resumeDocument(IFormatterEvent documentEvent);

	void stopAllDocuments();

	void pauseAllDocuments();

	void resumeAllDocuments();

	void addSchedulerListener(IFormatterSchedulerListener listener);

	void removeSchedulerListener(IFormatterSchedulerListener listener);

	void reset();

	IFormatterLayout getLayoutManager();
}
