/******************************************************************************
Este arquivo  parte da implementao do ambiente declarativo do middleware 
Ginga (Ginga-NCL).

Direitos Autorais Reservados (c) 1989-2007 PUC-Rio/Laboratrio TeleMdia

Este programa  software livre; voc pode redistribu-lo e/ou modific-lo sob 
os termos da Licena Pblica Geral GNU verso 2 conforme publicada pela Free 
Software Foundation.

Este programa  distribudo na expectativa de que seja til, porm, SEM 
NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU 
ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral do 
GNU verso 2 para mais detalhes. 

Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU verso 2 junto 
com este programa; se no, escreva para a Free Software Foundation, Inc., no 
endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA. 

Para maiores informaes:
ncl @ telemidia.puc-rio.br
http://www.ncl.org.br
http://www.ginga.org.br
http://www.telemidia.puc-rio.br
******************************************************************************
This file is part of the declarative environment of middleware Ginga (Ginga-NCL)

Copyright: 1989-2007 PUC-RIO/LABORATORIO TELEMIDIA, All Rights Reserved.

This program is free software; you can redistribute it and/or modify it under 
the terms of the GNU General Public License version 2 as published by
the Free Software Foundation.

This program is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
PARTICULAR PURPOSE.  See the GNU General Public License version 2 for more 
details.

You should have received a copy of the GNU General Public License version 2
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

For further information contact:
ncl @ telemidia.puc-rio.br
http://www.ncl.org.br
http://www.ginga.org.br
http://www.telemidia.puc-rio.br
*******************************************************************************/
package br.pucrio.telemidia.ginga.ncl.gui.remoteControl;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;

import java.awt.Cursor;

import java.awt.FlowLayout;

import java.awt.Image;

import java.awt.MediaTracker;

import java.awt.Toolkit;

import java.awt.event.MouseEvent;

import java.awt.event.MouseListener;

import java.awt.event.MouseMotionListener;

import javax.swing.Icon;

import javax.swing.ImageIcon;

import javax.swing.JFrame;

import javax.swing.JLabel;

import javax.swing.SwingConstants;

import org.dvb.event.EventManager;
import org.havi.ui.event.HRcEvent;

import br.pucrio.telemidia.ginga.core.io.InputEventManager;

import java.awt.event.KeyAdapter;

import java.awt.event.KeyEvent;

public class RemoteControl extends JFrame implements MouseListener,
		MouseMotionListener {
	private static final long serialVersionUID = -416276991247876291L;

	private JLabel label1;

	private KeyHandler keyHandler;

	private String filename;
	
	/** Presentation control buttons */
	
	private int btnRew_x = 34, btnRew_y = 281;
	
	private int btnPlay_x = 63, btnPlay_y = 281;
	
	private int btnPause_x = 87, btnPause_y = 281;
	
	//private int btnForward_x = 118, btnForward_y = 281;
	
	private int btnStop_x = 118, btnStop_y = 281;
	
	private int btnRecord_x = 87, btnRecord_y = 309;

	/** Positions of the first buttons */

	//private int btnPortal_x = 34, btnPortal_y = 141;
	
	private int btnMenu_x = 74, btnMenu_y = 168;
	
	private int btnExit_x = 34, btnExit_y = 143;

	private int btnBack_x = 115, btnBack_y = 143;

	private int btnGuide_x = 34, btnGuide_y = 79;

	private int btnHelp_x = 74, btnHelp_y = 59;

	//private int btnTV_x = 89, btnTV_y = 64;

	private int btnInfo_x = 115, btnInfo_y = 79;

	private int btnPower_x = 113, btnPower_y = 34;
	
	private int btnEject_x = 34, btnEject_y = 34;

	private int btnOK_x = 71, btnOK_y = 107;

	private int btnLeft_x = 49, btnLeft_y = 104;

	private int btnRight_x = 104, btnRight_y = 104;

	private int btnUp_x = 69, btnUp_y = 85;

	private int btnDown_x = 69, btnDown_y = 143;

	/** Positions of the numeric buttons */

	private int btn1_x = 36, btn1_y = 333;

	private int btn2_x = 72, btn2_y = 333;

	private int btn3_x = 108, btn3_y = 333;

	private int btn4_x = 36, btn4_y = 366;

	private int btn5_x = 72, btn5_y = 366;

	private int btn6_x = 108, btn6_y = 366;

	private int btn7_x = 36, btn7_y = 400;

	private int btn8_x = 72, btn8_y = 400;

	private int btn9_x = 108, btn9_y = 400;

	private int btnA_x = 36, btnA_y = 432;

	private int btn0_x = 72, btn0_y = 432;

	private int btnB_x = 108, btnB_y = 432;

	private int limit_x = 27;

	private int limit_y = 30;

	/** Positions of the color buttons */

	private int btnRed_x = 34, btnRed_y = 253;

	private int btnGreen_x = 63, btnGreen_y = 253;

	private int btnYellow_x = 87, btnYellow_y = 253;

	private int btnBlue_x = 118, btnBlue_y = 253;

	private int limitColor_x = 20;

	private int limitColor_y = 18;

	/** Positions of the channel, volume and mute buttons */

	private int btnChannelInc_x = 31, btnChannelInc_y = 198;

	private int btnChannelDec_x = 31, btnChannelDec_y = 225;

	private int btnMute_x = 72, btnMute_y = 210;

	private int btnVolInc_x = 104, btnVolInc_y = 198;

	private int btnVolDec_x = 104, btnVolDec_y = 225;

	private int limitCircle_x = 22;

	private int limitCircle_y = 21;

	private int limitChanVol_x = 28;

	private int limitChanVol_y = 15;
	
	public RemoteControl() {
		this("./gingaNclGuiFiles/images/controle-remoto2.png");
	}
	
	public RemoteControl(String fileName){
		this.filename = fileName;
		keyHandler = new KeyHandler();
		addKeyListener(keyHandler);

		Container container = getContentPane();
		container.setBackground(Color.black);
		container.setLayout(new FlowLayout());

		Image image = Toolkit.getDefaultToolkit().getImage(filename);
		MediaTracker mediaTracker = new MediaTracker(container);
		mediaTracker.addImage(image, 0);

		try {
			mediaTracker.waitForID(0);
		}
		catch (InterruptedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		int imageWidth = image.getWidth(null);
		int imageHeight = image.getHeight(null);
		Icon remoteControl = new ImageIcon(filename);
		label1 = new JLabel(null, remoteControl, SwingConstants.LEFT);
		label1.setSize(imageWidth, imageHeight);
		container.add(label1);

		// Add the mouse listeners.

		this.addMouseListener(this);
		this.addMouseMotionListener(this);

		setTitle("Remote Control");
		Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
		setBounds((int)dim.getWidth() - (imageWidth + 50), (int)dim.getHeight()
				- (imageHeight + 50), imageWidth + 50, imageHeight + 35);
		setResizable(false);
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setVisible(true);
	}

	private boolean belongNumericButtons(int btn_x, int btn_y, int x, int y) {

		boolean result = false;

		if ((x > btn_x && x < (btn_x + limit_x))
				&& (y > btn_y && y < (btn_y + limit_y)))

			result = true;

		return result;

	}

	private boolean belongColorButtons(int btn_x, int btn_y, int x, int y) {

		boolean result = false;

		if ((x > btn_x && x < (btn_x + limitColor_x))
				&& (y > btn_y && y < (btn_y + limitColor_y)))

			result = true;

		return result;

	}

	private boolean belongChanVolButtons(int btn_x, int btn_y, int x, int y) {

		boolean result = false;

		if ((x > btn_x && x < (btn_x + limitChanVol_x))
				&& (y > btn_y && y < (btn_y + limitChanVol_y)))

			result = true;

		return result;

	}

	private boolean belongLeftRightButtons(int btn_x, int btn_y, int x, int y) {

		boolean result = false;

		if ((x > btn_x && x < (btn_x + limitChanVol_y))
				&& (y > btn_y && y < (btn_y + limitChanVol_x)))

			result = true;

		return result;

	}

	private boolean belongCircleButton(int btn_x, int btn_y, int x, int y) {

		boolean result = false;

		if ((x > btn_x && x < (btn_x + limitCircle_x))
				&& (y > btn_y && y < (btn_y + limitCircle_y)))

			result = true;

		return result;

	}

	public void mouseClicked(MouseEvent event) {

		KeyEvent keyEvent;

		keyEvent = null;

		if (belongNumericButtons(btn1_x, btn1_y, event.getX(), event.getY())) {
			// System.out.println("button 1");
			keyEvent = new KeyEvent(RemoteControl.this, event.getID(), event
					.getWhen(), event.getModifiers(), HRcEvent.VK_1, '1');
		}
		else if (belongNumericButtons(btn2_x, btn2_y, event.getX(), event.getY())) {
			// System.out.println("button 2");
			keyEvent = new KeyEvent(RemoteControl.this, event.getID(), event
					.getWhen(), event.getModifiers(), HRcEvent.VK_2, '2');
		}
		else if (belongNumericButtons(btn3_x, btn3_y, event.getX(), event.getY())) {
			// System.out.println("button 3");
			keyEvent = new KeyEvent(RemoteControl.this, event.getID(), event
					.getWhen(), event.getModifiers(), HRcEvent.VK_3, '3');
		}
		else if (belongNumericButtons(btn4_x, btn4_y, event.getX(), event.getY())) {
			// System.out.println("button 4");
			keyEvent = new KeyEvent(RemoteControl.this, event.getID(), event
					.getWhen(), event.getModifiers(), HRcEvent.VK_4, '4');
		}
		else if (belongNumericButtons(btn5_x, btn5_y, event.getX(), event.getY())) {
			// System.out.println("button 5");
			keyEvent = new KeyEvent(RemoteControl.this, event.getID(), event
					.getWhen(), event.getModifiers(), HRcEvent.VK_5, '5');
		}
		else if (belongNumericButtons(btn6_x, btn6_y, event.getX(), event.getY())) {
			// System.out.println("button 6");
			keyEvent = new KeyEvent(RemoteControl.this, event.getID(), event
					.getWhen(), event.getModifiers(), HRcEvent.VK_6, '6');
		}
		else if (belongNumericButtons(btn7_x, btn7_y, event.getX(), event.getY())) {
			// System.out.println("button 7");
			keyEvent = new KeyEvent(RemoteControl.this, event.getID(), event
					.getWhen(), event.getModifiers(), HRcEvent.VK_7, '7');
		}
		else if (belongNumericButtons(btn8_x, btn8_y, event.getX(), event.getY())) {
			// System.out.println("button 8");
			keyEvent = new KeyEvent(RemoteControl.this, event.getID(), event
					.getWhen(), event.getModifiers(), HRcEvent.VK_8, '8');
		}
		else if (belongNumericButtons(btn9_x, btn9_y, event.getX(), event.getY())) {
			// System.out.println("button 9");
			keyEvent = new KeyEvent(RemoteControl.this, event.getID(), event
					.getWhen(), event.getModifiers(), HRcEvent.VK_9, '9');
		}
		else if (belongNumericButtons(btnA_x, btnA_y, event.getX(), event.getY())) {
			// System.out.println("button *");
			keyEvent = new KeyEvent(RemoteControl.this, event.getID(), event
					.getWhen(), event.getModifiers(), HRcEvent.VK_ASTERISK, '*');
		}
		else if (belongNumericButtons(btn0_x, btn0_y, event.getX(), event.getY())) {
			// System.out.println("button 0");
			keyEvent = new KeyEvent(RemoteControl.this, event.getID(), event
					.getWhen(), event.getModifiers(), HRcEvent.VK_0, '0');
		}
		else if (belongNumericButtons(btnB_x, btnB_y, event.getX(), event.getY())) {
			keyEvent = new KeyEvent(RemoteControl.this, event.getID(), event
					.getWhen(), event.getModifiers(), HRcEvent.VK_NUMBER_SIGN, '#');
		}
		else if (belongColorButtons(btnRed_x, btnRed_y, event.getX(), event.getY())) {
			// System.out.println("button red");
			keyEvent = new KeyEvent(RemoteControl.this, event.getID(), event
					.getWhen(), event.getModifiers(), HRcEvent.VK_COLORED_KEY_0, '?');
		}
		else if (belongColorButtons(btnGreen_x, btnGreen_y, event.getX(), event
				.getY())) {
			// System.out.println("button green");
			keyEvent = new KeyEvent(RemoteControl.this, event.getID(), event
					.getWhen(), event.getModifiers(), HRcEvent.VK_COLORED_KEY_1, '?');
		}
		else if (belongColorButtons(btnYellow_x, btnYellow_y, event.getX(), event
				.getY())) {
			// System.out.println("button yellow");
			keyEvent = new KeyEvent(RemoteControl.this, event.getID(), event
					.getWhen(), event.getModifiers(), HRcEvent.VK_COLORED_KEY_2, '?');
		}
		else if (belongColorButtons(btnBlue_x, btnBlue_y, event.getX(), event
				.getY())) {
			// System.out.println("button blue");
			keyEvent = new KeyEvent(RemoteControl.this, event.getID(), event
					.getWhen(), event.getModifiers(), HRcEvent.VK_COLORED_KEY_3, '?');
		}
		else if (belongChanVolButtons(btnChannelInc_x, btnChannelInc_y, event
				.getX(), event.getY())) {
			keyEvent = new KeyEvent(RemoteControl.this, event.getID(), event
					.getWhen(), event.getModifiers(), HRcEvent.VK_CHANNEL_UP, '?');
		}
		else if (belongChanVolButtons(btnChannelDec_x, btnChannelDec_y, event
				.getX(), event.getY())) {
			keyEvent = new KeyEvent(RemoteControl.this, event.getID(), event
					.getWhen(), event.getModifiers(), HRcEvent.VK_CHANNEL_DOWN, '?');
		}
		else if (belongChanVolButtons(btnVolInc_x, btnVolInc_y, event.getX(), event
				.getY())) {
			keyEvent = new KeyEvent(RemoteControl.this, event.getID(), event
					.getWhen(), event.getModifiers(), HRcEvent.VK_VOLUME_UP, '?');
		}
		else if (belongChanVolButtons(btnVolDec_x, btnVolDec_y, event.getX(), event
				.getY())) {
			keyEvent = new KeyEvent(RemoteControl.this, event.getID(), event
					.getWhen(), event.getModifiers(), HRcEvent.VK_VOLUME_DOWN, '?');
		}
		else if (belongCircleButton(btnMute_x, btnMute_y, event.getX(), event
				.getY())) {
			keyEvent = new KeyEvent(RemoteControl.this, event.getID(), event
					.getWhen(), event.getModifiers(), HRcEvent.VK_MUTE, '?');
		}
		else if (belongCircleButton(btnGuide_x, btnGuide_y, event.getX(), event
				.getY())) {
			// System.out.println("button guide");
			keyEvent = new KeyEvent(RemoteControl.this, event.getID(), event
					.getWhen(), event.getModifiers(), HRcEvent.VK_GUIDE, '?');
		}
		else if (belongCircleButton(btnHelp_x, btnHelp_y, event.getX(), event
				.getY())) {
			keyEvent = new KeyEvent(RemoteControl.this, event.getID(), event
					.getWhen(), event.getModifiers(), HRcEvent.VK_HELP, '?');
		}
		
		else if (belongCircleButton(btnInfo_x, btnInfo_y, event.getX(), event
				.getY())) {
			// System.out.println("button info - interact");
			keyEvent = new KeyEvent(RemoteControl.this, event.getID(), event
					.getWhen(), event.getModifiers(), HRcEvent.VK_INFO, '?');
		}
		else if (belongCircleButton(btnMenu_x, btnMenu_y, event.getX(), event
				.getY())) {
			// System.out.println("button portal");
			keyEvent = new KeyEvent(RemoteControl.this, event.getID(), event
					.getWhen(), event.getModifiers(), HRcEvent.VK_CONTEXT_MENU, '?');
		}
		else if (belongCircleButton(btnExit_x, btnExit_y, event.getX(), event
				.getY())) {
			// System.out.println("button portal");
			keyEvent = new KeyEvent(RemoteControl.this, event.getID(), event
					.getWhen(), event.getModifiers(), HRcEvent.VK_END, '?');
		}
		else if (belongCircleButton(btnBack_x, btnBack_y, event.getX(), event
				.getY())) {
			// System.out.println("button back");
			keyEvent = new KeyEvent(RemoteControl.this, event.getID(), event
					.getWhen(), event.getModifiers(), KeyEvent.VK_BACK_SPACE, '?');
		}
		else if (belongCircleButton(btnPower_x, btnPower_y, event.getX(), event
				.getY())) {
			// System.out.println("button power");
			keyEvent = new KeyEvent(RemoteControl.this, event.getID(), event
					.getWhen(), event.getModifiers(), HRcEvent.VK_POWER, '?');
		}
		else if (belongCircleButton(btnEject_x, btnEject_y, event.getX(), event
				.getY())) {
			//System.out.println("button Eject");
			keyEvent = new KeyEvent(RemoteControl.this, event.getID(), event
					.getWhen(), event.getModifiers(), HRcEvent.VK_EJECT_TOGGLE, '?');
		}
		else if (belongNumericButtons(btnOK_x, btnOK_y, event.getX(), event.getY())) {
			// System.out.println("button OK");
			keyEvent = new KeyEvent(RemoteControl.this, event.getID(), event
					.getWhen(), event.getModifiers(), HRcEvent.VK_ENTER, '\n');
		}
		else if (belongChanVolButtons(btnUp_x, btnUp_y, event.getX(), event.getY())) {
			// System.out.println("button up");
			keyEvent = new KeyEvent(RemoteControl.this, event.getID(), event
					.getWhen(), event.getModifiers(), HRcEvent.VK_UP, '?');
		}
		else if (belongChanVolButtons(btnDown_x, btnDown_y, event.getX(), event
				.getY())) {
			// System.out.println("button down");
			keyEvent = new KeyEvent(RemoteControl.this, event.getID(), event
					.getWhen(), event.getModifiers(), HRcEvent.VK_DOWN, '?');
		}
		else if (belongLeftRightButtons(btnLeft_x, btnLeft_y, event.getX(), event
				.getY())) {
			// System.out.println("button left");
			keyEvent = new KeyEvent(RemoteControl.this, event.getID(), event
					.getWhen(), event.getModifiers(), HRcEvent.VK_LEFT, '?');
		}
		else if (belongLeftRightButtons(btnRight_x, btnRight_y, event.getX(), event
				.getY())) {
			// System.out.println("button right");
			keyEvent = new KeyEvent(RemoteControl.this, event.getID(), event
					.getWhen(), event.getModifiers(), HRcEvent.VK_RIGHT, '?');
		}
		else if (belongLeftRightButtons(btnRew_x, btnRew_y, event.getX(), event
				.getY())) {
			// System.out.println("button right");
			keyEvent = new KeyEvent(RemoteControl.this, event.getID(), event
					.getWhen(), event.getModifiers(), HRcEvent.VK_REWIND, '?');
		}
		else if (belongLeftRightButtons(btnPlay_x, btnPlay_y, event.getX(), event
				.getY())) {
			// System.out.println("button right");
			keyEvent = new KeyEvent(RemoteControl.this, event.getID(), event
					.getWhen(), event.getModifiers(), HRcEvent.VK_PLAY, '?');
		}
		else if (belongLeftRightButtons(btnPause_x, btnPause_y, event.getX(), event
				.getY())) {
			// System.out.println("button right");
			keyEvent = new KeyEvent(RemoteControl.this, event.getID(), event
					.getWhen(), event.getModifiers(), HRcEvent.VK_PAUSE, '?');
		}
		/*else if (belongLeftRightButtons(btnForward_x, btnForward_y, event.getX(), event
				.getY())) {
			// System.out.println("button right");
			keyEvent = new KeyEvent(RemoteControl.this, event.getID(), event
					.getWhen(), event.getModifiers(), HRcEvent.VK_FAST_FWD, '?');
		}*/
		else if (belongLeftRightButtons(btnStop_x, btnStop_y, event.getX(), event
				.getY())) {
			// System.out.println("button right");
			keyEvent = new KeyEvent(RemoteControl.this, event.getID(), event
					.getWhen(), event.getModifiers(), HRcEvent.VK_STOP, '?');
		}
		else if (belongLeftRightButtons(btnRecord_x, btnRecord_y, event.getX(), event
				.getY())) {
			// System.out.println("button right");
			keyEvent = new KeyEvent(RemoteControl.this, event.getID(), event
					.getWhen(), event.getModifiers(), HRcEvent.VK_RECORD, '?');
		}

		if (keyEvent != null) {
			EventManager.getInstance().fireKeyEvent(RemoteControl.this, keyEvent);
			InputEventManager.getInstance().dispatchEvent(keyEvent);
		}
	}

	public void mouseDragged(MouseEvent arg0) {

		// TODO Auto-generated method stub

	}

	public void mouseMoved(MouseEvent event) {

		// setTitle(""+event.getX()+","+event.getY());

		if (belongNumericButtons(btn1_x, btn1_y, event.getX(), event.getY())) {

			this.setCursor(new Cursor(Cursor.HAND_CURSOR));

		}

		else if (belongNumericButtons(btn2_x, btn2_y, event.getX(), event.getY())) {

			this.setCursor(new Cursor(Cursor.HAND_CURSOR));

		}

		else if (belongNumericButtons(btn3_x, btn3_y, event.getX(), event.getY())) {

			this.setCursor(new Cursor(Cursor.HAND_CURSOR));

		}

		else if (belongNumericButtons(btn4_x, btn4_y, event.getX(), event.getY())) {

			this.setCursor(new Cursor(Cursor.HAND_CURSOR));

		}

		else if (belongNumericButtons(btn5_x, btn5_y, event.getX(), event.getY())) {

			this.setCursor(new Cursor(Cursor.HAND_CURSOR));

		}

		else if (belongNumericButtons(btn6_x, btn6_y, event.getX(), event.getY())) {

			this.setCursor(new Cursor(Cursor.HAND_CURSOR));

		}

		else if (belongNumericButtons(btn7_x, btn7_y, event.getX(), event.getY())) {

			this.setCursor(new Cursor(Cursor.HAND_CURSOR));

		}

		else if (belongNumericButtons(btn8_x, btn8_y, event.getX(), event.getY())) {

			this.setCursor(new Cursor(Cursor.HAND_CURSOR));

		}

		else if (belongNumericButtons(btn9_x, btn9_y, event.getX(), event.getY())) {

			this.setCursor(new Cursor(Cursor.HAND_CURSOR));

		}

		else if (belongNumericButtons(btnA_x, btnA_y, event.getX(), event.getY())) {

			this.setCursor(new Cursor(Cursor.HAND_CURSOR));

		}

		else if (belongNumericButtons(btn0_x, btn0_y, event.getX(), event.getY())) {

			this.setCursor(new Cursor(Cursor.HAND_CURSOR));

		}

		else if (belongNumericButtons(btnB_x, btnB_y, event.getX(), event.getY())) {

			this.setCursor(new Cursor(Cursor.HAND_CURSOR));

		}

		else if (belongColorButtons(btnRed_x, btnRed_y, event.getX(), event.getY())) {

			this.setCursor(new Cursor(Cursor.HAND_CURSOR));

		}

		else if (belongColorButtons(btnGreen_x, btnGreen_y, event.getX(), event
				.getY())) {

			this.setCursor(new Cursor(Cursor.HAND_CURSOR));

		}

		else if (belongColorButtons(btnYellow_x, btnYellow_y, event.getX(), event
				.getY())) {

			this.setCursor(new Cursor(Cursor.HAND_CURSOR));

		}

		else if (belongColorButtons(btnBlue_x, btnBlue_y, event.getX(), event
				.getY())) {

			this.setCursor(new Cursor(Cursor.HAND_CURSOR));

		}
		
		else if (belongCircleButton(btnRew_x, btnRew_y, event.getX(), event
				.getY())) {

			this.setCursor(new Cursor(Cursor.HAND_CURSOR));

		}

		else if (belongCircleButton(btnPlay_x, btnPlay_y, event.getX(), event
				.getY())) {

			this.setCursor(new Cursor(Cursor.HAND_CURSOR));

		}
		
		else if (belongCircleButton(btnPause_x, btnPause_y, event.getX(), event
				.getY())) {

			this.setCursor(new Cursor(Cursor.HAND_CURSOR));

		}
		
		/*else if (belongCircleButton(btnForward_x, btnForward_y, event.getX(), event
				.getY())) {

			this.setCursor(new Cursor(Cursor.HAND_CURSOR));

		}*/
		
		else if (belongCircleButton(btnStop_x, btnStop_y, event.getX(), event
				.getY())) {

			this.setCursor(new Cursor(Cursor.HAND_CURSOR));

		}
		
		else if (belongCircleButton(btnRecord_x, btnRecord_y, event.getX(), event
				.getY())) {

			this.setCursor(new Cursor(Cursor.HAND_CURSOR));

		}
		
		else if (belongChanVolButtons(btnChannelInc_x, btnChannelInc_y, event
				.getX(), event.getY())) {

			this.setCursor(new Cursor(Cursor.HAND_CURSOR));

		}

		else if (belongChanVolButtons(btnChannelDec_x, btnChannelDec_y, event
				.getX(), event.getY())) {

			this.setCursor(new Cursor(Cursor.HAND_CURSOR));

		}

		else if (belongChanVolButtons(btnVolInc_x, btnVolInc_y, event.getX(), event
				.getY())) {

			this.setCursor(new Cursor(Cursor.HAND_CURSOR));

		}

		else if (belongChanVolButtons(btnVolDec_x, btnVolDec_y, event.getX(), event
				.getY())) {

			this.setCursor(new Cursor(Cursor.HAND_CURSOR));

		}

		else if (belongCircleButton(btnMute_x, btnMute_y, event.getX(), event
				.getY())) {

			this.setCursor(new Cursor(Cursor.HAND_CURSOR));

		}

		else if (belongCircleButton(btnGuide_x, btnGuide_y, event.getX(), event
				.getY())) {

			this.setCursor(new Cursor(Cursor.HAND_CURSOR));

		}

		else if (belongCircleButton(btnHelp_x, btnHelp_y, event.getX(), event
				.getY())) {

			this.setCursor(new Cursor(Cursor.HAND_CURSOR));

		}

		else if (belongCircleButton(btnInfo_x, btnInfo_y, event.getX(), event
				.getY())) {

			this.setCursor(new Cursor(Cursor.HAND_CURSOR));

		}

		else if (belongCircleButton(btnMenu_x, btnMenu_y, event.getX(), event
				.getY())) {

			this.setCursor(new Cursor(Cursor.HAND_CURSOR));

		}
		
		else if (belongCircleButton(btnExit_x, btnExit_y, event.getX(), event
				.getY())) {

			this.setCursor(new Cursor(Cursor.HAND_CURSOR));

		}

		else if (belongCircleButton(btnBack_x, btnBack_y, event.getX(), event
				.getY())) {

			this.setCursor(new Cursor(Cursor.HAND_CURSOR));

		}

		else if (belongCircleButton(btnPower_x, btnPower_y, event.getX(), event
				.getY())) {

			this.setCursor(new Cursor(Cursor.HAND_CURSOR));

		}
		
		else if (belongCircleButton(btnEject_x, btnEject_y, event.getX(), event
				.getY())) {

			this.setCursor(new Cursor(Cursor.HAND_CURSOR));

		}

		else if (belongNumericButtons(btnOK_x, btnOK_y, event.getX(), event.getY())) {

			this.setCursor(new Cursor(Cursor.HAND_CURSOR));

		}

		else if (belongChanVolButtons(btnUp_x, btnUp_y, event.getX(), event.getY())) {

			this.setCursor(new Cursor(Cursor.HAND_CURSOR));

		}

		else if (belongChanVolButtons(btnDown_x, btnDown_y, event.getX(), event
				.getY())) {

			this.setCursor(new Cursor(Cursor.HAND_CURSOR));

		}

		else if (belongLeftRightButtons(btnLeft_x, btnLeft_y, event.getX(), event
				.getY())) {

			this.setCursor(new Cursor(Cursor.HAND_CURSOR));

		}

		else if (belongLeftRightButtons(btnRight_x, btnRight_y, event.getX(), event
				.getY())) {

			this.setCursor(new Cursor(Cursor.HAND_CURSOR));

		}

		else {

			this.setCursor(new Cursor(Cursor.DEFAULT_CURSOR));

		}

	}

	public void mousePressed(MouseEvent arg0) {

		// TODO Auto-generated method stub

	}

	public void mouseReleased(MouseEvent arg0) {

		// TODO Auto-generated method stub

	}

	public void mouseEntered(MouseEvent arg0) {

		// TODO Auto-generated method stub

	}

	public void mouseExited(MouseEvent arg0) {

		// TODO Auto-generated method stub

	}

	private class KeyHandler extends KeyAdapter {
		public void keyReleased(KeyEvent e) {

			KeyEvent newEvent;

			switch (e.getKeyCode()) {

			case KeyEvent.VK_F1: // RED

			case KeyEvent.VK_NUM_LOCK:

				newEvent = new KeyEvent(RemoteControl.this, e.getID(), e.getWhen(), e
						.getModifiers(), HRcEvent.VK_COLORED_KEY_0, '?');

				break;

			case KeyEvent.VK_F2: // GREEN

			case KeyEvent.VK_DIVIDE:

				newEvent = new KeyEvent(RemoteControl.this, e.getID(), e.getWhen(), e
						.getModifiers(), HRcEvent.VK_COLORED_KEY_1, '?');

				break;

			case KeyEvent.VK_F3: // YELLOW

			case KeyEvent.VK_MULTIPLY:

				newEvent = new KeyEvent(RemoteControl.this, e.getID(), e.getWhen(), e
						.getModifiers(), HRcEvent.VK_COLORED_KEY_2, '?');

				break;

			case KeyEvent.VK_F4: // BLUE

			case KeyEvent.VK_MINUS:

				newEvent = new KeyEvent(RemoteControl.this, e.getID(), e.getWhen(), e
						.getModifiers(), HRcEvent.VK_COLORED_KEY_3, '?');

				break;

			case KeyEvent.VK_M:

			case KeyEvent.VK_PLUS:

				newEvent = new KeyEvent(RemoteControl.this, e.getID(), e.getWhen(), e
						.getModifiers(), HRcEvent.VK_GUIDE, '?');

				break;

			case KeyEvent.VK_I:

			case KeyEvent.VK_PERIOD:

				newEvent = new KeyEvent(RemoteControl.this, e.getID(), e.getWhen(), e
						.getModifiers(), HRcEvent.VK_INFO, '?');

				break;

			default:

				newEvent = e;

				break;

			}

			EventManager.getInstance().fireKeyEvent(RemoteControl.this, newEvent);
			InputEventManager.getInstance().dispatchEvent(newEvent);
		}

	}

}
