/*
 * Decompiled with CFR 0.152.
 */
package br.ufma.deinf.laws.ncleclipse;

import br.ufma.deinf.laws.ncleclipse.NCLEditor;
import br.ufma.deinf.laws.ncleclipse.NCLReconcilingStrategy;
import br.ufma.deinf.laws.ncleclipse.NonRuleBasedDamagerRepairer;
import br.ufma.deinf.laws.ncleclipse.format.NCLDocumentFormattingStrategy;
import br.ufma.deinf.laws.ncleclipse.format.XMLAutoIdentStrategy;
import br.ufma.deinf.laws.ncleclipse.hyperlinks.NCLEclipseHyperlinkDetector;
import br.ufma.deinf.laws.ncleclipse.scanners.CDataScanner;
import br.ufma.deinf.laws.ncleclipse.scanners.XMLScanner;
import br.ufma.deinf.laws.ncleclipse.scanners.XMLTagScanner;
import br.ufma.deinf.laws.ncleclipse.scanners.XMLTextScanner;
import br.ufma.deinf.laws.ncleclipse.util.ColorManager;
import br.ufma.deinf.laws.ncleclipse.util.IXMLColorConstants;
import br.ufma.deinf.laws.ncleclipse.util.NCLDoubleClickStrategy;
import br.ufma.deinf.laws.ncleditor.editor.contentassist.NCLCompletionProposal;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.formatter.MultiPassContentFormatter;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.URLHyperlinkDetector;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.texteditor.ITextEditor;

public class NCLConfiguration
extends TextSourceViewerConfiguration {
    private NCLDoubleClickStrategy doubleClickStrategy;
    private XMLTagScanner tagScanner;
    private XMLScanner scanner;
    private XMLTextScanner textScanner;
    private CDataScanner cdataScanner;
    private ColorManager colorManager;
    private NCLEditor editor;

    public NCLConfiguration(ColorManager colorManager, NCLEditor editor) {
        this.colorManager = colorManager;
        this.editor = editor;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__xml_comment", "__xml_pi", "__xml_doctype", "__xml_start_tag", "__xml_end_tag", "__xml_text"};
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this.doubleClickStrategy == null) {
            this.doubleClickStrategy = new NCLDoubleClickStrategy();
        }
        return this.doubleClickStrategy;
    }

    protected XMLScanner getXMLScanner() {
        if (this.scanner == null) {
            this.scanner = new XMLScanner(this.colorManager);
            this.scanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(IXMLColorConstants.DEFAULT))));
        }
        return this.scanner;
    }

    protected XMLTextScanner getXMLTextScanner() {
        if (this.textScanner == null) {
            this.textScanner = new XMLTextScanner(this.colorManager);
            this.textScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(IXMLColorConstants.DEFAULT))));
        }
        return this.textScanner;
    }

    protected CDataScanner getCDataScanner() {
        if (this.cdataScanner == null) {
            this.cdataScanner = new CDataScanner(this.colorManager);
            this.cdataScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(IXMLColorConstants.CDATA_TEXT))));
        }
        return this.cdataScanner;
    }

    protected XMLTagScanner getXMLTagScanner() {
        if (this.tagScanner == null) {
            this.tagScanner = new XMLTagScanner(this.colorManager);
            this.tagScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(IXMLColorConstants.TAG))));
        }
        return this.tagScanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getXMLTagScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__xml_start_tag");
        reconciler.setRepairer((IPresentationRepairer)dr, "__xml_start_tag");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getXMLTagScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__xml_end_tag");
        reconciler.setRepairer((IPresentationRepairer)dr, "__xml_end_tag");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getXMLScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getXMLScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__xml_doctype");
        reconciler.setRepairer((IPresentationRepairer)dr, "__xml_doctype");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getXMLScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__xml_pi");
        reconciler.setRepairer((IPresentationRepairer)dr, "__xml_pi");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getXMLTextScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__xml_text");
        reconciler.setRepairer((IPresentationRepairer)dr, "__xml_text");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getCDataScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__xml_cdata");
        reconciler.setRepairer((IPresentationRepairer)dr, "__xml_cdata");
        TextAttribute textAttribute = new TextAttribute(this.colorManager.getColor(IXMLColorConstants.XML_COMMENT));
        NonRuleBasedDamagerRepairer ndr = new NonRuleBasedDamagerRepairer(textAttribute);
        reconciler.setDamager((IPresentationDamager)ndr, "__xml_comment");
        reconciler.setRepairer((IPresentationRepairer)ndr, "__xml_comment");
        return reconciler;
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        NCLReconcilingStrategy strategy = new NCLReconcilingStrategy();
        strategy.setEditor(this.editor);
        MonoReconciler reconciler = new MonoReconciler((IReconcilingStrategy)strategy, false);
        return reconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        NCLCompletionProposal nclCompletionProcessor = new NCLCompletionProposal();
        assistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        assistant.setContentAssistProcessor((IContentAssistProcessor)nclCompletionProcessor, "__xml_start_tag");
        assistant.setContentAssistProcessor((IContentAssistProcessor)nclCompletionProcessor, "__xml_end_tag");
        assistant.setContentAssistProcessor((IContentAssistProcessor)nclCompletionProcessor, "__dftl_partition_content_type");
        assistant.setContextInformationPopupOrientation(20);
        assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        assistant.enableAutoActivation(true);
        assistant.setAutoActivationDelay(500);
        Color bgColor = this.colorManager.getColor(new RGB(255, 255, 255));
        assistant.setProposalSelectorBackground(bgColor);
        return assistant;
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        MultiPassContentFormatter formatter = new MultiPassContentFormatter(this.getConfiguredDocumentPartitioning(sourceViewer), "__dftl_partition_content_type");
        formatter.setMasterStrategy((IFormattingStrategy)new NCLDocumentFormattingStrategy());
        return formatter;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        XMLAutoIdentStrategy strategy = "__dftl_partition_content_type".equals(contentType) ? new XMLAutoIdentStrategy() : new DefaultIndentLineAutoEditStrategy();
        return new IAutoEditStrategy[]{strategy};
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        return new IHyperlinkDetector[]{new NCLEclipseHyperlinkDetector((ITextEditor)this.editor), new URLHyperlinkDetector()};
    }
}

