/*
 * Decompiled with CFR 0.152.
 */
package br.ufma.deinf.laws.ncleclipse.format;

import java.util.StringTokenizer;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class XMLFormatter {
    private String xmlVersion = "1.0";
    private String encoding = "UTF-8";
    private String indent = "\t";
    private String lineEnd = "\r\n";
    private char quote = (char)34;
    private String nbsp = "\u00a0";
    private int level = 0;
    private StringBuffer output = new StringBuffer();

    public String format(Document document) {
        this.output.append("<?xml version=");
        this.output.append(this.quote);
        this.output.append(this.xmlVersion);
        this.output.append(this.quote);
        this.output.append(" encoding=");
        this.output.append(this.quote);
        this.output.append(document.getXmlEncoding());
        this.output.append(this.quote);
        this.output.append("?>");
        this.output.append(this.lineEnd);
        this.processChildNodes(document.getChildNodes());
        return this.output.toString();
    }

    private void processChildNodes(NodeList children) {
        int i = 0;
        while (i < children.getLength()) {
            Node node = children.item(i);
            if (node instanceof Element) {
                this.processElement((Element)node);
            } else if (node instanceof ProcessingInstruction) {
                this.processPI((ProcessingInstruction)node);
            } else if (node instanceof Entity) {
                this.processEntity((Entity)node);
            } else if (node instanceof CDATASection) {
                this.processCDATA((CDATASection)node);
            } else if (node instanceof Text) {
                this.processText((Text)node);
            } else if (node instanceof Comment) {
                this.processComment((Comment)node);
            } else if (node instanceof DocumentType) {
                this.processDocumentType((DocumentType)node);
            } else {
                System.out.println(node.getClass().toString());
            }
            ++i;
        }
    }

    private void processCDATA(CDATASection section) {
        this.addIndent();
        this.output.append("<![CDATA[");
        this.output.append(section.getNodeValue());
        this.output.append("]]>");
        this.output.append(this.lineEnd);
    }

    private void processDocumentType(DocumentType type) {
        this.addIndent();
        this.output.append("<!DOCTYPE ");
        this.output.append(type.getNodeName());
        if (type.getPublicId() != null) {
            this.output.append(" PUBLIC ");
            this.output.append(this.quote);
            this.output.append(type.getPublicId());
            this.output.append(this.quote);
            this.output.append(" ");
            this.output.append(this.quote);
            this.output.append(type.getSystemId());
            this.output.append(this.quote);
        } else if (type.getSystemId() != null) {
            this.output.append(" SYSTEM ");
            this.output.append(this.quote);
            this.output.append(type.getSystemId());
            this.output.append(this.quote);
        }
        if (type.getInternalSubset() != null) {
            this.output.append(" [");
            this.output.append(this.lineEnd);
            this.output.append(type.getInternalSubset());
            this.addIndent();
            this.output.append("]");
        }
        this.output.append(">");
        this.output.append(this.lineEnd);
    }

    private void processEntity(Entity entity) {
        this.addIndent();
        this.output.append("<!ENTITY ");
        this.output.append(entity.getNodeName());
        this.output.append(" ");
        this.output.append(this.quote);
        String oldIndent = this.indent;
        String oldLineEnd = this.lineEnd;
        this.indent = "";
        this.lineEnd = "";
        this.swapQuote();
        this.processChildNodes(entity.getChildNodes());
        this.swapQuote();
        this.indent = oldIndent;
        this.lineEnd = oldLineEnd;
        this.output.append(this.quote);
        this.output.append(">");
        this.output.append(this.lineEnd);
    }

    private void processPI(ProcessingInstruction instruction) {
        this.addIndent();
        this.output.append("<?");
        this.output.append(instruction.getNodeName());
        this.output.append(" ");
        this.output.append(instruction.getData());
        this.output.append("?>");
        this.output.append(this.lineEnd);
    }

    private void processComment(Comment comment) {
        this.addIndent();
        this.output.append("<!--");
        this.output.append(comment.getData());
        this.output.append("-->");
        this.output.append(this.lineEnd);
    }

    private void processText(Text text) {
        String token = "";
        StringTokenizer tokenizer = new StringTokenizer(text.getData(), "& \t\r\n\u00a0", true);
        while (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken();
            if (token.indexOf(32) != -1 || token.indexOf(9) != -1 || token.indexOf(13) != -1 || token.indexOf(10) != -1) continue;
            this.outputText(token);
            break;
        }
        while (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken();
            if (token.indexOf(32) != -1 || token.indexOf(9) != -1 || token.indexOf(13) != -1 || token.indexOf(10) != -1) {
                if (!tokenizer.hasMoreTokens()) continue;
                this.output.append(" ");
                continue;
            }
            this.outputText(token);
        }
    }

    private void outputText(String token) {
        if (token.equals("&")) {
            this.output.append("&amp;");
        } else if (token.equals(this.nbsp)) {
            this.output.append("&160;");
        } else if (token.equals("<")) {
            this.output.append("&lt;");
        } else if (token.equals(">")) {
            this.output.append("&gt;");
        } else {
            this.output.append(token);
        }
    }

    private void processElement(Element element) {
        NamedNodeMap attributes = element.getAttributes();
        this.addIndent();
        this.output.append("<");
        this.output.append(element.getNodeName());
        int i = 0;
        while (i < attributes.getLength()) {
            Node node = attributes.item(i);
            if (node instanceof Attr) {
                Attr attr = (Attr)node;
                this.output.append(" ");
                this.output.append(attr.getNodeName());
                this.output.append("=");
                this.output.append(this.quote);
                this.output.append(attr.getValue());
                this.output.append(this.quote);
            }
            ++i;
        }
        if (element.hasChildNodes()) {
            NodeList children = element.getChildNodes();
            if (children.getLength() == 1 && element.getFirstChild() instanceof Text) {
                Text el = (Text)element.getFirstChild();
                System.out.println("aqui eu " + el.getData());
                if (el.getData().trim().equals("")) {
                    this.output.append("/>");
                    this.output.append(this.lineEnd);
                } else {
                    this.output.append(">");
                    ++this.level;
                    this.processChildNodes(children);
                    --this.level;
                    this.output.append("</");
                    this.output.append(element.getNodeName());
                    this.output.append(">");
                    this.output.append(this.lineEnd);
                }
            } else {
                this.output.append(">");
                this.output.append(this.lineEnd);
                ++this.level;
                this.processChildNodes(children);
                --this.level;
                this.addIndent();
                this.output.append("</");
                this.output.append(element.getNodeName());
                this.output.append(">");
                this.output.append(this.lineEnd);
            }
        } else {
            this.output.append("/>");
            this.output.append(this.lineEnd);
        }
    }

    private void addIndent() {
        int i = 0;
        while (i < this.level) {
            this.output.append(this.indent);
            ++i;
        }
    }

    private void swapQuote() {
        this.quote = this.quote == '\"' ? (char)39 : (char)34;
    }

    public String getIndent() {
        return this.indent;
    }

    public void setIndent(String indent) {
        this.indent = indent;
    }

    public String getLineEnd() {
        return this.lineEnd;
    }

    public void setLineEnd(String lineEnd) {
        this.lineEnd = lineEnd;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getXmlVersion() {
        return this.xmlVersion;
    }

    public void setXmlVersion(String xmlVersion) {
        this.xmlVersion = xmlVersion;
    }
}

