/*
 * Decompiled with CFR 0.152.
 */
package br.ufma.deinf.laws.ncleclipse.hyperlinks;

import br.ufma.deinf.laws.ncl.NCLStructure;
import br.ufma.deinf.laws.ncleclipse.hyperlinks.NCLEclipseHyperlink;
import br.ufma.deinf.laws.ncleditor.editor.contentassist.NCLSourceDocument;
import java.util.Collection;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.ui.texteditor.ITextEditor;

public class NCLEclipseHyperlinkDetector
implements IHyperlinkDetector {
    ITextEditor editor = null;

    public NCLEclipseHyperlinkDetector(ITextEditor editor) {
        this.editor = editor;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        String line;
        IRegion lineInfo;
        int offset = region.getOffset();
        NCLSourceDocument doc = (NCLSourceDocument)textViewer.getDocument();
        boolean tmp = false;
        if (!tmp) {
            ITypedRegion typedRegion;
            block9: {
                typedRegion = doc.getPartition(region.getOffset());
                if (typedRegion.getType() == "__xml_start_tag") break block9;
                return null;
            }
            try {
                String tagname = doc.getCurrentTagname(offset);
                int startRegionOffset = typedRegion.getOffset();
                if (doc.isAttributeValue(offset)) {
                    NCLStructure nclStructure;
                    Collection nclReference;
                    String currentAttr = doc.getCurrentAttribute(offset);
                    String attrValue = doc.getAttributeValueFromCurrentTagName(offset, currentAttr);
                    int startAttributeValue = doc.getStartAttributeValueOffset(offset) + 1;
                    if (startAttributeValue != -1 && !attrValue.equals("") && (nclReference = (nclStructure = NCLStructure.getInstance()).getNCLReference(tagname, currentAttr)) != null && nclReference.size() != 0) {
                        Region region1 = new Region(startAttributeValue, attrValue.length());
                        System.out.println(String.valueOf(attrValue) + " " + (startAttributeValue + 1) + " " + attrValue.length());
                        return new IHyperlink[]{new NCLEclipseHyperlink(this.editor, (IRegion)region1, attrValue)};
                    }
                }
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            return null;
        }
        try {
            lineInfo = doc.getLineInformationOfOffset(offset);
            line = doc.get(lineInfo.getOffset(), lineInfo.getLength());
        }
        catch (BadLocationException ex) {
            return null;
        }
        int begin = line.indexOf("<");
        int end = line.indexOf(">");
        if (end < 0 || begin < 0 || end == begin + 1) {
            return null;
        }
        String text = line.substring(begin + 1, end);
        System.out.println(lineInfo.getOffset());
        Region region1 = new Region(lineInfo.getOffset() + begin + 1, text.length() - 1);
        System.out.println(String.valueOf(text) + " " + (lineInfo.getOffset() + begin + 1) + " " + text.length());
        return new IHyperlink[]{new NCLEclipseHyperlink(this.editor, (IRegion)region1, text)};
    }
}

