/*
 * Decompiled with CFR 0.152.
 */
package br.ufma.deinf.laws.ncleclipse.launch.ui;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class GingaLaunchTabConfiguration
extends AbstractLaunchConfigurationTab {
    protected Label fProjectLabel;
    protected Text fProjectText;
    protected Label fNCLFileLabel;
    protected Text fNCLFileText;
    protected Label fNCLLauncherPathLabel;
    protected Text fNCLLauncherPathText;
    public static String DEFAULT_PROJECT = "";
    public static String DEFAULT_NCL_FILE = "";
    public static String DEFAULT_NCL_LAUNCHER_PATH = "ginga";
    protected GridLayout topLayout = null;
    protected Composite composite = null;

    public void createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.topLayout = new GridLayout();
        this.topLayout.numColumns = 3;
        this.composite.setLayout((Layout)this.topLayout);
        this.setControl((Control)this.composite);
        GridData gd = new GridData(768);
        gd = new GridData(768);
        this.fNCLFileLabel = new Label(this.composite, 0);
        this.fNCLFileLabel.setText("NCL File:");
        this.fNCLFileText = new Text(this.composite, 2052);
        this.fNCLFileText.setLayoutData((Object)gd);
        Button button = new Button(this.composite, 8);
        button.setText("Browse...");
        button.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        gd = new GridData(768);
        this.fNCLLauncherPathLabel = new Label(this.composite, 0);
        this.fNCLLauncherPathLabel.setText("NCL Launcher Path:");
        this.fNCLLauncherPathText = new Text(this.composite, 2052);
        this.fNCLLauncherPathText.setLayoutData((Object)gd);
    }

    public String getName() {
        return "Main";
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.fNCLFileText.setText(configuration.getAttribute("nclFile", DEFAULT_NCL_FILE));
            this.fNCLLauncherPathText.setText(configuration.getAttribute("nclLauncherPath", DEFAULT_NCL_LAUNCHER_PATH));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("nclFile", this.fNCLFileText.getText());
        configuration.setAttribute("nclLauncherPath", this.fNCLLauncherPathText.getText());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        return true;
    }

    protected void handleProjectBrowse() {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new LabelProvider());
        dialog.setTitle("String Selection");
        dialog.setMessage("Select a Project (* = any string, ? = any char):");
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projects = root.getProjects();
        ArrayList<String> objects = new ArrayList<String>();
        int i = 0;
        while (i < projects.length) {
            objects.add(new String(projects[i].getName()));
            ++i;
        }
        dialog.setElements(objects.toArray());
        if (dialog.open() == 0) {
            Object[] result = dialog.getResult();
            System.out.println(result[0]);
            if (result.length == 1) {
                this.fProjectText.setText((String)result[0]);
            }
        }
    }

    protected void handleResourcesBrowse() {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
        dialog.setTitle("NCL main file Select");
        dialog.setMessage("Select the elements from the tree:");
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        if (dialog.open() == 0) {
            Object[] result = dialog.getResult();
            if (result.length == 1) {
                IResource path = (IResource)result[0];
                System.out.println(path.getLocation().toOSString());
                this.fNCLFileText.setText(path.getLocation().toOSString());
            } else {
                Status status = new Status(4, "br.ufma.deinf.laws.ncleclipse", 0, "Status Error Message", null);
                ErrorDialog.openError((Shell)this.getShell(), (String)"Error", (String)"You must select one (and just one) file.", (IStatus)status);
            }
        }
    }
}

