/*
 * Decompiled with CFR 0.152.
 */
package br.ufma.deinf.laws.ncleditor.editor.contentassist;

import br.ufma.deinf.laws.ncl.AttributeValues;
import br.ufma.deinf.laws.ncl.NCLReference;
import br.ufma.deinf.laws.ncl.NCLStructure;
import br.ufma.deinf.laws.ncl.help.NCLHelper;
import br.ufma.deinf.laws.ncleclipse.ncl.NCLContentHandler;
import br.ufma.deinf.laws.ncleclipse.ncl.NCLDocument;
import br.ufma.deinf.laws.ncleclipse.ncl.NCLElement;
import br.ufma.deinf.laws.ncleclipse.ncl.NCLParser;
import br.ufma.deinf.laws.ncleclipse.scanners.XMLTagScanner;
import br.ufma.deinf.laws.ncleditor.editor.contentassist.NCLCompletionProposal;
import br.ufma.deinf.laws.ncleditor.editor.contentassist.NCLSourceDocument;
import br.ufma.deinf.laws.ncleditor.editor.contentassist.URIProposer;
import java.io.File;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.Workbench;
import org.xml.sax.ContentHandler;

public class NCLCompletionProposal
implements IContentAssistProcessor {
    private XMLTagScanner scanner;
    private File currentFile;
    private String text;
    private String[] protocols = new String[]{"file:///", "http://", "rtsp://", "rtp://", "sbtvd-ts://"};
    private boolean isAttributeValue;
    private boolean isAttribute;
    private boolean isEndTagName;
    private int cursor;

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
        IWorkbenchPage page = win.getActivePage();
        IEditorPart editor = page.getActiveEditor();
        ArrayList propList = new ArrayList();
        try {
            this.currentFile = editor.getEditorInput() instanceof IFileEditorInput ? ((IFileEditorInput)editor.getEditorInput()).getFile().getFullPath().toFile() : new File(((IURIEditorInput)editor.getEditorInput()).getURI());
        }
        catch (Exception e) {
            e.printStackTrace();
            ICompletionProposal[] proposal = new ICompletionProposal[]{};
            return proposal;
        }
        IDocument doc = viewer.getDocument();
        this.text = doc.get();
        NCLSourceDocument nclDoc = NCLSourceDocument.createNCLSourceDocumentFromIDocument((IDocument)doc);
        this.isAttributeValue = nclDoc.isAttributeValue(offset);
        this.isAttribute = nclDoc.isAttribute(offset);
        this.isEndTagName = nclDoc.isEndTagName(offset);
        Point selectedRange = viewer.getSelectedRange();
        if (selectedRange.y <= 0) {
            System.out.println("Attributo = " + this.isAttribute);
            String qualifier = this.getQualifier(doc, offset);
            if (this.isEndTagName) {
                this.computeEndTagName(doc, qualifier, offset, propList);
            } else if (this.isAttributeValue) {
                this.computeAttributesValuesProposals(doc, qualifier, offset, propList);
            } else if (!this.isAttribute) {
                this.computeTagsProposals(doc, qualifier, offset, propList);
            } else if (!nclDoc.isTagname(offset)) {
                this.computeAttributesProposals(doc, qualifier, offset, propList);
            }
        }
        ICompletionProposal[] proposals = new ICompletionProposal[propList.size()];
        propList.toArray(proposals);
        return proposals;
    }

    private void computeEndTagName(IDocument doc, String qualifier, int offset, List propList) {
        int qlen = qualifier.length();
        NCLSourceDocument nclDoc = NCLSourceDocument.createNCLSourceDocumentFromIDocument((IDocument)doc);
        int fatherOffset = nclDoc.getFatherPartitionOffsetFromEndTag(offset);
        String tagname = nclDoc.getCurrentTagname(fatherOffset);
        String prop = "</" + tagname + ">";
        this.cursor = prop.length();
        CompletionProposal proposal = new CompletionProposal(prop, offset - qlen, qlen, this.cursor, null, prop, null, null);
        propList.add(proposal);
    }

    private void computeTagsProposals(IDocument doc, String qualifier, int offset, List propList) {
        int qlen = qualifier.length();
        NCLStructure nclStructure = NCLStructure.getInstance();
        String indent = this.getIndentLine(doc, offset);
        NCLSourceDocument nclDoc = NCLSourceDocument.createNCLSourceDocumentFromIDocument((IDocument)doc);
        System.out.println("## Log: Pai da tag onde estou digitando : " + nclDoc.getFatherTagName(offset));
        Map nesting = nclStructure.getNesting();
        Vector childrenStr = new Vector();
        String fatherTagName = nclDoc.getFatherTagName(offset);
        if (fatherTagName.equals("")) {
            String tagname = "ncl";
            String tagname2 = "<" + tagname;
            if (tagname.startsWith(qualifier) || tagname2.startsWith(qualifier)) {
                String text = this.computeTagStructure(tagname, indent);
                NCLHelper.getNCLHelper();
                String helpInfo = NCLHelper.getHelpDescription((String)tagname);
                CompletionProposal proposal = new CompletionProposal(text, offset - qlen, qlen, this.cursor, null, tagname, null, helpInfo);
                propList.add(proposal);
            }
        } else if (nesting.containsKey(fatherTagName)) {
            Map children = (Map)nesting.get(fatherTagName);
            for (Map.Entry entry : children.entrySet()) {
                String tagname = (String)entry.getKey();
                String tagname2 = "<" + tagname;
                if (!tagname.startsWith(qualifier) && !tagname2.startsWith(qualifier)) continue;
                String text = this.computeTagStructure(tagname, indent);
                NCLHelper.getNCLHelper();
                String helpInfo = NCLHelper.getHelpDescription((String)tagname);
                CompletionProposal proposal = new CompletionProposal(text, offset - qlen, qlen, this.cursor, null, tagname, null, helpInfo);
                propList.add(proposal);
            }
            return;
        }
    }

    String computeTagStructure(String tagname, String indent) {
        String ret;
        NCLStructure nclStructure = NCLStructure.getInstance();
        Map atts = NCLStructure.getAttributes((String)tagname);
        Map children = NCLStructure.getChildrenCardinality((String)tagname);
        Iterator it = atts.entrySet().iterator();
        String attributes = "";
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (!((Boolean)entry.getValue()).booleanValue()) continue;
            attributes = String.valueOf(attributes) + " " + (String)entry.getKey() + "=\"\"";
        }
        if (children.size() == 0) {
            ret = "<" + tagname + attributes + "/>" + "\r\n" + indent;
            this.cursor = ret.length();
        } else {
            ret = "<" + tagname + attributes + ">" + "\r\n" + indent + "\t";
            this.cursor = ret.length();
            ret = String.valueOf(ret) + "\r\n" + indent + "</" + tagname + ">";
        }
        return ret;
    }

    private void computeAttributesValuesProposals(IDocument doc, String qualifier, int offset, List propList) {
        CompletionProposal proposal;
        String idAtual;
        Iterator it2;
        Collection elements;
        String perspective;
        NCLDocument nclDocument;
        NCLStructure nclStructure;
        String attribute;
        String tagname;
        NCLSourceDocument nclDoc;
        int qlen;
        block33: {
            qlen = qualifier.length();
            nclDoc = NCLSourceDocument.createNCLSourceDocumentFromIDocument((IDocument)doc);
            tagname = nclDoc.getCurrentTagname(offset);
            attribute = nclDoc.getCurrentAttribute(offset);
            System.out.println("tag: " + tagname + " attr:" + attribute);
            nclStructure = NCLStructure.getInstance();
            Vector prop = AttributeValues.getValues((int)NCLStructure.getDataType((String)tagname, (String)attribute));
            if (prop.size() > 0) {
                int i = 0;
                while (i < prop.size()) {
                    if (((String)prop.get(i)).startsWith(qualifier)) {
                        String text;
                        String texttoshow = text = (String)prop.get(i);
                        System.out.println(text);
                        this.cursor = text.length();
                        CompletionProposal proposal2 = new CompletionProposal(text, offset - qlen, qlen, this.cursor, null, texttoshow, null, null);
                        propList.add(proposal2);
                    }
                    ++i;
                }
                return;
            }
            String nclText = doc.get();
            NCLContentHandler nclContentHandler = new NCLContentHandler();
            nclDocument = new NCLDocument();
            nclDocument.setParentURI(this.currentFile.getParentFile().toURI());
            nclContentHandler.setNclDocument(nclDocument);
            NCLParser parser = new NCLParser();
            parser.setContentHandler((ContentHandler)nclContentHandler);
            parser.doParse(nclText);
            perspective = null;
            if (tagname.equals("port") && attribute.equals("component") || tagname.equals("bindRule") && attribute.equals("constituent") || tagname.equals("defaultComponent") && attribute.equals("component")) {
                System.out.println("aqqqqqq");
                String fatherTagName = nclDoc.getFatherTagName(offset);
                perspective = nclDoc.getAttributeValueFromCurrentTagName(nclDoc.getFatherPartitionOffset(offset), "id");
                if (perspective == null) {
                    if (fatherTagName.equals("body")) {
                        perspective = nclDoc.getAttributeValueFromCurrentTagName(nclDoc.getFatherPartitionOffset(nclDoc.getFatherPartitionOffset(offset)), "id");
                        if (perspective == null) {
                            MessageDialog.openError((Shell)Workbench.getInstance().getActiveWorkbenchWindow().getShell(), (String)"Erro", (String)"Elemento <ncl> ou <body> deve possuir um id para o funcionamento correto do Autocomplete!");
                            return;
                        }
                    } else {
                        MessageDialog.openError((Shell)Workbench.getInstance().getActiveWorkbenchWindow().getShell(), (String)"Erro", (String)("Elemento <" + fatherTagName + "> deve possuir um id para o funcionamento correto do Autocomplete!"));
                    }
                }
            }
            if (tagname.equals("bind") && attribute.equals("component") || tagname.equals("mapping") && attribute.equals("component")) {
                String grandFatherTagName = nclDoc.getFatherTagName(nclDoc.getFatherPartitionOffset(offset));
                try {
                    perspective = nclDoc.getAttributeValueFromCurrentTagName(nclDoc.getFatherPartitionOffset(nclDoc.getFatherPartitionOffset(offset)), "id");
                }
                catch (Exception e) {
                    if (!grandFatherTagName.equals("body")) break block33;
                    perspective = nclDoc.getAttributeValueFromCurrentTagName(nclDoc.getFatherPartitionOffset(nclDoc.getFatherPartitionOffset(nclDoc.getFatherPartitionOffset(offset))), "id");
                }
            }
        }
        if (tagname.equals("bind") && attribute.equals("role") || tagname.equals("linkParam") && attribute.equals("name")) {
            perspective = nclDoc.getAttributeValueFromCurrentTagName(nclDoc.getFatherPartitionOffset(offset), "xconnector");
        }
        if (tagname.equals("bindParam") && attribute.equals("name")) {
            perspective = nclDoc.getAttributeValueFromCurrentTagName(nclDoc.getFatherPartitionOffset(nclDoc.getFatherPartitionOffset(offset)), "xconnector");
        }
        if (tagname.equals("bind") && attribute.equals("interface") || tagname.equals("port") && attribute.equals("interface") || tagname.equals("mapping") && attribute.equals("interface")) {
            perspective = nclDoc.getAttributeValueFromCurrentTagName(offset, "component");
            NCLElement element = nclDocument.getElementById(perspective);
            while (element != null && element.getAttributes().get("refer") != null) {
                Collection nclReference = nclStructure.getNCLReference(tagname, attribute);
                String perspectivetmp = element.getAttributeValue("refer");
                element = nclDocument.getElementById(perspectivetmp);
                if (nclReference == null) {
                    return;
                }
                for (NCLReference nclRefAtual : nclReference) {
                    Collection elements2 = nclDocument.getElementsFromPerspective(nclRefAtual.getRefTagname(), perspectivetmp);
                    if (elements2 == null) continue;
                    Iterator it22 = elements2.iterator();
                    while (it22.hasNext()) {
                        String idAtual2;
                        this.text = ((NCLElement)it22.next()).getAttributeValue(nclRefAtual.getRefAttribute());
                        if (this.text == null || attribute.equals("refer") && (idAtual2 = nclDoc.getAttributeValueFromCurrentTagName(offset, "id")) != null && this.text.equals(idAtual2) || !this.text.startsWith(qualifier)) continue;
                        this.cursor = this.text.length();
                        System.out.println("Attribute Value Proposal = " + this.text);
                        CompletionProposal proposal3 = new CompletionProposal(this.text, offset - qlen, qlen, this.cursor, null, this.text, null, null);
                        propList.add(proposal3);
                    }
                }
            }
        }
        if (tagname.equals("media") && attribute.equals("src") || tagname.equals("importBase") && attribute.equals("documentURI")) {
            int i = 0;
            while (i < this.protocols.length) {
                this.text = this.protocols[i];
                if (this.text.startsWith(qualifier)) {
                    this.cursor = this.text.length();
                    System.out.println("Attribute Value Proposal = " + this.text);
                    CompletionProposal proposal4 = new CompletionProposal(this.text, offset - qlen, qlen, this.cursor, null, this.text, null, null);
                    propList.add(proposal4);
                }
                ++i;
            }
            File file = null;
            file = new File(this.currentFile.toURI());
            try {
                CompletionProposal proposal5;
                URIProposer fs = new URIProposer(this.currentFile.getParent().toString());
                Vector v = fs.getDirectories(qualifier);
                int i2 = 0;
                while (i2 < v.size()) {
                    if (((String)v.get(i2)).startsWith(qualifier)) {
                        this.cursor = ((String)v.get(i2)).length();
                        proposal5 = new CompletionProposal((String)v.get(i2), offset - qlen, qlen, this.cursor, null, (String)v.get(i2), null, null);
                        propList.add(proposal5);
                    }
                    ++i2;
                }
                fs = new URIProposer(this.currentFile.getParent().toString());
                v = fs.getFiles(qualifier);
                i2 = 0;
                while (i2 < v.size()) {
                    if (((String)v.get(i2)).startsWith(qualifier)) {
                        this.cursor = ((String)v.get(i2)).length();
                        proposal5 = new CompletionProposal((String)v.get(i2), offset - qlen, qlen, this.cursor, null, (String)v.get(i2), null, null);
                        propList.add(proposal5);
                    }
                    ++i2;
                }
                return;
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        System.out.println("perspective = " + perspective);
        Collection nclReference = nclStructure.getNCLReference(tagname, attribute);
        if (nclReference == null) {
            return;
        }
        for (NCLReference nclRefAtual : nclReference) {
            elements = nclDocument.getElementsFromPerspective(nclRefAtual.getRefTagname(), perspective);
            if (elements == null) continue;
            it2 = elements.iterator();
            while (it2.hasNext()) {
                this.text = ((NCLElement)it2.next()).getAttributeValue(nclRefAtual.getRefAttribute());
                if (this.text == null || attribute.equals("refer") && (idAtual = nclDoc.getAttributeValueFromCurrentTagName(offset, "id")) != null && this.text.equals(idAtual) || !this.text.startsWith(qualifier)) continue;
                this.cursor = this.text.length();
                System.out.println("Attribute Value Proposal = " + this.text);
                proposal = new CompletionProposal(this.text, offset - qlen, qlen, this.cursor, null, this.text, null, null);
                propList.add(proposal);
            }
        }
        Iterator it = nclReference.iterator();
        if (perspective == null) {
            for (NCLReference nclRefAtual : nclReference) {
                elements = nclDocument.getElements().get(nclRefAtual.getRefTagname());
                if (elements == null) continue;
                it2 = elements.iterator();
                while (it2.hasNext()) {
                    this.text = ((NCLElement)it2.next()).getAttributeValue(nclRefAtual.getRefAttribute());
                    System.out.println(this.text);
                    if (attribute.equals("refer") && (idAtual = nclDoc.getAttributeValueFromCurrentTagName(offset, "id")) != null && this.text.equals(idAtual) || !this.text.startsWith(qualifier)) continue;
                    this.cursor = this.text.length();
                    System.out.println("Attribute Value Proposal = " + this.text);
                    proposal = new CompletionProposal(this.text, offset - qlen, qlen, this.cursor, null, this.text, null, null);
                    propList.add(proposal);
                }
            }
        }
    }

    private void computeAttributesProposals(IDocument doc, String qualifier, int offset, List propList) {
        int qlen = qualifier.length();
        NCLSourceDocument nclDoc = NCLSourceDocument.createNCLSourceDocumentFromIDocument((IDocument)doc);
        System.out.println("Computing Attributes proposals...");
        String currentTagname = nclDoc.getCurrentTagname(offset);
        System.out.println("Current Tag Name = " + currentTagname);
        List attributeTyped = nclDoc.getAttributesTyped(offset);
        NCLStructure nclStructure = NCLStructure.getInstance();
        Map atts = NCLStructure.getAttributes((String)currentTagname);
        for (Map.Entry entry : atts.entrySet()) {
            String prop;
            String view = (String)entry.getKey();
            if (attributeTyped.contains(view) || view == null || !(prop = String.valueOf((String)entry.getKey()) + "=\"\"").startsWith(qualifier)) continue;
            this.cursor = prop.length();
            String helpInfo = NCLHelper.getNCLHelper().getHelpDescription(currentTagname, view);
            CompletionProposal proposal = new CompletionProposal(prop, offset - qlen, qlen, this.cursor, null, view, null, helpInfo);
            propList.add(proposal);
        }
    }

    private String getQualifier(IDocument doc, int offset) {
        StringBuffer buf = new StringBuffer();
        if (this.isAttributeValue) {
            try {
                while (true) {
                    char c;
                    if ((c = doc.getChar(--offset)) == '\"' || c == '\'') {
                        return buf.reverse().toString();
                    }
                    buf.append(c);
                }
            }
            catch (BadLocationException e) {
                return "";
            }
        }
        try {
            char c;
            while (Character.isLetter(c = doc.getChar(--offset)) || c == '<' || c == '/' || c == '#' || c == '.' || c == ':' || Character.isDigit(c)) {
                buf.append(c);
            }
            return buf.reverse().toString();
        }
        catch (BadLocationException e) {
            return "";
        }
    }

    private String getIndentLine(IDocument doc, int offset) {
        int ident = 0;
        try {
            char c;
            while ((c = doc.getChar(--offset)) != '\n') {
                if (c == '\t') {
                    ++ident;
                    continue;
                }
                ident = 0;
            }
        }
        catch (BadLocationException e) {
            ident = 0;
        }
        String str = "";
        int i = 0;
        while (i < ident) {
            str = String.valueOf(str) + "\t";
            ++i;
        }
        return str;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'<'};
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return new char[]{'<'};
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    private TextInfo currentText(IDocument document, int documentOffset) {
        try {
            ITypedRegion region = document.getPartition(documentOffset);
            int partitionOffset = region.getOffset();
            int partitionLength = region.getLength();
            int index = documentOffset - partitionOffset;
            String partitionText = document.get(partitionOffset, partitionLength);
            System.out.println("Partition text: " + document.get(partitionOffset, region.getLength()));
            char c = partitionText.charAt(index);
            if (Character.isWhitespace(c) || Character.isWhitespace(partitionText.charAt(index - 1))) {
                return new TextInfo("", documentOffset, true);
            }
            if (c == '<') {
                return new TextInfo("", documentOffset, true);
            }
            int start = index;
            c = partitionText.charAt(start);
            while (!Character.isWhitespace(c) && c != '<' && start >= 0) {
                c = partitionText.charAt(--start);
            }
            ++start;
            int end = index;
            c = partitionText.charAt(end);
            while (!Character.isWhitespace(c) && c != '>' && end < partitionLength - 1) {
                c = partitionText.charAt(++end);
            }
            String substring = partitionText.substring(start, end);
            return new TextInfo(substring, partitionOffset + start, false);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return null;
        }
    }
}

