/*
 * Decompiled with CFR 0.152.
 */
package br.ufma.deinf.laws.ncleclipse.hyperlinks;

import br.ufma.deinf.laws.ncleclipse.ncl.NCLContentHandler;
import br.ufma.deinf.laws.ncleclipse.ncl.NCLDocument;
import br.ufma.deinf.laws.ncleclipse.ncl.NCLElement;
import br.ufma.deinf.laws.ncleclipse.ncl.NCLParser;
import java.io.File;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.xml.sax.ContentHandler;

public class NCLEclipseHyperlink
implements IHyperlink {
    int start;
    int length;
    private String text;
    private IRegion region;
    private File currentFile;
    ITextViewer textViewer;
    ITextEditor textEditor;

    public NCLEclipseHyperlink(ITextViewer textViewer, ITextEditor textEditor, IRegion region, String text) {
        this.region = region;
        this.text = text;
        this.textViewer = textViewer;
        this.textEditor = textEditor;
    }

    public IRegion getHyperlinkRegion() {
        return this.region;
    }

    public void open() {
        if (this.text != null) {
            System.out.println("Moving...");
            try {
                IWorkbench wb = PlatformUI.getWorkbench();
                IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
                IWorkbenchPage page = win.getActivePage();
                IEditorPart editor = page.getActiveEditor();
                this.currentFile = editor.getEditorInput() instanceof IFileEditorInput ? ((IFileEditorInput)editor.getEditorInput()).getFile().getFullPath().toFile() : new File(((IURIEditorInput)editor.getEditorInput()).getURI());
                String nclText = this.textViewer.getDocument().get();
                NCLContentHandler nclContentHandler = new NCLContentHandler();
                NCLDocument nclDocument = new NCLDocument();
                nclDocument.setParentURI(this.currentFile.getParentFile().toURI());
                nclContentHandler.setNclDocument(nclDocument);
                NCLParser parser = new NCLParser();
                parser.setContentHandler((ContentHandler)nclContentHandler);
                parser.doParse(nclText);
                NCLElement el = nclDocument.getElementById(this.text);
                int line = el.getLineNumber();
                int lineOffset = this.textViewer.getDocument().getLineOffset(line);
                int lineLength = this.textViewer.getDocument().getLineLength(line);
                this.textEditor.resetHighlightRange();
                this.textEditor.setHighlightRange(lineOffset, lineLength, true);
                this.textEditor.setFocus();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String getTypeLabel() {
        return null;
    }

    public String getHyperlinkText() {
        return null;
    }
}

