/*
 * Decompiled with CFR 0.152.
 */
package br.ufma.deinf.laws.ncleclipse.layout;

import br.ufma.deinf.laws.ncleclipse.layout.NCLLayoutEditor;
import br.ufma.deinf.laws.ncleclipse.layout.RegionTransformer;
import br.ufma.deinf.laws.ncleclipse.layout.model.Node;
import br.ufma.deinf.laws.ncleclipse.layout.model.NodeCreationFactory;
import br.ufma.deinf.laws.ncleclipse.layout.model.Region;
import br.ufma.deinf.laws.ncleclipse.layout.model.RegionBase;
import br.ufma.deinf.laws.ncleclipse.layout.part.AppEditPartFactory;
import br.ufma.deinf.laws.ncleclipse.ncl.NCLDocument;
import br.ufma.deinf.laws.ncleclipse.ncl.NCLParser;
import br.ufma.deinf.laws.ncleclipse.ncl.NCLRegionBaseContentHandler;
import br.ufma.deinf.laws.ncleditor.editor.contentassist.NCLSourceDocument;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.palette.CreationToolEntry;
import org.eclipse.gef.palette.MarqueeToolEntry;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.PaletteSeparator;
import org.eclipse.gef.palette.SelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.parts.GraphicalEditorWithPalette;
import org.eclipse.gef.ui.parts.SelectionSynchronizer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.xml.sax.ContentHandler;

public class NCLLayoutEditor
extends GraphicalEditorWithPalette {
    private PaletteRoot paletteRoot;
    private NCLSourceDocument nclSourceDocument;
    private RegionBase model;
    private KeyHandler keyHandler;

    public NCLLayoutEditor() {
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
    }

    public NCLSourceDocument getNclSourceDocument() {
        return this.nclSourceDocument;
    }

    public void setNclSourceDocument(NCLSourceDocument nclSourceDocument) {
        this.nclSourceDocument = nclSourceDocument;
    }

    public RegionBase createRegionBase() {
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
        IWorkbenchPage page = win.getActivePage();
        if (page == null) {
            return new RegionBase();
        }
        IEditorPart editor = page.getActiveEditor();
        IFile currentFile = ((FileEditorInput)this.getEditorInput()).getFile();
        RegionBase psyEntreprise = new RegionBase();
        psyEntreprise.setId("RegionBase");
        try {
            NCLParser parser = new NCLParser();
            NCLRegionBaseContentHandler nclContentHandler = new NCLRegionBaseContentHandler();
            NCLDocument nclDocument = new NCLDocument();
            String text = this.nclSourceDocument.get();
            parser.setContentHandler((ContentHandler)nclContentHandler);
            parser.doParse(text);
            psyEntreprise = nclContentHandler.getRegionBase();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return psyEntreprise;
    }

    protected void initializeGraphicalViewer() {
        GraphicalViewer viewer = this.getGraphicalViewer();
        this.model = this.createRegionBase();
        viewer.setContents((Object)this.createRegionBase());
    }

    public void refreshGraphicalViewer() {
        GraphicalViewer viewer = this.getGraphicalViewer();
        this.model = this.createRegionBase();
        viewer.setContents((Object)this.createRegionBase());
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.setEditPartFactory((EditPartFactory)new AppEditPartFactory());
        this.keyHandler = new KeyHandler();
        this.keyHandler.put(KeyStroke.getPressed((char)'\u007f', (int)127, (int)0), this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId()));
        viewer.setKeyHandler(this.keyHandler);
    }

    public void refreshNCLSourceDocument() {
        List children = ((RegionBase)this.getGraphicalViewer().getContents().getModel()).getChildrenArray();
        int i = 0;
        while (i < children.size()) {
            this.refreshRegionInSource((Region)children.get(i));
            ++i;
        }
    }

    private void refreshRegionInSource(Region rg) {
        Integer it = rg.getHeight();
        this.nclSourceDocument.setAttribute(rg.getId(), "height", it.toString());
        it = rg.getWidth();
        this.nclSourceDocument.setAttribute(rg.getId(), "width", it.toString());
        it = rg.getTop();
        this.nclSourceDocument.setAttribute(rg.getId(), "top", it.toString());
        it = rg.getLeft();
        this.nclSourceDocument.setAttribute(rg.getId(), "left", it.toString());
        List children = rg.getChildrenArray();
        int i = 0;
        while (i < children.size()) {
            this.refreshRegionInSource((Region)children.get(i));
            ++i;
        }
    }

    public void doSave(IProgressMonitor monitor) {
        RegionTransformer.modelToText((Node)this.model);
    }

    public Object getAdapter(Class type) {
        if (type == IContentOutlinePage.class) {
            return new OutlinePage(this);
        }
        return super.getAdapter(type);
    }

    protected PaletteRoot getPaletteRoot() {
        if (this.paletteRoot == null) {
            this.paletteRoot = new PaletteRoot();
            PaletteGroup manipGroup = new PaletteGroup("Manipula\u00e7\u00e3o dos Objetos");
            this.paletteRoot.add((PaletteEntry)manipGroup);
            SelectionToolEntry selectionToolEntry = new SelectionToolEntry();
            manipGroup.add((PaletteEntry)selectionToolEntry);
            manipGroup.add((PaletteEntry)new MarqueeToolEntry());
            this.paletteRoot.setDefaultEntry((ToolEntry)selectionToolEntry);
            PaletteSeparator sep2 = new PaletteSeparator();
            this.paletteRoot.add((PaletteEntry)sep2);
            PaletteGroup instGroup = new PaletteGroup("Criar Regi\u00f5es");
            this.paletteRoot.add((PaletteEntry)instGroup);
            instGroup.add((PaletteEntry)new CreationToolEntry("New Region", "Criar nova regi\u00e3o", (CreationFactory)new NodeCreationFactory(Region.class), null, null));
        }
        return this.paletteRoot;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.updateActions(this.getSelectionActions());
    }

    static /* synthetic */ DefaultEditDomain access$0(NCLLayoutEditor nCLLayoutEditor) {
        return nCLLayoutEditor.getEditDomain();
    }

    static /* synthetic */ RegionBase access$1(NCLLayoutEditor nCLLayoutEditor) {
        return nCLLayoutEditor.model;
    }

    static /* synthetic */ SelectionSynchronizer access$2(NCLLayoutEditor nCLLayoutEditor) {
        return nCLLayoutEditor.getSelectionSynchronizer();
    }

    static /* synthetic */ ActionRegistry access$3(NCLLayoutEditor nCLLayoutEditor) {
        return nCLLayoutEditor.getActionRegistry();
    }

    static /* synthetic */ KeyHandler access$4(NCLLayoutEditor nCLLayoutEditor) {
        return nCLLayoutEditor.keyHandler;
    }
}

