/*
 * Decompiled with CFR 0.152.
 */
package br.ufma.deinf.gia.labmint.document;

import br.ufma.deinf.gia.labmint.document.DocumentUtil;
import br.ufma.deinf.gia.labmint.message.MessageList;
import br.ufma.deinf.gia.labmint.xml.XMLParserExtend;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class NclValidatorDocument {
    protected Map<String, Element> elements = new HashMap();
    protected Map<String, NclValidatorDocument> aliases = new HashMap();
    protected Element root;
    protected String id;
    protected String path;

    public NclValidatorDocument(Document doc) throws ParserConfigurationException, URISyntaxException, SAXException, IOException {
        this.root = doc.getDocumentElement();
        this.path = doc.getBaseURI();
        this.id = null;
        System.out.println(">> Validating File = " + this.path);
        if (this.root.hasAttribute("id")) {
            this.id = this.root.getAttribute("id");
        } else {
            NodeList nodeList = this.root.getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                Element element;
                Node node = nodeList.item(i);
                if (node.getNodeType() == 1 && (element = (Element)node).getTagName().compareTo("body") == 0 && element.hasAttribute("id")) {
                    this.id = element.getAttribute("id");
                }
                ++i;
            }
        }
        this.parse(this.root);
    }

    public String getId() {
        return this.id;
    }

    public Element getDocumentElement() {
        return this.root;
    }

    public Element getElement(String id) {
        if (this.elements.containsKey(id)) {
            return (Element)this.elements.get(id);
        }
        if (id.indexOf("#") < 0) {
            return null;
        }
        if (id.indexOf("#") != id.lastIndexOf("#")) {
            return null;
        }
        int index = id.indexOf("#");
        String alias = id.substring(0, index);
        String docId = id.substring(index + 1);
        if (!this.aliases.containsKey(alias)) {
            return null;
        }
        NclValidatorDocument doc = (NclValidatorDocument)this.aliases.get(alias);
        return doc.getElement(docId);
    }

    protected void parse(Element root) {
        Vector<String> args;
        if (root.hasAttribute("id")) {
            String id = root.getAttribute("id");
            if (!this.elements.containsKey(id)) {
                this.elements.put(id, root);
            } else {
                args = new Vector<String>();
                args.add(id);
                MessageList.addError((String)this.id, (int)3001, (Element)root, args);
            }
        }
        if (root.getTagName().equals("importBase")) {
            if (root.hasAttribute("alias")) {
                if (root.hasAttribute("documentURI") && !root.getAttribute("documentURI").equals("")) {
                    try {
                        XMLParserExtend parser = new XMLParserExtend();
                        Document doc = null;
                        URI uri = new URI(root.getAttribute("documentURI"));
                        if (uri.isAbsolute()) {
                            parser.parse(uri.getPath());
                            doc = parser.getDocument();
                        } else {
                            parser.parse(DocumentUtil.getAbsoluteFileName((String)this.getPath(), (String)root.getAttribute("documentURI")));
                            doc = parser.getDocument();
                        }
                        if (!this.addDocument(root.getAttribute("alias"), new NclValidatorDocument(doc))) {
                            Vector<String> args2 = new Vector<String>();
                            args2.add(root.getAttribute("alias"));
                            MessageList.addError((String)this.id, (int)3002, (Element)root, args2);
                        }
                    }
                    catch (Exception e) {
                        args = new Vector();
                        args.add(e.getMessage());
                        MessageList.addError((String)this.id, (int)1003, (Element)root, args);
                    }
                } else {
                    MessageList.addError((String)this.getPath(), (int)3101, (Element)root);
                }
            } else {
                MessageList.addError((String)this.getPath(), (int)3102, (Element)root);
            }
        }
        NodeList nodeList = root.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1) {
                this.parse((Element)node);
            }
            ++i;
        }
    }

    public boolean addDocument(String alias, NclValidatorDocument doc) {
        if (this.aliases.containsKey(alias)) {
            return false;
        }
        this.aliases.put(alias, doc);
        return true;
    }

    public Map<String, NclValidatorDocument> getAliases() {
        return this.aliases;
    }

    public void setAliases(Map<String, NclValidatorDocument> aliases) {
        this.aliases = aliases;
    }

    public Map<String, Element> getElements() {
        return this.elements;
    }

    public void setElements(Map<String, Element> elements) {
        this.elements = elements;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Element getRoot() {
        return this.root;
    }

    public void setRoot(Element root) {
        this.root = root;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDir() {
        String path = this.getPath();
        int i = path.length() - 1;
        while (i >= 0) {
            if (path.charAt(i) == '/') {
                return path.substring(0, i + 1);
            }
            --i;
        }
        return path;
    }

    public Element getElementInContext(String idContext, String id) {
        if (this.elements.containsKey(idContext)) {
            Element context = (Element)this.elements.get(idContext);
            NodeList nodeList = context.getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                Node node = nodeList.item(i);
                if (node.getNodeType() == 1) {
                    Element child = (Element)node;
                    System.out.println(String.valueOf(id) + " -> " + child.getAttribute("id"));
                    if (child.getAttribute("id").equals(id)) {
                        return child;
                    }
                }
                ++i;
            }
        }
        return null;
    }
}

