/*
 * Decompiled with CFR 0.152.
 */
package br.ufma.deinf.laws.ncleditor.editor.contentassist;

import br.ufma.deinf.laws.ncleclipse.scanners.XMLPartitionScanner;
import br.ufma.deinf.laws.ncleclipse.scanners.XMLTagScanner;
import br.ufma.deinf.laws.ncleclipse.util.ColorManager;
import br.ufma.deinf.laws.ncleclipse.util.XMLPartitioner;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;

public class NCLSourceDocument
extends Document {
    private XMLTagScanner scanner;
    private int tamAttr = 0;
    String currentAttribute;
    private int startAttributeValueOffset = -1;

    public NCLSourceDocument() {
    }

    public NCLSourceDocument(IDocument doc) {
        super(doc.get());
    }

    public int getFatherPartitionOffset(int documentOffset) {
        try {
            String text;
            ITypedRegion region = this.getPartition(documentOffset);
            int partitionOffset = region.getOffset();
            while (region.getType().equals("__xml_start_tag")) {
                text = this.get(region.getOffset(), region.getLength());
                region = this.getPartition(--documentOffset);
            }
            Stack<Integer> pilha = new Stack<Integer>();
            while (true) {
                text = this.get(region.getOffset(), region.getLength());
                if (region.getType().equals("__xml_end_tag")) {
                    pilha.push(new Integer(1));
                } else if (region.getType().equals("__xml_start_tag") && !text.endsWith("/>")) {
                    if (pilha.size() == 0) break;
                    pilha.pop();
                }
                region = this.getPartition(--partitionOffset);
                partitionOffset = region.getOffset();
            }
            return partitionOffset;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int getFatherPartitionOffsetFromEndTag(int documentOffset) {
        try {
            ITypedRegion region = this.getPartition(documentOffset);
            int partitionOffset = region.getOffset();
            Stack<Integer> pilha = new Stack<Integer>();
            String text = this.get(region.getOffset(), region.getLength());
            region = this.getPartition(region.getOffset() - 1);
            System.out.println(text);
            while (true) {
                text = this.get(region.getOffset(), region.getLength());
                System.out.println(text);
                if (region.getType().equals("__xml_end_tag")) {
                    pilha.push(new Integer(1));
                } else if (region.getType().equals("__xml_start_tag") && !text.endsWith("/>")) {
                    System.out.println(pilha.size());
                    if (pilha.size() == 0) break;
                    pilha.pop();
                }
                region = this.getPartition(--partitionOffset);
                partitionOffset = region.getOffset();
            }
            return partitionOffset;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public String getFatherTagName(int documentOffset) {
        return this.getCurrentTagname(this.getFatherPartitionOffset(documentOffset));
    }

    public ITypedRegion getPreviousPartition(ITypedRegion r) {
        if (r == null) {
            return null;
        }
        if (r.getOffset() < 1) {
            return null;
        }
        ITypedRegion pr = null;
        try {
            pr = this.getPartition(r.getOffset() - 1);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return pr;
    }

    public ITypedRegion getPreviousTagPartition(int offset) throws BadLocationException {
        ITypedRegion partition = this.getPartition(offset);
        if (partition == null || partition.getType().equals("__xml_start_tag")) {
            return partition;
        }
        return this.getPreviousTagPartition(partition);
    }

    public ITypedRegion getPreviousTagPartition(ITypedRegion r) {
        ITypedRegion partition = this.getPreviousPartition(r);
        while (partition != null && !partition.getType().equals("__xml_start_tag")) {
            partition = this.getPreviousPartition(partition);
        }
        return partition;
    }

    public String getCurrentTagname(int documentOffset) {
        try {
            ITypedRegion region = this.getPartition(documentOffset);
            int partitionOffset = region.getOffset();
            int readLength = region.getLength();
            ColorManager colorManager = new ColorManager();
            this.scanner = new XMLTagScanner(colorManager);
            String text = this.get(partitionOffset, readLength);
            int p = 0;
            String tagname = "";
            char ch = text.charAt(0);
            while (p + 1 < text.length() && Character.isJavaIdentifierPart(text.charAt(p + 1))) {
                ch = text.charAt(++p);
                tagname = String.valueOf(tagname) + ch;
            }
            return tagname;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return "";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getAttributeValueFromCurrentTagName(int offset, String attribute) {
        try {
            ITypedRegion region = this.getPartition(offset);
            int partitionOffset = region.getOffset();
            int readLength = region.getLength();
            String text = this.get(partitionOffset, readLength);
            int p = text.indexOf(attribute);
            if (p == -1) {
                return null;
            }
            int pInicial = p;
            p += attribute.length();
            String value = "";
            boolean firstQuote = false;
            while (true) {
                if (++p > text.length()) {
                    return "";
                }
                if (text.charAt(p) == '\'' || text.charAt(p) == '\"') {
                    if (firstQuote) {
                        this.tamAttr = p - pInicial + 1;
                        return value;
                    }
                    firstQuote = true;
                    continue;
                }
                if (!firstQuote) continue;
                value = String.valueOf(value) + text.charAt(p);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return "";
        }
    }

    private int getAttributeSize(int offset, String attr) {
        this.getAttributeValueFromCurrentTagName(offset, attr);
        return this.tamAttr;
    }

    public String getCurrentAttribute(int offset) {
        if (this.isAttributeValue(offset)) {
            return this.currentAttribute;
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isAttributeValue(int offset) {
        this.startAttributeValueOffset = -1;
        try {
            ITypedRegion region = this.getPartition(offset--);
            if (region.getType() == "__xml_start_tag") {
                int partitionOffset = region.getOffset();
                this.currentAttribute = "";
                boolean firstQuote = true;
                boolean findingAttributeName = false;
                int beginAttributeName = -1;
                int endAttributeName = -1;
                while (offset >= partitionOffset) {
                    char ch = this.getChar(offset--);
                    if (findingAttributeName) {
                        if (Character.isJavaIdentifierPart(ch)) {
                            if (endAttributeName != -1) continue;
                            endAttributeName = offset;
                            continue;
                        }
                        if (Character.isWhitespace(ch) && endAttributeName != -1) {
                            this.currentAttribute = this.get(offset + 2, endAttributeName - offset);
                            return true;
                        }
                        if (Character.isWhitespace(ch)) continue;
                        return false;
                    }
                    if (ch == '\'' || ch == '\"') {
                        if (!firstQuote) {
                            return false;
                        }
                        this.startAttributeValueOffset = offset + 1;
                        firstQuote = false;
                        continue;
                    }
                    if (ch != '=') continue;
                    findingAttributeName = true;
                }
            }
            return false;
        }
        catch (BadLocationException e) {
            return false;
        }
    }

    public int getStartAttributeValueOffset(int offset) {
        if (this.isAttributeValue(offset)) {
            return this.startAttributeValueOffset;
        }
        return -1;
    }

    boolean isAttribute(int documentOffset) {
        try {
            ITypedRegion region = this.getPartition(documentOffset);
            if (region.getType() == "__xml_start_tag") {
                return !this.isTagname(documentOffset) && !this.isAttributeValue(documentOffset);
            }
            return false;
        }
        catch (BadLocationException e) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isTagname(int documentOffset) {
        boolean isTagname = false;
        try {
            char ch;
            ITypedRegion region = this.getPartition(documentOffset);
            String text = this.get(region.getOffset(), documentOffset - region.getOffset());
            int p = text.length() - 1;
            do {
                if ((ch = text.charAt(p--)) != '<') continue;
                return true;
            } while (Character.isLetter(ch));
            System.out.println("ch = " + ch);
            return false;
        }
        catch (BadLocationException e) {
            return false;
        }
    }

    public boolean isEndTagName(int documentOffset) {
        try {
            ITypedRegion region = this.getPartition(documentOffset);
            return region.getType() == "__xml_end_tag";
        }
        catch (BadLocationException e) {
            return false;
        }
    }

    public ITypedRegion getNextTagPartition(int offset) throws BadLocationException {
        ITypedRegion partition = this.getPartition(offset);
        if (partition == null || partition.getType().equals("__xml_start_tag")) {
            return partition;
        }
        return this.getNextTagPartition(partition);
    }

    public ITypedRegion getNextTagPartition(ITypedRegion r) {
        ITypedRegion partition = this.getNextPartition(r);
        while (partition != null && !partition.getType().equals("__xml_start_tag")) {
            partition = this.getNextPartition(partition);
        }
        return partition;
    }

    public ITypedRegion getNextPartition(ITypedRegion r) {
        if (r == null) {
            return null;
        }
        if (r.getOffset() > this.getLength()) {
            return null;
        }
        ITypedRegion pr = null;
        try {
            pr = this.getPartition(r.getLength() + r.getOffset() + 1);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return pr;
    }

    public boolean setAttribute(String id, String attr, String value) {
        return this.setAttribute(id, attr, value, 1);
    }

    public boolean setAttribute(String id, String attr, String value, int offset) {
        ITypedRegion region;
        block10: {
            try {
                region = this.getNextTagPartition(offset);
                if (region == null) {
                    throw new BadLocationException();
                }
                String startTag = this.get(region.getOffset(), region.getLength());
                String currentId = this.getAttributeValueFromCurrentTagName(region.getOffset(), "id");
                if (currentId == null || !currentId.equals(id)) break block10;
                String attrAtual = this.getAttributeValueFromCurrentTagName(region.getOffset(), attr);
                int begin = 0;
                String newValue = String.valueOf(attr) + "=\"" + value + "\"";
                if (attrAtual == null) {
                    begin = region.getOffset() + region.getLength() - 2;
                    if (startTag.endsWith("/>")) {
                        --begin;
                    }
                    if (!this.get(begin - 1, 1).equals(" ")) {
                        newValue = " " + newValue;
                    }
                    this.replace(begin, 0, newValue);
                } else {
                    String text = this.get(region.getOffset(), region.getLength());
                    int attrOffset = text.indexOf(attr);
                    int attrSizeAtual = this.getAttributeSize(offset, attr);
                    begin = region.getOffset() + attrOffset;
                    newValue = String.valueOf(attr) + "=\"" + value + "\"";
                    if (!this.get(begin - 1, 1).equals(" ")) {
                        newValue = " " + newValue;
                    }
                    if (!this.get(begin + attrSizeAtual, 1).equals(" ")) {
                        newValue = String.valueOf(newValue) + " ";
                    }
                    this.replace(begin, attrSizeAtual, newValue);
                }
                return true;
            }
            catch (BadLocationException e) {
                return false;
            }
        }
        this.setAttribute(id, attr, value, region.getOffset() + region.getLength() + 1);
        return true;
    }

    public List<String> getAttributesTyped(int offset) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            ITypedRegion region = this.getPartition(offset);
            if (region.getType() == "__xml_start_tag") {
                String currentPartition = this.get(region.getOffset(), region.getLength());
                Pattern p = Pattern.compile("\\s[a-zA-Z]+");
                Matcher m = p.matcher(currentPartition);
                while (m.find()) {
                    list.add(currentPartition.substring(m.start() + 1, m.end()));
                }
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return list;
    }

    public void removeElement(String id) {
        this.removeElement(id, 0);
    }

    public boolean removeElement(String id, int offset) {
        try {
            int elementOffset = this.getElementOffset(id, offset);
            ITypedRegion region = this.getPartition(offset);
            this.replace(region.getOffset(), region.getLength(), "");
            return true;
        }
        catch (BadLocationException e) {
            return true;
        }
    }

    public int getElementOffset(String id, int offset) throws BadLocationException {
        ITypedRegion region = this.getNextTagPartition(offset);
        if (region == null) {
            throw new BadLocationException();
        }
        String startTag = this.get(region.getOffset(), region.getLength());
        String currentId = this.getAttributeValueFromCurrentTagName(region.getOffset(), "id");
        if (currentId != null && currentId.equals(id)) {
            return offset;
        }
        return this.getElementOffset(id, region.getOffset() + region.getLength() + 1);
    }

    public static NCLSourceDocument createNCLSourceDocumentFromIDocument(IDocument doc) {
        if (doc instanceof NCLSourceDocument) {
            return (NCLSourceDocument)doc;
        }
        NCLSourceDocument document = new NCLSourceDocument();
        document.set(doc.get());
        XMLPartitioner partitioner = new XMLPartitioner((IPartitionTokenScanner)new XMLPartitionScanner(), new String[]{"__xml_start_tag", "__xml_pi", "__xml_doctype", "__xml_end_tag", "__xml_text", "__xml_cdata", "__xml_comment"});
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        return document;
    }
}

