/*
 * Decompiled with CFR 0.152.
 */
package br.ufma.deinf.gia.labmint.main;

import br.ufma.deinf.gia.labmint.composer.NCLValidator;
import br.ufma.deinf.gia.labmint.document.NclValidatorDocument;
import br.ufma.deinf.gia.labmint.main.NclParseErrorHandler;
import br.ufma.deinf.gia.labmint.message.Message;
import br.ufma.deinf.gia.labmint.message.MessageList;
import br.ufma.deinf.gia.labmint.xml.XMLParserExtend;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class NclValidatorMain {
    public static void main(String[] args) {
        Vector<String> description;
        File docFile = new File(args[0]);
        Document doc = null;
        MessageList.clear();
        MessageList.setLanguage((int)0);
        try {
            XMLParserExtend parser = new XMLParserExtend();
            NclParseErrorHandler p = new NclParseErrorHandler();
            p.setFile(docFile.getAbsolutePath());
            parser.setErrorHandler((ErrorHandler)p);
            parser.parse(docFile.getPath());
            doc = parser.getDocument();
            Vector<NclValidatorDocument> documents = new Vector<NclValidatorDocument>();
            NclValidatorDocument nclValidatorDocument = new NclValidatorDocument(doc);
            documents.add(nclValidatorDocument);
            NCLValidator.validate(documents);
        }
        catch (IOException e) {
            description = new Vector<String>();
            description.add(e.getMessage());
            MessageList.addError((String)docFile.getAbsolutePath(), (int)1001, null, description);
        }
        catch (SAXException e) {
            description = new Vector();
            description.add(e.getMessage());
            MessageList.addError((String)docFile.getAbsolutePath(), (int)1001, null, description);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        Vector warnings = NCLValidator.getWarnings();
        Vector erros = NCLValidator.getErrors();
        System.out.println("### Warnings ###");
        int i = 0;
        while (i < warnings.size()) {
            if (((Message)warnings.get(i)).getElement() != null) {
                System.out.print("Element:'" + ((Message)warnings.get(i)).getElement().getTagName() + "' id:'" + ((Message)warnings.get(i)).getId() + "'");
            }
            System.out.println(" -> " + ((Message)warnings.get(i)).getDescription());
            ++i;
        }
        System.out.println("\n\n");
        System.out.println("### Erros ###");
        i = 0;
        while (i < erros.size()) {
            if (((Message)erros.get(i)).getElement() != null) {
                System.out.println("Element:'" + ((Message)erros.get(i)).getElement().getTagName() + "' id:'" + ((Message)erros.get(i)).getId() + "'");
                System.out.println(((Message)erros.get(i)).getElement().getUserData("baseSystemId"));
                System.out.println("line : " + ((Message)erros.get(i)).getElement().getUserData("startLine") + " Column: " + ((Message)erros.get(i)).getElement().getUserData("startColumn"));
            }
            System.out.println(" -> " + ((Message)erros.get(i)).getDescription());
            ++i;
        }
    }
}

