/*
 * Decompiled with CFR 0.152.
 */
package br.ufma.deinf.gia.labmint.semantics;

import br.ufma.deinf.gia.labmint.document.NclValidatorDocument;
import br.ufma.deinf.gia.labmint.message.MessageList;
import br.ufma.deinf.gia.labmint.semantics.ElementValidation;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Link
extends ElementValidation {
    HashMap conditions = null;
    HashMap actions = null;
    private String idLink = null;

    public Link(NclValidatorDocument doc) {
        super(doc);
    }

    public boolean validate(Element eLink) {
        boolean resultado = true;
        if (!this.hasValidLinkXConnectorAttribute(eLink)) {
            resultado = false;
        } else if (!this.hasValidXConnectorStructure(eLink)) {
            resultado = false;
        }
        if (!this.hasValidLinkIDAttribute(eLink)) {
            resultado = false;
        }
        return resultado;
    }

    private boolean hasValidXConnectorStructure(Element eLink) {
        Vector<String> args;
        if (!eLink.hasAttribute("xconnector")) {
            return false;
        }
        String idXConnector = eLink.getAttribute("xconnector");
        Element eCausalConnector = this.doc.getElement(idXConnector);
        this.conditions = new HashMap();
        this.actions = new HashMap();
        this.parseCausalConnector(eCausalConnector);
        HashMap<String, Integer> qtdeRoles = new HashMap<String, Integer>();
        NodeList list = eLink.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Element element;
            Node node = list.item(i);
            if (node.getNodeType() == 1 && (element = (Element)node).getTagName().equals("bind")) {
                if (!element.hasAttribute("role")) {
                    return false;
                }
                String strRole = element.getAttribute("role");
                if (qtdeRoles.containsKey(strRole)) {
                    Integer v = (Integer)qtdeRoles.get(strRole);
                    qtdeRoles.put(strRole, new Integer(v + 1));
                } else {
                    qtdeRoles.put(strRole, 1);
                }
            }
            ++i;
        }
        Iterator qtdeRolesIt = qtdeRoles.keySet().iterator();
        boolean ok = true;
        while (qtdeRolesIt.hasNext()) {
            String strRole = (String)qtdeRolesIt.next();
            Integer qtde = (Integer)qtdeRoles.get(strRole);
            Element eSimpleCondition = null;
            if (this.conditions.containsKey(strRole)) {
                eSimpleCondition = (Element)this.conditions.get(strRole);
            } else {
                if (!this.actions.containsKey(strRole)) continue;
                eSimpleCondition = (Element)this.actions.get(strRole);
            }
            if (eSimpleCondition.hasAttribute("min") && !eSimpleCondition.getAttribute("min").equals("unbounded")) {
                Integer min = new Integer(eSimpleCondition.getAttribute("min"));
                if (qtde < min) {
                    args = new Vector();
                    args.add(qtde.toString());
                    args.add(strRole);
                    args.add(min.toString());
                    MessageList.addError((String)this.doc.getId(), (int)3902, (Element)eLink, args);
                    ok = false;
                }
            }
            if (!eSimpleCondition.hasAttribute("max") || eSimpleCondition.getAttribute("max").equals("unbounded")) continue;
            Integer max = new Integer(eSimpleCondition.getAttribute("max"));
            if (qtde <= max) continue;
            args = new Vector();
            args.add(qtde.toString());
            args.add(strRole);
            args.add(max.toString());
            MessageList.addError((String)this.doc.getId(), (int)3903, (Element)eLink, args);
            ok = false;
        }
        Iterator itCondition = this.conditions.keySet().iterator();
        while (itCondition.hasNext()) {
            Element el = (Element)this.conditions.get(itCondition.next());
            if (!el.hasAttribute("min")) continue;
            Integer min = new Integer(el.getAttribute("min"));
            String strRole = el.getAttribute("role");
            if (min <= 0 || qtdeRoles.containsKey(strRole)) continue;
            args = new Vector<String>();
            args.add(strRole);
            args.add(min.toString());
            MessageList.addError((String)this.doc.getId(), (int)3904, (Element)eLink, args);
            ok = false;
        }
        return ok;
    }

    private void parseCausalConnector(Element eCausalConnector) {
        NodeList list = eCausalConnector.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                if (element.getTagName().equals("simpleCondition") && element.hasAttribute("role")) {
                    this.conditions.put(element.getAttribute("role"), element);
                } else if (element.getTagName().equals("simpleAction") && element.hasAttribute("role")) {
                    this.actions.put(element.getAttribute("role"), element);
                } else if (element.getTagName().equals("attributeAssessment") && element.hasAttribute("role")) {
                    this.conditions.put(element.getAttribute("role"), element);
                }
                this.parseCausalConnector(element);
            }
            ++i;
        }
    }

    private boolean hasValidLinkXConnectorAttribute(Element eLink) {
        if (!eLink.hasAttribute("xconnector")) {
            return false;
        }
        String idXConnector = eLink.getAttribute("xconnector");
        Element element = this.doc.getElement(idXConnector);
        if (element == null) {
            Vector<String> args = new Vector<String>();
            args.add(idXConnector);
            MessageList.addError((String)this.doc.getId(), (int)3905, (Element)eLink, args);
            return false;
        }
        if (element.getTagName().compareTo("causalConnector") != 0) {
            Vector<String> args = new Vector<String>();
            args.add(idXConnector);
            MessageList.addError((String)this.doc.getId(), (int)3905, (Element)eLink, args);
            return false;
        }
        return true;
    }

    private boolean hasValidLinkIDAttribute(Element eLink) {
        return true;
    }
}

