/*
 * Decompiled with CFR 0.152.
 */
package br.ufma.deinf.laws.ncleclipse;

import br.ufma.deinf.gia.labmint.composer.NCLValidator;
import br.ufma.deinf.gia.labmint.document.NclValidatorDocument;
import br.ufma.deinf.gia.labmint.main.NclParseErrorHandler;
import br.ufma.deinf.gia.labmint.message.MessageHandler;
import br.ufma.deinf.gia.labmint.message.MessageList;
import br.ufma.deinf.gia.labmint.xml.XMLParserExtend;
import br.ufma.deinf.laws.ncl.help.NCLHelper;
import br.ufma.deinf.laws.ncleclipse.NCLConfiguration;
import br.ufma.deinf.laws.ncleclipse.NCLEditorMessages;
import br.ufma.deinf.laws.ncleclipse.NCLEditorPlugin;
import br.ufma.deinf.laws.ncleclipse.NCLValidatorErrorMessages;
import br.ufma.deinf.laws.ncleclipse.marker.MarkingErrorHandler;
import br.ufma.deinf.laws.ncleclipse.outline.EditorContentOutlinePage;
import br.ufma.deinf.laws.ncleclipse.util.ColorManager;
import br.ufma.deinf.laws.ncleclipse.util.NCLDocumentProvider;
import br.ufma.deinf.laws.ncleclipse.xml.XMLParser;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.helpers.LocatorImpl;

public class NCLEditor
extends TextEditor {
    public static String CONTENT_ASSIST_ACTION = "br.ufma.deinf.laws.ncleclipse.actions.CONTENT_ASSIST";
    public static String FORMAT_ACTION = "br.ufma.deinf.laws.ncleclipse.actions.format";
    private IEditorInput input;
    private EditorContentOutlinePage outlinePage;
    private ColorManager colorManager = new ColorManager();
    private ProjectionSupport projectionSupport;
    private Annotation[] oldAnnotations;
    private ProjectionAnnotationModel annotationModel;

    public NCLEditor() {
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new NCLConfiguration(this.colorManager, this));
        this.setDocumentProvider((IDocumentProvider)new NCLDocumentProvider());
        this.loadHelp();
    }

    public void dispose() {
        this.colorManager.dispose();
        super.dispose();
    }

    protected void createActions() {
        super.createActions();
        ContentAssistAction action = new ContentAssistAction(NCLEditorMessages.getResourceBundle(), "ContentAssistProposal.", (ITextEditor)this);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction(CONTENT_ASSIST_ACTION, (IAction)action);
        this.markAsStateDependentAction(CONTENT_ASSIST_ACTION, true);
        action = new TextOperationAction(NCLEditorMessages.getResourceBundle(), "ContentFormat.", (ITextEditor)this, 15);
        action.setActionDefinitionId(FORMAT_ACTION);
        action.setAccelerator(393318);
        this.setAction("ContentFormat", (IAction)action);
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        this.addAction(menu, "ContentAssistProposal");
    }

    protected void doSetInput(IEditorInput newInput) throws CoreException {
        super.doSetInput(newInput);
        this.input = newInput;
        if (this.outlinePage != null) {
            this.outlinePage.setInput((Object)this.input);
        }
        this.validateAndMark();
    }

    protected void editorSaved() {
        super.editorSaved();
        if (this.outlinePage != null) {
            this.outlinePage.update();
        }
        this.validateAndMark();
    }

    protected void validateAndMark() {
        try {
            IDocument document = this.getInputDocument();
            String text = document.get();
            MarkingErrorHandler markingErrorHandler = new MarkingErrorHandler(this.getInputFile(), document);
            markingErrorHandler.setDocumentLocator((Locator)new LocatorImpl());
            markingErrorHandler.removeExistingMarkers();
            XMLParser parser = new XMLParser();
            parser.setErrorHandler((ErrorHandler)markingErrorHandler);
            parser.doParse(text);
            IFile file = this.getInputFile();
            File docFile = new File(file.getLocationURI());
            Document doc = null;
            MessageList.clear();
            NCLValidatorErrorMessages prop = new NCLValidatorErrorMessages();
            MessageHandler.setProperties((Properties)prop);
            MessageList.setLanguage((int)0);
            try {
                XMLParserExtend parserExtend = new XMLParserExtend();
                NclParseErrorHandler p = new NclParseErrorHandler();
                p.setFile(docFile.getAbsolutePath());
                parserExtend.setErrorHandler((ErrorHandler)p);
                parserExtend.parse(file.getLocationURI().getPath());
                doc = parserExtend.getDocument();
                Vector<NclValidatorDocument> documents = new Vector<NclValidatorDocument>();
                NclValidatorDocument nclValidatorDocument = new NclValidatorDocument(doc);
                documents.add(nclValidatorDocument);
                NCLValidator.validate(documents);
            }
            catch (Exception e) {
                e.printStackTrace();
                Vector<String> args = new Vector<String>();
                args.add(e.getMessage());
                MessageList.addError((String)docFile.getAbsolutePath(), (int)1002, null, args);
            }
            markingErrorHandler.MarkNCLValidatorErrorsAndWarnings();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public IDocument getInputDocument() {
        IDocument document = this.getDocumentProvider().getDocument((Object)this.input);
        return document;
    }

    public IFile getInputFile() {
        IFileEditorInput ife = (IFileEditorInput)this.input;
        IFile file = ife.getFile();
        return file;
    }

    public IEditorInput getInput() {
        return this.input;
    }

    public Object getAdapter(Class required) {
        if (IContentOutlinePage.class.equals((Object)required)) {
            if (this.outlinePage == null) {
                this.outlinePage = new EditorContentOutlinePage((ITextEditor)this);
                if (this.getEditorInput() != null) {
                    this.outlinePage.setInput((Object)this.getEditorInput());
                }
            }
            return this.outlinePage;
        }
        return super.getAdapter(required);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        this.projectionSupport = new ProjectionSupport(viewer, this.getAnnotationAccess(), this.getSharedColors());
        this.projectionSupport.install();
        viewer.doOperation(19);
        this.annotationModel = viewer.getProjectionAnnotationModel();
    }

    public void updateFoldingStructure(ArrayList positions) {
        int i;
        Annotation[] annotations = new Annotation[positions.size()];
        HashMap newAnnotations = new HashMap();
        HashMap<Position, Boolean> oldPosisitions = new HashMap<Position, Boolean>();
        if (this.oldAnnotations != null) {
            i = 0;
            while (i < this.oldAnnotations.length) {
                ProjectionAnnotation tmp = (ProjectionAnnotation)this.oldAnnotations[i];
                if (tmp.isCollapsed()) {
                    oldPosisitions.put(this.annotationModel.getPosition((Annotation)tmp), true);
                }
                ++i;
            }
        }
        i = 0;
        while (i < positions.size()) {
            ProjectionAnnotation annotation = new ProjectionAnnotation();
            if (oldPosisitions.containsKey(positions.get(i)) && ((Boolean)oldPosisitions.get(positions.get(i))).booleanValue()) {
                annotation.markCollapsed();
            }
            newAnnotations.put(annotation, positions.get(i));
            annotations[i] = annotation;
            ++i;
        }
        this.annotationModel.modifyAnnotations(this.oldAnnotations, newAnnotations, null);
        this.oldAnnotations = annotations;
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        ProjectionViewer viewer = new ProjectionViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        return viewer;
    }

    protected void loadHelp() {
        try {
            NCLHelper nclHelper = NCLHelper.getNCLHelper();
            nclHelper.setHelpFileName(String.valueOf(NCLEditorPlugin.getResourcesLocation().getPath()) + "resources/help.txt");
            NCLHelper.buildHelp();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

