/*
 * Decompiled with CFR 0.152.
 */
package br.ufma.deinf.gia.labmint.test;

import br.ufma.deinf.gia.labmint.composer.NCLValidator;
import br.ufma.deinf.gia.labmint.document.NclValidatorDocument;
import br.ufma.deinf.gia.labmint.main.NclParseErrorHandler;
import br.ufma.deinf.gia.labmint.message.Message;
import br.ufma.deinf.gia.labmint.message.MessageList;
import br.ufma.deinf.gia.labmint.xml.XMLParserExtend;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestSuite {
    String out = "tests/out";
    static String input = "tests/";
    static Vector<File> files = new Vector();

    public static void buildFileTree(File f) {
        if (!f.exists()) {
            return;
        }
        if (f.isDirectory()) {
            File[] childs = f.listFiles();
            int i = 0;
            while (i < childs.length) {
                TestSuite.buildFileTree((File)childs[i]);
                ++i;
            }
        } else {
            files.add(f);
        }
    }

    public static void runTests() {
        System.out.println("### Running NCL Validator test suite..");
        System.out.println("### Total files = " + files.size());
        int t = 0;
        while (t < files.size()) {
            Vector<String> description;
            File docFile = (File)files.get(t);
            System.out.println("\n\n");
            System.out.println("######################################");
            System.out.println("# Test " + (t + 1) + " from " + files.size());
            System.out.println("# File = " + docFile.getAbsolutePath());
            System.out.println("######################################");
            Document doc = null;
            MessageList.clear();
            MessageList.setLanguage((int)1);
            try {
                XMLParserExtend parser = new XMLParserExtend();
                NclParseErrorHandler p = new NclParseErrorHandler();
                p.setFile(docFile.getAbsolutePath());
                parser.setErrorHandler((ErrorHandler)p);
                parser.parse(docFile.getPath());
                doc = parser.getDocument();
                Vector<NclValidatorDocument> documents = new Vector<NclValidatorDocument>();
                NclValidatorDocument nclValidatorDocument = new NclValidatorDocument(doc);
                documents.add(nclValidatorDocument);
                NCLValidator.validate(documents);
            }
            catch (IOException e) {
                description = new Vector<String>();
                description.add(e.getMessage());
                MessageList.addError((String)docFile.getAbsolutePath(), (int)1001, null, description);
            }
            catch (SAXException e) {
                description = new Vector();
                description.add(e.getMessage());
                MessageList.addError((String)docFile.getAbsolutePath(), (int)1001, null, description);
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            Vector warnings = NCLValidator.getWarnings();
            Vector erros = NCLValidator.getErrors();
            System.out.println("### Warnings ###");
            int i = 0;
            while (i < warnings.size()) {
                if (((Message)warnings.get(i)).getElement() != null) {
                    System.out.print("Element:'" + ((Message)warnings.get(i)).getElement().getTagName() + "' id:'" + ((Message)warnings.get(i)).getId() + "'");
                }
                System.out.println(" -> " + ((Message)warnings.get(i)).getDescription());
                ++i;
            }
            System.out.println("\n\n");
            System.out.println("### Erros ###");
            i = 0;
            while (i < erros.size()) {
                if (((Message)erros.get(i)).getElement() != null) {
                    System.out.println("Element:'" + ((Message)erros.get(i)).getElement().getTagName() + "' id:'" + ((Message)erros.get(i)).getId() + "'");
                    System.out.println(((Message)erros.get(i)).getElement().getUserData("baseSystemId"));
                    System.out.println("line : " + ((Message)erros.get(i)).getElement().getUserData("startLine") + " Column: " + ((Message)erros.get(i)).getElement().getUserData("startColumn"));
                }
                System.out.println(" -> " + ((Message)erros.get(i)).getDescription());
                ++i;
            }
            ++t;
        }
    }

    public static void main(String[] args) {
        File f = new File(input);
        TestSuite.buildFileTree((File)f);
        TestSuite.runTests();
    }
}

