/*
 * Decompiled with CFR 0.152.
 */
package br.ufma.deinf.laws.ncleditor.editor.contentassist;

import br.ufma.deinf.laws.util.UrlUtils;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Vector;

public class URIProposer {
    String rootPath;
    URI uriRoot;
    boolean isRelative = false;

    public URIProposer(String rootPath) throws URISyntaxException {
        this.rootPath = UrlUtils.encodeURL((String)rootPath);
        this.uriRoot = new URI(this.rootPath);
        System.out.println(this.rootPath);
    }

    private File computeParentFile(String qualifier) throws URISyntaxException {
        File file;
        boolean bl = this.isRelative = !qualifier.startsWith("file://");
        if (this.isRelative) {
            if (qualifier.contains("/")) {
                System.out.println(String.valueOf(this.uriRoot.getPath()) + "/" + qualifier.substring(0, qualifier.lastIndexOf("/")));
                file = new File(String.valueOf(this.uriRoot.getPath()) + "/" + qualifier.substring(0, qualifier.lastIndexOf("/")));
            } else {
                file = new File(this.uriRoot.getPath());
            }
        } else {
            String parentPath = qualifier;
            if (qualifier.contains("/")) {
                parentPath = String.valueOf(parentPath.substring(0, parentPath.lastIndexOf("/"))) + "/";
            }
            System.out.print(parentPath);
            this.uriRoot = new URI(UrlUtils.encodeURL((String)parentPath));
            file = new File(this.uriRoot);
        }
        return file;
    }

    private Vector<String> getResource(String qualifier, boolean isFile) {
        Vector<String> resources = new Vector<String>();
        try {
            File f = this.computeParentFile(qualifier);
            System.out.println("Absolute Path -> " + f.getAbsolutePath());
            String[] children = f.list();
            if (children == null) {
                return resources;
            }
            System.out.println(children.length);
            int i = 0;
            while (i < children.length) {
                File suggest = new File(f.getAbsoluteFile() + "/" + children[i]);
                if (suggest.isDirectory() && !isFile || suggest.isFile() && isFile) {
                    String strSuggest;
                    if (!this.isRelative) {
                        strSuggest = "file://" + this.uriRoot.getPath() + children[i];
                        if (!isFile) {
                            strSuggest = String.valueOf(strSuggest) + "/";
                        }
                        resources.add(strSuggest);
                    } else {
                        strSuggest = qualifier.contains("/") ? String.valueOf(qualifier.substring(0, qualifier.lastIndexOf("/"))) + "/" + children[i] : children[i];
                        if (!isFile) {
                            strSuggest = String.valueOf(strSuggest) + "/";
                        }
                        resources.add(strSuggest);
                    }
                    System.out.println(strSuggest);
                }
                ++i;
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return resources;
    }

    public Vector<String> getDirectories(String qualifier) {
        System.out.println("Computing Directories");
        return this.getResource(qualifier, false);
    }

    public Vector<String> getFiles(String qualifier) {
        System.out.println("Computing Files");
        return this.getResource(qualifier, true);
    }

    public static void main(String[] args) throws URISyntaxException {
        URIProposer fs = new URIProposer("file:///C:/");
        Vector v = fs.getDirectories("file:///C:/Users/usuario/Program Files (x86)/");
        System.out.println("## DIRECTORIES ##");
        int i = 0;
        while (i < v.size()) {
            System.out.println((String)v.get(i));
            ++i;
        }
        System.out.println("## FILES ##");
        v = fs.getFiles("file:///C:/Users/usuario/");
        i = 0;
        while (i < v.size()) {
            System.out.println((String)v.get(i));
            ++i;
        }
    }
}

