/*
 * Decompiled with CFR 0.152.
 */
package br.ufma.deinf.gia.labmint.main;

import br.ufma.deinf.gia.labmint.composer.NCLValidator;
import br.ufma.deinf.gia.labmint.document.NclValidatorDocument;
import br.ufma.deinf.gia.labmint.main.NclParseErrorHandler;
import br.ufma.deinf.gia.labmint.message.Message;
import br.ufma.deinf.gia.labmint.message.MessageList;
import br.ufma.deinf.gia.labmint.message.NCLValidatorErrorMessages;
import br.ufma.deinf.gia.labmint.xml.XMLParserExtend;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public class NclValidatorMain {
    static Vector<File> files = new Vector();
    static int language;

    public static void buildFileTree(File f) {
        if (!f.exists()) {
            return;
        }
        if (f.isDirectory()) {
            File[] childs = f.listFiles();
            int i = 0;
            while (i < childs.length) {
                NclValidatorMain.buildFileTree((File)childs[i]);
                ++i;
            }
        } else {
            files.add(f);
        }
    }

    public static void printHelp() {
        System.out.println(NCLValidatorErrorMessages.getString((String)"0"));
    }

    public static void run() {
        int t = 0;
        while (t < files.size()) {
            Vector<String> description;
            File docFile = (File)files.get(t);
            System.out.println(docFile.getAbsolutePath());
            Document doc = null;
            MessageList.clear();
            try {
                XMLParserExtend parser = new XMLParserExtend();
                NclParseErrorHandler p = new NclParseErrorHandler();
                p.setFile(docFile.getAbsolutePath());
                parser.setErrorHandler((ErrorHandler)p);
                parser.parse(docFile.getPath());
                doc = parser.getDocument();
                Vector<NclValidatorDocument> documents = new Vector<NclValidatorDocument>();
                NclValidatorDocument nclValidatorDocument = new NclValidatorDocument(doc);
                documents.add(nclValidatorDocument);
                NCLValidator.validate(documents);
            }
            catch (IOException e) {
                description = new Vector<String>();
                description.add(e.getMessage());
                MessageList.addError((String)docFile.getAbsolutePath(), (int)1001, null, description);
            }
            catch (SAXException e) {
                description = new Vector();
                description.add(e.getMessage());
                MessageList.addError((String)docFile.getAbsolutePath(), (int)1001, null, description);
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            Vector warnings = NCLValidator.getWarnings();
            Vector erros = NCLValidator.getErrors();
            System.out.println(NCLValidatorErrorMessages.getString((String)"1"));
            int i = 0;
            while (i < warnings.size()) {
                if (((Message)warnings.get(i)).getElement() != null) {
                    System.out.print(String.valueOf(NCLValidatorErrorMessages.getString((String)"5")) + ((Message)warnings.get(i)).getElement().getTagName() + "' id:'" + ((Message)warnings.get(i)).getId() + "'");
                }
                System.out.println(" -> " + ((Message)warnings.get(i)).getDescription());
                ++i;
            }
            System.out.println("\n\n");
            System.out.println("### " + NCLValidatorErrorMessages.getString((String)"2") + " ###");
            i = 0;
            while (i < erros.size()) {
                if (((Message)erros.get(i)).getElement() != null) {
                    System.out.println(String.valueOf(NCLValidatorErrorMessages.getString((String)"5")) + ((Message)erros.get(i)).getElement().getTagName() + "' id:'" + ((Message)erros.get(i)).getId() + "'");
                    System.out.println(String.valueOf(NCLValidatorErrorMessages.getString((String)"3")) + ((Message)erros.get(i)).getElement().getUserData("startLine") + " " + NCLValidatorErrorMessages.getString((String)"4") + ((Message)erros.get(i)).getElement().getUserData("startColumn"));
                }
                System.out.println(" -> " + ((Message)erros.get(i)).getDescription());
                ++i;
            }
            ++t;
        }
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            NclValidatorMain.printHelp();
        } else if (args.length == 1) {
            if (args[0].equals("--help") || args[0].equals("-h")) {
                NclValidatorMain.printHelp();
                return;
            }
            Locale.setDefault(Locale.getDefault());
            File f = new File(args[0]);
            if (f.isFile() || f.isDirectory()) {
                NclValidatorMain.buildFileTree((File)f);
                NclValidatorMain.run();
            } else {
                NclValidatorMain.printHelp();
            }
        } else if (args.length == 3) {
            File f;
            if (args[0].equals("-nl")) {
                String nl = args[1];
                String language = args[1].substring(0, 2);
                String country = args[1].substring(3, 5);
                Locale.setDefault(new Locale(language, country));
            }
            if ((f = new File(args[2])).isFile() || f.isDirectory()) {
                NclValidatorMain.buildFileTree((File)f);
                NclValidatorMain.run();
            } else {
                NclValidatorMain.printHelp();
            }
        } else {
            NclValidatorMain.printHelp();
        }
    }
}

