/*
 * Decompiled with CFR 0.152.
 */
package br.ufma.deinf.laws.ncleclipse.format;

import java.io.IOException;
import java.io.StringReader;
import java.util.LinkedList;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.XMLReaderFactory;

public class XMLFormatter
extends DefaultHandler2 {
    private String xmlVersion = "1.0";
    private String encoding = "UTF-8";
    private String indent = "\t";
    private String lineEnd = "\r\n";
    private char quote = (char)34;
    private String nbsp = "\u00a0";
    private int level = 0;
    private StringBuffer output = new StringBuffer();
    private LinkedList<Boolean> ischild = new LinkedList();

    public String format(Document document, String text) throws ParserConfigurationException, SAXException, IOException {
        this.output.append("<?xml version=");
        this.output.append(this.quote);
        this.output.append(this.xmlVersion);
        this.output.append(this.quote);
        this.output.append(" encoding=");
        this.output.append(this.quote);
        this.output.append(document.getXmlEncoding());
        this.output.append(this.quote);
        this.output.append("?>");
        this.output.append(this.lineEnd);
        document = null;
        this.ischild.addFirst(false);
        XMLReader xmlReader = XMLReaderFactory.createXMLReader();
        xmlReader.setContentHandler((ContentHandler)this);
        xmlReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
        xmlReader.parse(new InputSource(new StringReader(text)));
        return this.output.toString();
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void startElement(String uri, String localName, String tag, Attributes atributos) {
        if (((Boolean)this.ischild.element()).booleanValue()) {
            this.output.append(">");
            this.output.append(this.lineEnd);
        }
        this.addIndent();
        this.output.append("<");
        this.output.append(tag);
        int i = 0;
        while (i < atributos.getLength()) {
            this.output.append(" ");
            this.output.append(atributos.getQName(i));
            this.output.append("=");
            this.output.append(this.quote);
            this.output.append(atributos.getValue(i));
            this.output.append(this.quote);
            ++i;
        }
        ++this.level;
        this.ischild.addFirst(true);
    }

    @Override
    public void endElement(String uri, String localName, String tag) {
        if (((Boolean)this.ischild.element()).booleanValue()) {
            this.output.append("/>");
            this.output.append(this.lineEnd);
            --this.level;
        } else {
            --this.level;
            this.addIndent();
            this.output.append("</");
            this.output.append(tag);
            this.output.append(">");
            this.output.append(this.lineEnd);
        }
        this.ischild.remove();
        this.ischild.addFirst(false);
    }

    private void addIndent() {
        int i = 0;
        while (i < this.level) {
            this.output.append(this.indent);
            ++i;
        }
    }

    private void swapQuote() {
        this.quote = this.quote == '\"' ? (char)39 : (char)34;
    }

    public String getIndent() {
        return this.indent;
    }

    public void setIndent(String indent) {
        this.indent = indent;
    }

    public String getLineEnd() {
        return this.lineEnd;
    }

    public void setLineEnd(String lineEnd) {
        this.lineEnd = lineEnd;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getXmlVersion() {
        return this.xmlVersion;
    }

    public void setXmlVersion(String xmlVersion) {
        this.xmlVersion = xmlVersion;
    }

    @Override
    public void comment(char[] arg0, int arg1, int arg2) throws SAXException {
        if (((Boolean)this.ischild.element()).booleanValue()) {
            this.output.append(">");
            this.ischild.remove();
            this.ischild.addFirst(false);
            this.output.append(this.lineEnd);
        }
        this.addIndent();
        this.output.append("<!--");
        int i = 0;
        while (i < arg2) {
            this.output.append(arg0[i + arg1]);
            ++i;
        }
        this.output.append("-->");
        this.output.append(this.lineEnd);
    }
}

