/*
 * Decompiled with CFR 0.152.
 */
package br.ufma.deinf.laws.ncleditor.editor.contentassist;

import br.ufma.deinf.laws.ncl.AttributeValues;
import br.ufma.deinf.laws.ncl.NCLReference;
import br.ufma.deinf.laws.ncl.NCLStructure;
import br.ufma.deinf.laws.ncl.help.NCLHelper;
import br.ufma.deinf.laws.ncleclipse.NCLEditorMessages;
import br.ufma.deinf.laws.ncleclipse.NCLEditorPlugin;
import br.ufma.deinf.laws.ncleclipse.document.NCLSourceDocument;
import br.ufma.deinf.laws.ncleclipse.ncl.NCLContentHandler;
import br.ufma.deinf.laws.ncleclipse.ncl.NCLDocument;
import br.ufma.deinf.laws.ncleclipse.ncl.NCLElement;
import br.ufma.deinf.laws.ncleclipse.ncl.NCLParser;
import br.ufma.deinf.laws.ncleclipse.scanners.XMLPartitionScanner;
import br.ufma.deinf.laws.ncleclipse.scanners.XMLTagScanner;
import br.ufma.deinf.laws.ncleclipse.util.XMLPartitioner;
import br.ufma.deinf.laws.ncleditor.editor.contentassist.NCLCompletionProposal;
import br.ufma.deinf.laws.ncleditor.editor.contentassist.URIProposer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.Workbench;
import org.xml.sax.ContentHandler;

public class NCLCompletionProposal
implements IContentAssistProcessor {
    private XMLTagScanner scanner;
    private File currentFile;
    private String text;
    private String[] protocols = new String[]{"file:///", "http://", "rtsp://", "rtp://", "sbtvd-ts://"};
    private boolean isAttributeValue;
    private boolean isAttribute;
    private boolean isEndTagName;
    private Image connectorImage = null;
    private Image regionImage = null;
    private Image fileImage = null;
    private HashMap<String, NCLSourceDocument> importedNCLDocs = new HashMap();
    private int cursor;

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
        IWorkbenchPage page = win.getActivePage();
        IEditorPart editor = page.getActiveEditor();
        ArrayList propList = new ArrayList();
        try {
            this.currentFile = editor.getEditorInput() instanceof IFileEditorInput ? new File(((IFileEditorInput)editor.getEditorInput()).getFile().getLocationURI()) : new File(((IURIEditorInput)editor.getEditorInput()).getURI());
        }
        catch (Exception e) {
            e.printStackTrace();
            ICompletionProposal[] proposal = new ICompletionProposal[]{};
            return proposal;
        }
        IDocument doc = viewer.getDocument();
        this.text = doc.get();
        NCLSourceDocument nclDoc = NCLSourceDocument.createNCLSourceDocumentFromIDocument((IDocument)doc);
        Vector aliasOffset = nclDoc.getAllTagsWithAttribute("alias");
        Iterator iterator = aliasOffset.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            String alias = nclDoc.getAttributeValueFromCurrentTagName(i, "alias");
            if (alias == null || alias.equals("") || this.importedNCLDocs.containsKey(alias)) continue;
            String documentURI = nclDoc.getAttributeValueFromCurrentTagName(i, "documentURI");
            File importedFile = null;
            if (documentURI == null || documentURI.equals("")) continue;
            importedFile = new File(documentURI);
            if (!importedFile.isFile()) {
                importedFile = new File(String.valueOf(this.currentFile.getParent()) + "/" + documentURI);
            }
            if (!importedFile.isFile()) continue;
            try {
                BufferedReader reader = new BufferedReader(new FileReader(importedFile));
                String text = "";
                while (reader.ready()) {
                    text = String.valueOf(text) + reader.readLine() + "\n";
                }
                NCLSourceDocument ncl = new NCLSourceDocument(text);
                XMLPartitioner partitioner = new XMLPartitioner((IPartitionTokenScanner)new XMLPartitionScanner(), new String[]{"__xml_start_tag", "__xml_pi", "__xml_doctype", "__xml_end_tag", "__xml_text", "__xml_cdata", "__xml_comment"});
                partitioner.connect((IDocument)ncl);
                ncl.setDocumentPartitioner((IDocumentPartitioner)partitioner);
                this.importedNCLDocs.put(alias, ncl);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.isAttributeValue = nclDoc.isAttributeValue(offset);
        this.isAttribute = nclDoc.isAttribute(offset);
        this.isEndTagName = nclDoc.isEndTagName(offset);
        Point selectedRange = viewer.getSelectedRange();
        if (selectedRange.y <= 0) {
            System.out.println("Attributo = " + this.isAttribute);
            String qualifier = this.getQualifier(doc, offset);
            if (this.isEndTagName) {
                this.computeEndTagName(doc, qualifier, offset, propList);
            } else if (this.isAttributeValue) {
                this.computeAttributesValuesProposals(doc, qualifier, offset, propList);
            } else if (!this.isAttribute) {
                this.computeTagsProposals(doc, qualifier, offset, propList);
            } else if (!nclDoc.isTagname(offset)) {
                this.computeAttributesProposals(doc, qualifier, offset, propList);
            }
        }
        ICompletionProposal[] proposals = new ICompletionProposal[propList.size()];
        propList.toArray(proposals);
        return proposals;
    }

    private void computeEndTagName(IDocument doc, String qualifier, int offset, List propList) {
        int qlen = qualifier.length();
        NCLSourceDocument nclDoc = NCLSourceDocument.createNCLSourceDocumentFromIDocument((IDocument)doc);
        int fatherOffset = nclDoc.getFatherPartitionOffsetFromEndTag(offset);
        String tagname = nclDoc.getCurrentTagname(fatherOffset);
        String prop = "</" + tagname + ">";
        this.cursor = prop.length();
        CompletionProposal proposal = new CompletionProposal(prop, offset - qlen, qlen, this.cursor, null, prop, null, null);
        propList.add(proposal);
    }

    private void computeTagsProposals(IDocument doc, String qualifier, int offset, List propList) {
        int qlen = qualifier.length();
        NCLStructure nclStructure = NCLStructure.getInstance();
        String indent = this.getIndentLine(doc, offset);
        NCLSourceDocument nclDoc = NCLSourceDocument.createNCLSourceDocumentFromIDocument((IDocument)doc);
        System.out.println("## Log: Pai da tag onde estou digitando : " + nclDoc.getFatherTagName(offset));
        Map nesting = nclStructure.getNesting();
        Vector childrenStr = new Vector();
        String fatherTagName = nclDoc.getFatherTagName(offset);
        if (fatherTagName.equals("")) {
            String tagname = "ncl";
            String tagname2 = "<" + tagname;
            if (tagname.startsWith(qualifier) || tagname2.startsWith(qualifier)) {
                String text = this.computeTagStructure(tagname, indent);
                NCLHelper.getNCLHelper();
                String helpInfo = NCLHelper.getHelpDescription((String)tagname);
                CompletionProposal proposal = new CompletionProposal(text, offset - qlen, qlen, this.cursor, null, tagname, null, helpInfo);
                propList.add(proposal);
            }
        } else if (nesting.containsKey(fatherTagName)) {
            Map children = (Map)nesting.get(fatherTagName);
            for (Map.Entry entry : children.entrySet()) {
                String tagname = (String)entry.getKey();
                String tagname2 = "<" + tagname;
                if (!tagname.startsWith(qualifier) && !tagname2.startsWith(qualifier)) continue;
                String text = this.computeTagStructure(tagname, indent);
                NCLHelper.getNCLHelper();
                String helpInfo = NCLHelper.getHelpDescription((String)tagname);
                CompletionProposal proposal = new CompletionProposal(text, offset - qlen, qlen, this.cursor, null, tagname, null, helpInfo);
                propList.add(proposal);
            }
            return;
        }
    }

    String computeTagStructure(String tagname, String indent) {
        String ret;
        NCLStructure nclStructure = NCLStructure.getInstance();
        Map atts = NCLStructure.getAttributes((String)tagname);
        Map children = NCLStructure.getChildrenCardinality((String)tagname);
        Iterator it = atts.entrySet().iterator();
        String attributes = "";
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (!((Boolean)entry.getValue()).booleanValue()) continue;
            attributes = String.valueOf(attributes) + " " + (String)entry.getKey() + "=\"\"";
        }
        if (children.size() == 0) {
            ret = "<" + tagname + attributes + "/>" + "\r\n" + indent;
            this.cursor = ret.length();
        } else {
            ret = "<" + tagname + attributes + ">" + "\r\n" + indent + "\t";
            this.cursor = ret.length();
            ret = String.valueOf(ret) + "\r\n" + indent + "</" + tagname + ">";
        }
        return ret;
    }

    private void computeAttributesValuesProposals(IDocument doc, String qualifier, int offset, List propList) {
        Collection nclReference;
        CompletionProposal proposal;
        this.loadImages();
        int qlen = qualifier.length();
        NCLSourceDocument nclDoc = NCLSourceDocument.createNCLSourceDocumentFromIDocument((IDocument)doc);
        String tagname = nclDoc.getCurrentTagname(offset);
        String attribute = nclDoc.getCurrentAttribute(offset);
        System.out.println("tag: " + tagname + " attr:" + attribute);
        NCLStructure nclStructure = NCLStructure.getInstance();
        Vector prop = AttributeValues.getValues((int)NCLStructure.getDataType((String)tagname, (String)attribute));
        if (prop.size() > 0) {
            int i = 0;
            while (i < prop.size()) {
                if (((String)prop.get(i)).startsWith(qualifier)) {
                    String text;
                    String texttoshow = text = (String)prop.get(i);
                    System.out.println(text);
                    this.cursor = text.length();
                    CompletionProposal proposal2 = new CompletionProposal(text, offset - qlen, qlen, this.cursor, null, texttoshow, null, null);
                    propList.add(proposal2);
                }
                ++i;
            }
            return;
        }
        String nclText = doc.get();
        NCLContentHandler nclContentHandler = new NCLContentHandler();
        NCLDocument nclDocument = new NCLDocument();
        nclDocument.setParentURI(this.currentFile.getParentFile().toURI());
        nclContentHandler.setNclDocument(nclDocument);
        NCLParser parser = new NCLParser();
        parser.setContentHandler((ContentHandler)nclContentHandler);
        try {
            parser.doParse(nclText);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            MessageDialog.openError((Shell)Workbench.getInstance().getActiveWorkbenchWindow().getShell(), (String)NCLEditorMessages.getInstance().getString("ContentAssist.Error.Title"), (String)NCLEditorMessages.getInstance().getString("ContentAssist.Error.XMLParserError"));
        }
        boolean hasContextId = false;
        String perspective = null;
        if (tagname.equals("port") && attribute.equals("component") || tagname.equals("bindRule") && attribute.equals("constituent") || tagname.equals("defaultComponent") && attribute.equals("component")) {
            String fatherTagName = nclDoc.getFatherTagName(offset);
            perspective = nclDoc.getAttributeValueFromCurrentTagName(nclDoc.getFatherPartitionOffset(offset), "id");
            System.out.println(perspective);
            if (perspective == null) {
                if (fatherTagName.equals("body")) {
                    perspective = nclDoc.getAttributeValueFromCurrentTagName(nclDoc.getFatherPartitionOffset(nclDoc.getFatherPartitionOffset(offset)), "id");
                    if (perspective == null) {
                        MessageDialog.openError((Shell)Workbench.getInstance().getActiveWorkbenchWindow().getShell(), (String)NCLEditorMessages.getInstance().getString("ContentAssist.Error.Title"), (String)NCLEditorMessages.getInstance().getString("ContentAssist.Error.BodyAndNCLWithoutId"));
                        return;
                    }
                } else {
                    Object[] tmp = new Object[]{fatherTagName};
                    MessageDialog.openError((Shell)Workbench.getInstance().getActiveWorkbenchWindow().getShell(), (String)NCLEditorMessages.getInstance().getString("ContentAssist.Error.Title"), (String)NCLEditorMessages.getInstance().getString("ContentAssist.Error.FatherTagNameWithoutId", tmp));
                }
            }
        }
        if (tagname.equals("bind") && attribute.equals("component") || tagname.equals("mapping") && attribute.equals("component")) {
            String grandFatherTagName = nclDoc.getFatherTagName(nclDoc.getFatherPartitionOffset(offset));
            perspective = nclDoc.getAttributeValueFromCurrentTagName(nclDoc.getFatherPartitionOffset(nclDoc.getFatherPartitionOffset(offset)), "id");
            if (perspective == null) {
                if (grandFatherTagName.equals("body")) {
                    perspective = nclDoc.getAttributeValueFromCurrentTagName(nclDoc.getFatherPartitionOffset(nclDoc.getFatherPartitionOffset(nclDoc.getFatherPartitionOffset(offset))), "id");
                    hasContextId = false;
                }
            } else {
                hasContextId = true;
            }
        }
        if ((tagname.equals("bind") && attribute.equals("role") || tagname.equals("linkParam") && attribute.equals("name")) && ((perspective = nclDoc.getAttributeValueFromCurrentTagName(nclDoc.getFatherPartitionOffset(offset), "xconnector")) == null || perspective.equals(""))) {
            return;
        }
        if (tagname.equals("link") && attribute.equals("xconnector")) {
            try {
                ITypedRegion region = nclDoc.getPartition(offset);
                String tag = nclDoc.get(region.getOffset(), region.getLength());
                int begin = offset - qlen;
                int end = region.getOffset() + region.getLength() - begin;
                Collection nclReference2 = nclStructure.getNCLReference(tagname, attribute);
                String rest = nclDoc.get(begin + nclDoc.getAttributeValueFromCurrentTagName(offset, "xconnector").length() + 1, end - nclDoc.getAttributeValueFromCurrentTagName(offset, "xconnector").length() - 1);
                Vector childrenOff = nclDoc.getChildrenOffsets(offset);
                HashMap<String, Integer> roles = new HashMap<String, Integer>();
                if (childrenOff != null) {
                    for (Integer i : childrenOff) {
                        String role = nclDoc.getAttributeValueFromCurrentTagName(i.intValue(), "role");
                        if (role == null || role.equals("")) continue;
                        if (roles.containsKey(role)) {
                            roles.put(role, (Integer)roles.get(role) + 1);
                            continue;
                        }
                        roles.put(role, 1);
                    }
                }
                for (NCLReference nclRefAtual : nclReference2) {
                    Collection elements = nclDocument.getElements().get(nclRefAtual.getRefTagname());
                    if (elements == null) continue;
                    for (NCLElement refElement : elements) {
                        this.text = refElement.getAttributeValue(nclRefAtual.getRefAttribute());
                        if (this.text == null || this.text.endsWith("#null")) continue;
                        String id = this.text;
                        int indexOfAlias = this.text.indexOf("#");
                        String alias = "";
                        NCLSourceDocument nclDoc2 = nclDoc;
                        if (indexOfAlias != -1) {
                            id = this.text.substring(indexOfAlias + 1);
                            alias = this.text.substring(0, indexOfAlias);
                            nclDoc2 = (NCLSourceDocument)this.importedNCLDocs.get(alias);
                        }
                        String helpInfo = nclDoc2.getComment(id);
                        String complete = String.valueOf(this.text) + "\"" + rest;
                        Vector<String> conditions = new Vector<String>();
                        int off = nclDoc2.getOffsetByID(id);
                        if (off != -1) {
                            Vector childrenConnector = nclDoc2.getChildrenOffsets(off);
                            for (Integer i : childrenConnector) {
                                String Tag = nclDoc2.getCurrentTagname(i.intValue());
                                if (!Tag.equals("simpleCondition") && !Tag.equals("simpleAction") && !Tag.equals("attributeAssessment")) continue;
                                String role = nclDoc2.getAttributeValueFromCurrentTagName(i.intValue(), "role");
                                String min = nclDoc2.getAttributeValueFromCurrentTagName(i.intValue(), "min");
                                int Min = 1;
                                if (min != null && !min.equals("")) {
                                    try {
                                        Min = Integer.parseInt(min);
                                    }
                                    catch (NumberFormatException e) {
                                        Min = 1;
                                    }
                                }
                                if (role == null || role.equals("")) continue;
                                if (Tag.equals("simpleCondition")) {
                                    conditions.add(role);
                                }
                                int quant = 0;
                                if (roles.containsKey(role)) {
                                    quant = (Integer)roles.get(role);
                                }
                                int j = 0;
                                while (j < Min - quant) {
                                    String aux = "<bind role=\"" + role + "\" component=\"\" />";
                                    complete = String.valueOf(complete) + "\n" + this.getIndentLine((IDocument)nclDoc2, offset) + "\t" + aux;
                                    ++j;
                                }
                            }
                        }
                        if (!this.text.startsWith(qualifier)) continue;
                        this.cursor = complete.length();
                        CompletionProposal proposal3 = new CompletionProposal(complete, begin, end, this.cursor, this.connectorImage, this.text, null, helpInfo);
                        propList.add(proposal3);
                    }
                }
                return;
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
        if (tagname.equals("bindParam") && attribute.equals("name")) {
            perspective = nclDoc.getAttributeValueFromCurrentTagName(nclDoc.getFatherPartitionOffset(nclDoc.getFatherPartitionOffset(offset)), "xconnector");
        }
        if (tagname.equals("bind") && attribute.equals("interface") || tagname.equals("port") && attribute.equals("interface") || tagname.equals("mapping") && attribute.equals("interface")) {
            perspective = nclDoc.getAttributeValueFromCurrentTagName(offset, "component");
            if (perspective == null || perspective.equals("")) {
                return;
            }
            NCLElement element = nclDocument.getElementById(perspective);
            while (element != null && element.getAttributes().get("refer") != null) {
                Collection nclReference3 = nclStructure.getNCLReference(tagname, attribute);
                String perspectivetmp = element.getAttributeValue("refer");
                element = nclDocument.getElementById(perspectivetmp);
                if (nclReference3 == null) {
                    return;
                }
                for (NCLReference nclRefAtual : nclReference3) {
                    Collection elements = nclDocument.getElementsFromPerspective(nclRefAtual.getRefTagname(), perspectivetmp);
                    if (elements == null) continue;
                    Iterator it2 = elements.iterator();
                    while (it2.hasNext()) {
                        String idAtual;
                        this.text = ((NCLElement)it2.next()).getAttributeValue(nclRefAtual.getRefAttribute());
                        if (this.text == null || attribute.equals("refer") && (idAtual = nclDoc.getAttributeValueFromCurrentTagName(offset, "id")) != null && this.text.equals(idAtual) || !this.text.startsWith(qualifier)) continue;
                        this.cursor = this.text.length();
                        CompletionProposal proposal4 = new CompletionProposal(this.text, offset - qlen, qlen, this.cursor, null, this.text, null, null);
                        propList.add(proposal4);
                    }
                }
            }
        }
        if (tagname.equals("descriptorParam")) {
            String[] name;
            if (attribute.equals("name")) {
                name = new String[]{"background", "balanceLevel", "bassLevel", "bottom", "bounds", "fit", "fontColor", "fontFamily", "fontSize", "fontVariant", "fontWeight", "height", "left", "location", "playerLife", "reusePlayer", "right", "scroll", "size", "soundLevel", "style", "top", "transparency", "trebleLevel", "visible", "width", "zIndex"};
                int i = 0;
                while (i < name.length) {
                    if (name[i].startsWith(qualifier)) {
                        propList.add(new CompletionProposal(name[i], offset - qlen, qlen, name[i].length(), null, name[i], null, null));
                    }
                    ++i;
                }
                return;
            }
            if (attribute.equals("value")) {
                name = nclDoc.getAttributeValueFromCurrentTagName(offset, "name");
                if (name.equals("background")) {
                    prop = AttributeValues.getValues((int)19);
                } else if (name.equals("visible")) {
                    prop = AttributeValues.getValues((int)27);
                } else if (name.equals("fit")) {
                    prop = AttributeValues.getValues((int)30);
                } else if (name.equals("scroll")) {
                    prop = AttributeValues.getValues((int)31);
                } else if (name.equals("fontColor")) {
                    prop = AttributeValues.getValues((int)19);
                } else if (name.equals("fontVariant")) {
                    prop = AttributeValues.getValues((int)32);
                } else if (name.equals("fontWeight")) {
                    prop = AttributeValues.getValues((int)33);
                } else if (name.equals("playerLife")) {
                    prop = AttributeValues.getValues((int)34);
                }
                for (String str : prop) {
                    if (!str.startsWith(qualifier)) continue;
                    propList.add(new CompletionProposal(str, offset - qlen, qlen, str.length(), null, str, null, null));
                }
                return;
            }
        }
        if (tagname.equals("media") && attribute.equals("src") || tagname.equals("importBase") && attribute.equals("documentURI") || tagname.equals("descriptor") && attribute.equals("focusSrc") || attribute.equals("focusSelSrc")) {
            if (NCLEditorPlugin.getDefault().getPreferenceStore().getBoolean("nclEclipsePopUPSugestionPreference")) {
                FileDialog fileDialog = new FileDialog(new Shell(), 4096);
                fileDialog.setFilterPath(this.currentFile.getParent());
                fileDialog.setText("OK");
                String path = fileDialog.open();
                if (path == null) {
                    return;
                }
                String id = nclDoc.getAttributeValueFromCurrentTagName(offset, "id");
                if (path.startsWith(this.currentFile.getParent())) {
                    path = path.substring(this.currentFile.getParent().length() + 1);
                }
                if (id != null) {
                    nclDoc.setAttribute(id, "src", path);
                } else {
                    nclDoc.setAttributeFromTagname(tagname, "documentURI", path, offset);
                }
                return;
            }
            int i = 0;
            while (i < this.protocols.length) {
                this.text = this.protocols[i];
                if (this.text.startsWith(qualifier)) {
                    this.cursor = this.text.length();
                    proposal = new CompletionProposal(this.text, offset - qlen, qlen, this.cursor, null, this.text, null, null);
                    if (!NCLEditorPlugin.getDefault().getPreferenceStore().getBoolean("nclEclipsePopUPSugestionPreference")) {
                        propList.add(proposal);
                    }
                }
                ++i;
            }
            File file = null;
            file = new File(this.currentFile.toURI());
            String pre = "";
            String currentPath = this.currentFile.getParent();
            if (qualifier.startsWith("file://") && (qualifier = qualifier.substring((pre = "file://").length())).equals("")) {
                currentPath = System.getProperty("user.home");
            }
            try {
                qualifier = qualifier.replace("%20", " ");
                Vector proposal5 = new URIProposer(currentPath).getSrcSuggest(qualifier);
                for (String str : proposal5) {
                    str = String.valueOf(pre) + str;
                    CompletionProposal completionProposal = new CompletionProposal(str, offset - qlen, qlen, str.length(), this.fileImage, str, null, null);
                    propList.add(completionProposal);
                }
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        if ((nclReference = nclStructure.getNCLReference(tagname, attribute)) == null) {
            return;
        }
        proposal = null;
        Iterator it = null;
        if (perspective != null) {
            if (hasContextId && !attribute.equals("refer")) {
                this.cursor = perspective.length();
                proposal = new CompletionProposal(perspective, offset - qlen, qlen, this.cursor, null, perspective, null, null);
                propList.add(proposal);
            }
            for (NCLReference nclRefAtual : nclReference) {
                Collection elements = nclDocument.getElementsFromPerspective(nclRefAtual.getRefTagname(), perspective);
                if (elements == null) continue;
                for (NCLElement nclElement : elements) {
                    String idAtual;
                    this.text = nclElement.getAttributeValue(nclRefAtual.getRefAttribute());
                    if (this.text == null) continue;
                    String helpInfo = nclDoc.getComment(this.text);
                    Image image = null;
                    if (nclElement.getTagName().equals("region")) {
                        image = this.regionImage;
                    } else if (nclElement.getTagName().equals("causalConnector")) {
                        image = this.connectorImage;
                    }
                    if (attribute.equals("refer") && (idAtual = nclDoc.getAttributeValueFromCurrentTagName(offset, "id")) != null && this.text.equals(idAtual) || !this.text.startsWith(qualifier)) continue;
                    this.cursor = this.text.length();
                    proposal = new CompletionProposal(this.text, offset - qlen, qlen, this.cursor, image, this.text, null, helpInfo);
                    propList.add(proposal);
                }
            }
        }
        it = nclReference.iterator();
        if (perspective == null) {
            String atualId = nclDoc.getAttributeValueFromCurrentTagName(offset, "id");
            for (NCLReference nclRefAtual : nclReference) {
                Collection elements = nclDocument.getElements().get(nclRefAtual.getRefTagname());
                if (elements == null) continue;
                for (NCLElement refElement : elements) {
                    String idAtual;
                    this.text = refElement.getAttributeValue(nclRefAtual.getRefAttribute());
                    if (this.text == null || this.text.endsWith("#null")) continue;
                    String helpInfo = nclDoc.getComment(this.text);
                    Image image = null;
                    if (refElement.getTagName().equals("region")) {
                        image = this.regionImage;
                    } else if (refElement.getTagName().equals("causalConnector")) {
                        image = this.connectorImage;
                    }
                    if (attribute.equals("refer") && (idAtual = nclDoc.getAttributeValueFromCurrentTagName(offset, "id")) != null && this.text.equals(idAtual) || !this.text.startsWith(qualifier)) continue;
                    this.cursor = this.text.length();
                    System.out.println("Attribute Value Proposal = " + this.text);
                    proposal = new CompletionProposal(this.text, offset - qlen, qlen, this.cursor, image, this.text, null, helpInfo);
                    propList.add(proposal);
                }
            }
        }
    }

    private void computeAttributesProposals(IDocument doc, String qualifier, int offset, List propList) {
        int qlen = qualifier.length();
        NCLSourceDocument nclDoc = NCLSourceDocument.createNCLSourceDocumentFromIDocument((IDocument)doc);
        System.out.println("Computing Attributes proposals...");
        String currentTagname = nclDoc.getCurrentTagname(offset);
        System.out.println("Current Tag Name = " + currentTagname);
        List attributeTyped = nclDoc.getAttributesTyped(offset);
        NCLStructure nclStructure = NCLStructure.getInstance();
        Map atts = NCLStructure.getAttributes((String)currentTagname);
        for (Map.Entry entry : atts.entrySet()) {
            String prop;
            String view = (String)entry.getKey();
            if (attributeTyped.contains(view) || view == null || !(prop = String.valueOf((String)entry.getKey()) + "=\"\"").startsWith(qualifier)) continue;
            this.cursor = prop.length();
            String helpInfo = NCLHelper.getNCLHelper().getHelpDescription(currentTagname, view);
            CompletionProposal proposal = new CompletionProposal(prop, offset - qlen, qlen, this.cursor, null, view, null, helpInfo);
            propList.add(proposal);
        }
    }

    private String getQualifier(IDocument doc, int offset) {
        StringBuffer buf = new StringBuffer();
        if (this.isAttributeValue) {
            try {
                while (true) {
                    char c;
                    if ((c = doc.getChar(--offset)) == '\"' || c == '\'') {
                        return buf.reverse().toString();
                    }
                    buf.append(c);
                }
            }
            catch (BadLocationException e) {
                return "";
            }
        }
        try {
            char c;
            while (Character.isLetter(c = doc.getChar(--offset)) || c == '<' || c == '/' || c == '#' || c == '.' || c == ':' || Character.isDigit(c)) {
                buf.append(c);
            }
            return buf.reverse().toString();
        }
        catch (BadLocationException e) {
            return "";
        }
    }

    private void loadImages() {
        Display d = Display.getDefault();
        this.connectorImage = new Image((Device)d, String.valueOf(this.getClass().getProtectionDomain().getCodeSource().getLocation().toString().substring(5)) + "icons" + "/" + "conn.png");
        this.regionImage = new Image((Device)d, String.valueOf(this.getClass().getProtectionDomain().getCodeSource().getLocation().toString().substring(5)) + "icons" + "/" + "region_.png");
        this.fileImage = new Image((Device)d, String.valueOf(this.getClass().getProtectionDomain().getCodeSource().getLocation().toString().substring(5)) + "icons" + "/" + "file.png");
    }

    private String getIndentLine(IDocument doc, int offset) {
        int ident = 0;
        try {
            char c;
            while ((c = doc.getChar(--offset)) != '\n') {
                if (c == '\t') {
                    ++ident;
                    continue;
                }
                ident = 0;
            }
        }
        catch (BadLocationException e) {
            ident = 0;
        }
        String str = "";
        int i = 0;
        while (i < ident) {
            str = String.valueOf(str) + "\t";
            ++i;
        }
        return str;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'<'};
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return new char[]{'<'};
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    private TextInfo currentText(IDocument document, int documentOffset) {
        try {
            ITypedRegion region = document.getPartition(documentOffset);
            int partitionOffset = region.getOffset();
            int partitionLength = region.getLength();
            int index = documentOffset - partitionOffset;
            String partitionText = document.get(partitionOffset, partitionLength);
            System.out.println("Partition text: " + document.get(partitionOffset, region.getLength()));
            char c = partitionText.charAt(index);
            if (Character.isWhitespace(c) || Character.isWhitespace(partitionText.charAt(index - 1))) {
                return new TextInfo("", documentOffset, true);
            }
            if (c == '<') {
                return new TextInfo("", documentOffset, true);
            }
            int start = index;
            c = partitionText.charAt(start);
            while (!Character.isWhitespace(c) && c != '<' && start >= 0) {
                c = partitionText.charAt(--start);
            }
            ++start;
            int end = index;
            c = partitionText.charAt(end);
            while (!Character.isWhitespace(c) && c != '>' && end < partitionLength - 1) {
                c = partitionText.charAt(++end);
            }
            String substring = partitionText.substring(start, end);
            return new TextInfo(substring, partitionOffset + start, false);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return null;
        }
    }
}

