/*
 * Decompiled with CFR 0.152.
 */
package br.ufma.deinf.laws.ncleclipse.hyperlinks;

import br.ufma.deinf.laws.ncleclipse.NCLEditor;
import br.ufma.deinf.laws.ncleclipse.NCLMultiPageEditor;
import br.ufma.deinf.laws.ncleclipse.hyperlinks.OpenEditorAction;
import br.ufma.deinf.laws.ncleclipse.ncl.NCLContentHandler;
import br.ufma.deinf.laws.ncleclipse.ncl.NCLDocument;
import br.ufma.deinf.laws.ncleclipse.ncl.NCLElement;
import br.ufma.deinf.laws.ncleclipse.ncl.NCLParser;
import br.ufma.deinf.laws.util.DocumentUtil;
import java.io.File;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.xml.sax.ContentHandler;

public class NCLEclipseHyperlink
implements IHyperlink {
    int start;
    int length;
    private String text;
    private IRegion region;
    private ITextViewer textViewer;
    private NCLElement nclElement;

    public NCLEclipseHyperlink(ITextViewer textViewer, IRegion region, String text) {
        this.region = region;
        this.text = text;
        this.textViewer = textViewer;
        this.nclElement = null;
    }

    public NCLEclipseHyperlink(ITextViewer textViewer, IRegion region, String text, NCLElement nclElement) {
        this.region = region;
        this.text = text;
        this.textViewer = textViewer;
        this.nclElement = nclElement;
    }

    public IRegion getHyperlinkRegion() {
        return this.region;
    }

    public void open() {
        if (this.text != null) {
            try {
                int indexOfPound = this.text.indexOf("#");
                IWorkbench wb = PlatformUI.getWorkbench();
                IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
                IWorkbenchPage page = win.getActivePage();
                NCLEditor editor = ((NCLMultiPageEditor)page.getActiveEditor()).getNCLEditor();
                if (indexOfPound == -1) {
                    editor.setFocusToElementId(this.text);
                } else {
                    String nclText = editor.getInputDocument().get();
                    NCLContentHandler nclContentHandler = new NCLContentHandler();
                    NCLDocument nclDocument = new NCLDocument();
                    File currentFile = editor.getCurrentFile();
                    if (currentFile == null) {
                        return;
                    }
                    nclDocument.setParentURI(currentFile.getParentFile().toURI());
                    nclContentHandler.setNclDocument(nclDocument);
                    NCLParser parser = new NCLParser();
                    parser.setContentHandler((ContentHandler)nclContentHandler);
                    parser.doParse(nclText);
                    NCLElement el = nclDocument.getElementByAlias(this.text.substring(0, indexOfPound));
                    String file = el.getAttributeValue("documentURI");
                    if (file != null) {
                        String fileAbsolutePath = DocumentUtil.getAbsoluteFileName((String)editor.getCurrentFile().getAbsolutePath(), (String)file);
                        OpenEditorAction openEditorAction = new OpenEditorAction();
                        openEditorAction.setExternalFile(fileAbsolutePath, this.text.substring(indexOfPound + 1, this.text.length()));
                        openEditorAction.run();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String getTypeLabel() {
        return null;
    }

    public String getHyperlinkText() {
        return "<" + this.nclElement.getTagName() + " id=\"" + this.nclElement.getAttributeValue("id") + "\"  ...\\>";
    }
}

