/*
 * Decompiled with CFR 0.152.
 */
package br.ufma.deinf.laws.ncleclipse.layout.figure;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;

public class AlphaLayerFigure
extends Figure {
    private Color color;
    protected Image layerImage;
    private ImageData imageData;

    public AlphaLayerFigure(Color color, int alpha) {
        this.color = color;
        PaletteData palette = new PaletteData(new RGB[]{color.getRGB()});
        this.imageData = new ImageData(1, 1, 8, palette);
        this.imageData.alpha = alpha;
        this.imageData.setPixel(0, 0, 0);
        this.layerImage = new Image(null, this.imageData);
    }

    public void setAlpha(int alpha) {
        this.imageData.alpha = alpha;
        if (this.layerImage != null && !this.layerImage.isDisposed()) {
            this.layerImage.dispose();
        }
        this.layerImage = new Image(null, this.imageData);
        this.repaint();
    }

    public int getAlpha() {
        return this.imageData.alpha;
    }

    public void setColor(Color color) {
        this.color = color;
        this.imageData.palette.colors[0] = color.getRGB();
        if (this.layerImage != null && !this.layerImage.isDisposed()) {
            this.layerImage.dispose();
        }
        this.layerImage = new Image(null, this.imageData);
        this.repaint();
    }

    public Color getColor() {
        return this.color;
    }

    public void paintFigure(Graphics g) {
        Rectangle rectangle = this.getClientArea();
        g.drawImage(this.layerImage, new Rectangle(this.layerImage.getBounds()), rectangle);
    }
}

