/*
 * Decompiled with CFR 0.152.
 */
package br.ufma.deinf.laws.ncleclipse.hover;

import br.ufma.deinf.laws.ncleclipse.hover.NCLHoverInformationControl;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class NCLHoverInformationControl
extends DefaultInformationControl
implements IInformationControlExtension2 {
    private Browser fBrowser;
    private boolean fIsURL;
    boolean fShowInDefaultInformationControl;

    public NCLHoverInformationControl(Shell parent) {
        super(parent, null);
        this.create();
    }

    protected void createContent(Composite parent) {
        super.createContent(parent);
        try {
            Shell s = this.getShell();
            this.fBrowser = new Browser((Composite)this.getShell(), 0);
            this.fBrowser.setForeground(parent.getForeground());
            this.fBrowser.setBackground(parent.getBackground());
            this.fBrowser.setFont(JFaceResources.getDialogFont());
        }
        catch (SWTError e) {
            MessageBox messageBox = new MessageBox(this.getShell(), 33);
            messageBox.setMessage("Browser cannot be initialized.");
            messageBox.setText("Error");
            messageBox.open();
        }
    }

    public void setInformation(String content) {
        if (this.fShowInDefaultInformationControl) {
            super.setInformation(content);
        } else {
            this.fBrowser.setBounds(this.getShell().getClientArea());
            if (this.fIsURL) {
                this.fBrowser.setUrl(content);
            } else {
                this.fBrowser.setText(content);
            }
        }
    }

    public Point computeSizeHint() {
        if (this.fShowInDefaultInformationControl) {
            return super.computeSizeHint();
        }
        int widthHint = 350;
        return this.getShell().computeSize(350, -1, true);
    }

    public boolean hasContents() {
        if (this.fShowInDefaultInformationControl) {
            return super.hasContents();
        }
        return this.fBrowser.getText().length() > 0;
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.fShowInDefaultInformationControl) {
            return super.getInformationPresenterControlCreator();
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public void setInput(Object input) {
        String inputString;
        this.fIsURL = false;
        this.fShowInDefaultInformationControl = false;
        if (input instanceof IHTMLHoverInfo) {
            IHTMLHoverInfo inputInfo = (IHTMLHoverInfo)input;
            inputString = inputInfo.getHTMLString();
            this.fIsURL = inputInfo.isURL();
        } else if (input instanceof String) {
            this.fShowInDefaultInformationControl = true;
            inputString = (String)input;
        } else {
            inputString = input.toString();
        }
        this.setInformation(inputString);
    }
}

