/*
 * Decompiled with CFR 0.152.
 */
package br.ufma.deinf.laws.ncleclipse.hyperlinks;

import br.ufma.deinf.laws.ncl.NCLStructure;
import br.ufma.deinf.laws.ncleclipse.NCLEditor;
import br.ufma.deinf.laws.ncleclipse.NCLMultiPageEditor;
import br.ufma.deinf.laws.ncleclipse.document.NCLSourceDocument;
import br.ufma.deinf.laws.ncleclipse.hyperlinks.NCLEclipseHyperlink;
import br.ufma.deinf.laws.ncleclipse.ncl.NCLContentHandler;
import br.ufma.deinf.laws.ncleclipse.ncl.NCLDocument;
import br.ufma.deinf.laws.ncleclipse.ncl.NCLElement;
import br.ufma.deinf.laws.ncleclipse.ncl.NCLParser;
import java.io.File;
import java.util.Collection;
import java.util.Vector;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.xml.sax.ContentHandler;

public class NCLEclipseHyperlinkDetector
implements IHyperlinkDetector {
    ITextViewer textViewer = null;

    public NCLEclipseHyperlinkDetector(ITextViewer textViewer) {
        this.textViewer = textViewer;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        String line;
        IRegion lineInfo;
        int offset = region.getOffset();
        NCLSourceDocument doc = (NCLSourceDocument)textViewer.getDocument();
        boolean tmp = false;
        if (!tmp) {
            block11: {
                ITypedRegion typedRegion;
                block10: {
                    typedRegion = doc.getPartition(region.getOffset());
                    if (typedRegion.getType() == "__xml_start_tag") break block10;
                    return null;
                }
                try {
                    String tagname = doc.getCurrentTagname(offset);
                    int startRegionOffset = typedRegion.getOffset();
                    if (!doc.isAttributeValue(offset)) break block11;
                    String currentAttr = doc.getCurrentAttribute(offset);
                    String attrValue = doc.getAttributeValueFromCurrentTagName(offset, currentAttr);
                    int startAttributeValue = doc.getStartAttributeValueOffset(offset) + 1;
                    if (startAttributeValue == -1 || attrValue.equals("")) break block11;
                    NCLStructure nclStructure = NCLStructure.getInstance();
                    Collection nclReference = nclStructure.getNCLReference(tagname, currentAttr);
                    if (nclReference == null || nclReference.size() == 0) {
                        Collection c = nclStructure.getNCLReverseReference(tagname, currentAttr);
                        IWorkbench wb = PlatformUI.getWorkbench();
                        IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
                        IWorkbenchPage page = win.getActivePage();
                        NCLEditor editor = ((NCLMultiPageEditor)page.getActiveEditor()).getNCLEditor();
                        String nclText = editor.getInputDocument().get();
                        NCLContentHandler nclContentHandler = new NCLContentHandler();
                        NCLDocument nclDocument = new NCLDocument();
                        File currentFile = editor.getCurrentFile();
                        nclDocument.setParentURI(currentFile.getParentFile().toURI());
                        nclContentHandler.setNclDocument(nclDocument);
                        NCLParser parser = new NCLParser();
                        parser.setContentHandler((ContentHandler)nclContentHandler);
                        parser.doParse(nclText);
                        Vector v = nclDocument.getElements(tagname, attrValue);
                        NCLEclipseHyperlink[] values = new NCLEclipseHyperlink[v.size()];
                        if (c != null && c.size() != 0 && v != null) {
                            Region region1 = new Region(startAttributeValue, attrValue.length());
                            int i = 0;
                            while (i < v.size()) {
                                values[i] = new NCLEclipseHyperlink(textViewer, (IRegion)region1, ((NCLElement)v.get(i)).getAttributeValue("id"), (NCLElement)v.get(i));
                                ++i;
                            }
                            return values;
                        }
                        break block11;
                    }
                    Region region1 = new Region(startAttributeValue, attrValue.length());
                    return new IHyperlink[]{new NCLEclipseHyperlink(textViewer, (IRegion)region1, attrValue)};
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
            return null;
        }
        try {
            lineInfo = doc.getLineInformationOfOffset(offset);
            line = doc.get(lineInfo.getOffset(), lineInfo.getLength());
        }
        catch (BadLocationException ex) {
            return null;
        }
        int begin = line.indexOf("<");
        int end = line.indexOf(">");
        if (end < 0 || begin < 0 || end == begin + 1) {
            return null;
        }
        String text = line.substring(begin + 1, end);
        Region region1 = new Region(lineInfo.getOffset() + begin + 1, text.length() - 1);
        return new IHyperlink[]{new NCLEclipseHyperlink(textViewer, (IRegion)region1, text)};
    }
}

