/*
 * Decompiled with CFR 0.152.
 */
package br.ufma.deinf.laws.ncleclipse.format;

import br.ufma.deinf.laws.ncleclipse.format.XMLFormatter;
import java.io.StringReader;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.formatter.ContextBasedFormattingStrategy;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class NCLDocumentFormattingStrategy
extends ContextBasedFormattingStrategy {
    private final LinkedList documents = new LinkedList();

    public void format() {
        super.format();
        IDocument document = (IDocument)this.documents.removeFirst();
        if (document != null) {
            String text = document.get();
            try {
                DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
                builderFactory.setExpandEntityReferences(false);
                DocumentBuilder documentBuilder = builderFactory.newDocumentBuilder();
                documentBuilder.setEntityResolver((EntityResolver)new /* Unavailable Anonymous Inner Class!! */);
                Document dom = documentBuilder.parse(new InputSource(new StringReader(text)));
                XMLFormatter formatter = new XMLFormatter();
                document.set(formatter.format(dom));
            }
            catch (Exception e) {
                e.printStackTrace();
                MessageDialog.openInformation(null, (String)"XML Format", (String)"The XML Formatter can only format valid XML. Please correct the errors first.");
            }
        }
    }

    public void formatterStarts(IFormattingContext context) {
        super.formatterStarts(context);
        this.documents.addLast(context.getProperty((Object)"formatting.context.medium"));
    }

    public void formatterStops() {
        super.formatterStops();
        this.documents.clear();
    }
}

