/*
 * Decompiled with CFR 0.152.
 */
package br.ufma.deinf.laws.ncleclipse.hover;

import br.ufma.deinf.laws.ncleclipse.hover.NCLHoverInformationControl;
import br.ufma.deinf.laws.ncleclipse.hover.RegionTest;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.eclipse.jface.text.AbstractInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class NCLHoverInformationControl
extends AbstractInformationControl
implements IInformationControlExtension2 {
    private Browser fBrowser;
    boolean fIsURL;
    boolean fShowInDefaultInformationControl;
    private Color fBackgroundColor;
    private Object result;
    private Composite composite;
    private Shell shell;
    private String image;
    private Image img;
    private int fMaxWidth = -1;
    private int fMaxHeight = -1;

    public NCLHoverInformationControl(Shell parent) {
        super(parent, false);
        this.create();
    }

    protected void createContent(Composite parent) {
        try {
            this.composite = this.getShell();
            this.initializeColors();
            this.composite.setForeground(this.composite.getDisplay().getSystemColor(28));
            this.composite.setBackground(this.fBackgroundColor);
            this.shell = (Shell)this.composite;
            this.fBrowser = new Browser(parent, 2048);
            this.fBrowser.setBackground(this.fBackgroundColor);
            this.fBrowser.setForeground(this.composite.getDisplay().getSystemColor(28));
        }
        catch (SWTError e) {
            e.printStackTrace();
            MessageBox messageBox = new MessageBox(this.getShell(), 33);
            messageBox.setMessage("Browser cannot be initialized.");
            messageBox.setText("Error");
            messageBox.open();
        }
    }

    private void initializeColors() {
        this.fBackgroundColor = this.getShell().getDisplay().getSystemColor(29);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.getShell().pack(true);
            Point newSize = this.computeSizeHint();
            this.setSize(newSize.x, newSize.y);
        }
        super.setVisible(visible);
    }

    public void setInformation(String content) {
        String[] tmp = content.split("'");
        this.image = tmp[9];
        this.fBrowser.setBounds(this.getShell().getClientArea());
        if (this.fIsURL) {
            this.fBrowser.setUrl(content);
        } else {
            this.fBrowser.setText(content);
        }
    }

    public Point computeSizeHint() {
        BufferedImage img = null;
        try {
            img = ImageIO.read(new File(this.image));
            this.img = img;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int x = 20;
        int y = 20;
        if (this.result instanceof RegionTest) {
            x += 20;
            y += 20;
        }
        return new Point(((Image)img).getWidth(null) + 20, ((Image)img).getHeight(null) + 20);
    }

    public boolean hasContents() {
        return this.fBrowser.getText().length() > 0;
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public void setInput(Object input) {
        String inputString;
        this.fIsURL = false;
        this.result = input;
        if (input instanceof IHTMLHoverInfo) {
            IHTMLHoverInfo inputInfo = (IHTMLHoverInfo)input;
            inputString = inputInfo.getHTMLString();
            this.fIsURL = inputInfo.isURL();
        } else if (input instanceof String) {
            String tmp = (String)input;
            inputString = "<html><body bgcolor='fffacd' border='0' top ='0' style='font-size:12; font-face=Courier New;'>" + tmp.replace("\n", "<br/>") + "</body>";
        } else {
            inputString = input.toString();
        }
        this.setInformation(inputString);
    }

    public void dispose() {
        super.dispose();
        File tmp = new File(String.valueOf(this.getClass().getProtectionDomain().getCodeSource().getLocation().toString().substring(5)) + "icons" + File.separatorChar + "tmp.png");
        if (tmp.isFile()) {
            tmp.delete();
        }
    }
}

