/*
 * Decompiled with CFR 0.152.
 */
package br.ufma.deinf.laws.ncl.help;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.CharBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class NCLHelperFactory {
    private String helpFileName;
    private String fileBuffer;
    private Map<String, Map<String, String>> help;

    public NCLHelperFactory(String Filename) {
        this.helpFileName = Filename;
    }

    public void buildHelp() {
        this.readHelperFileIntoString();
        this.parseHelperFileIntoMap();
    }

    private void parseHelperFileIntoMap() {
        this.help = new HashMap();
        StringTokenizer st = new StringTokenizer(this.fileBuffer, "|");
        while (st.hasMoreTokens()) {
            String element = st.nextToken().trim();
            System.out.println(element);
            String attribute = st.nextToken().trim();
            System.out.println(attribute);
            String description = st.nextToken().trim();
            HashMap<String, String> descriptionMap = (HashMap<String, String>)this.help.get(element);
            if (descriptionMap != null) {
                descriptionMap.put(attribute, description);
                continue;
            }
            descriptionMap = new HashMap<String, String>();
            descriptionMap.put(attribute, description);
            this.help.put(element, descriptionMap);
        }
    }

    private void readHelperFileIntoString() {
        try {
            File helperFile = new File(this.helpFileName);
            InputStreamReader input = new InputStreamReader((InputStream)new FileInputStream(helperFile), "UTF-8");
            BufferedReader in = new BufferedReader(input);
            CharBuffer charBuffer = CharBuffer.allocate((int)helperFile.length());
            in.read(charBuffer);
            this.fileBuffer = new String(charBuffer.array());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setHelp(Map<String, Map<String, String>> help) {
        this.help = help;
    }

    public Map<String, Map<String, String>> getHelp() {
        return this.help;
    }
}

