/*
 * Decompiled with CFR 0.152.
 */
package br.ufma.deinf.laws.ncleclipse.ncl;

import br.ufma.deinf.laws.ncleclipse.ncl.NCLElement;
import br.ufma.deinf.laws.util.MultiHashMap;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

public class NCLDocument {
    protected MultiHashMap elements = new MultiHashMap();
    protected Element root;
    protected String id;
    protected URI parentURI;
    protected String fileName;
    protected String alias;

    public MultiHashMap getElements() {
        return this.elements;
    }

    public void setElements(MultiHashMap elements) {
        this.elements = elements;
    }

    public Element getRoot() {
        return this.root;
    }

    public void setRoot(Element root) {
        this.root = root;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void addElement(String tagname, Attributes atts) {
        this.elements.put((Object)tagname, (Object)atts);
    }

    public void addElement(NCLElement element, String id) {
        if (this.alias != null && !this.alias.equals("")) {
            element.setAttributeValue("id", String.valueOf(this.alias) + "#" + element.getAttributeValue("id"));
            this.elements.put((Object)element.getTagName(), (Object)element);
        } else {
            this.elements.put((Object)element.getTagName(), (Object)element);
        }
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public URI getParentURI() {
        return this.parentURI;
    }

    public void setParentURI(URI parentURI) {
        this.parentURI = parentURI;
    }

    public Collection getElementsFromPerspective(String tagname, String perspective) {
        ArrayList<NCLElement> elementsFromPerspective = new ArrayList<NCLElement>();
        Collection elements = this.getElements().get(tagname);
        if (elements == null) {
            return null;
        }
        for (NCLElement nclElement : elements) {
            if (!nclElement.getPerspective().equals(perspective)) continue;
            elementsFromPerspective.add(nclElement);
        }
        return elementsFromPerspective;
    }

    public Collection getElementsFromCompletePerspective(String tagname, String completePerspective) {
        ArrayList<NCLElement> elementsFromPerspective = new ArrayList<NCLElement>();
        Collection elements = this.getElements().get(tagname);
        if (elements != null) {
            for (NCLElement nclElement : elements) {
                if (!nclElement.getCompletePerspective().equals(completePerspective)) continue;
                elementsFromPerspective.add(nclElement);
            }
        }
        return elementsFromPerspective;
    }

    public NCLElement getElementById(String id) {
        Set keySet = this.getElements().keySet();
        if (this.elements == null) {
            return null;
        }
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            Collection elements = this.getElements().get((String)it.next());
            if (elements == null) {
                return null;
            }
            for (NCLElement nclElement : elements) {
                String idElement = (String)nclElement.getAttributes().get("id");
                if (idElement == null || !idElement.equals(id)) continue;
                return nclElement;
            }
        }
        return null;
    }

    public Vector<NCLElement> getElements(String tag, String attribute) {
        Set keySet = this.getElements().keySet();
        if (this.elements == null) {
            return null;
        }
        Iterator it = keySet.iterator();
        Vector<NCLElement> r = new Vector<NCLElement>();
        if (tag.equals("causalConnector")) {
            tag = "xconnector";
        }
        while (it.hasNext()) {
            Collection elements = this.getElements().get((String)it.next());
            if (elements == null) {
                return null;
            }
            for (NCLElement nclElement : elements) {
                String idElement = (String)nclElement.getAttributes().get(tag);
                if (idElement == null && (tag.equals("media") || tag.equals("port") || tag.equals("area"))) {
                    idElement = (String)nclElement.getAttributes().get("component");
                }
                if (idElement == null || !idElement.equals(attribute)) continue;
                r.add(nclElement);
            }
        }
        return r.size() == 0 ? null : r;
    }

    public NCLElement getElementByAlias(String alias) {
        Set keySet = this.getElements().keySet();
        if (this.elements == null) {
            return null;
        }
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            Collection elements = this.getElements().get((String)it.next());
            if (elements == null) {
                return null;
            }
            for (NCLElement nclElement : elements) {
                String aliasElement = (String)nclElement.getAttributes().get("alias");
                if (aliasElement == null || !aliasElement.equals(alias)) continue;
                return nclElement;
            }
        }
        return null;
    }
}

