/*
 * Decompiled with CFR 0.152.
 */
package br.ufma.deinf.laws.ncleclipse.xml;

import br.ufma.deinf.laws.ncleclipse.xml.XMLValidationErrorHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.StringReader;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

public class XMLParser {
    private ErrorHandler errorHandler;
    private ContentHandler contentHandler;
    public static final String VALIDATION_FEATURE = "http://xml.org/sax/features/validation";

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public static void main(String[] args) {
        try {
            XMLParser parser = new XMLParser();
            parser.setErrorHandler((ErrorHandler)new XMLValidationErrorHandler());
            parser.doParse(new File(args[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public void doParse(File xmlFilePath) throws RuntimeException {
        InputSource inputSource = null;
        try {
            inputSource = new InputSource(new FileReader(xmlFilePath));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        this.doParse(inputSource);
    }

    public void doParse(String xmlText) throws RuntimeException {
        InputSource inputSource = new InputSource(new StringReader(xmlText));
        this.doParse(inputSource);
    }

    public void doParse(InputSource inputSource) throws RuntimeException {
        try {
            SAXParser reader = new SAXParser();
            reader.setErrorHandler(this.errorHandler);
            reader.setContentHandler(this.contentHandler);
            reader.parse(inputSource);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

