/*
 * Decompiled with CFR 0.152.
 */
package br.ufma.deinf.laws.ncleclipse.document;

import br.ufma.deinf.laws.ncleclipse.NCLEditor;
import br.ufma.deinf.laws.ncleclipse.NCLEditorMessages;
import br.ufma.deinf.laws.ncleclipse.NCLMultiPageEditor;
import br.ufma.deinf.laws.ncleclipse.scanners.XMLPartitionScanner;
import br.ufma.deinf.laws.ncleclipse.scanners.XMLTagScanner;
import br.ufma.deinf.laws.ncleclipse.util.ColorManager;
import br.ufma.deinf.laws.ncleclipse.util.XMLPartitioner;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class NCLSourceDocument
extends Document {
    private XMLTagScanner scanner;
    private int tamAttr = 0;
    String currentAttribute;
    private int startAttributeValueOffset = -1;
    private HashMap<String, String> importedComments = new HashMap();
    private Vector<String> importedTags = new Vector();

    public NCLSourceDocument() {
    }

    public NCLSourceDocument(IDocument doc) {
        super(doc.get());
    }

    public NCLSourceDocument(String doc) {
        super(doc);
    }

    public int getFatherPartitionOffset(int documentOffset) {
        try {
            String text;
            ITypedRegion region = this.getPartition(documentOffset);
            int partitionOffset = region.getOffset();
            while (region.getType().equals("__xml_start_tag")) {
                text = this.get(region.getOffset(), region.getLength());
                region = this.getPartition(--documentOffset);
            }
            Stack<Integer> pilha = new Stack<Integer>();
            while (true) {
                text = this.get(region.getOffset(), region.getLength());
                if (region.getType().equals("__xml_end_tag")) {
                    pilha.push(new Integer(1));
                } else if (region.getType().equals("__xml_start_tag") && !text.endsWith("/>")) {
                    if (pilha.size() == 0) break;
                    pilha.pop();
                }
                region = this.getPartition(--partitionOffset);
                partitionOffset = region.getOffset();
            }
            return partitionOffset;
        }
        catch (BadLocationException e) {
            return -1;
        }
    }

    public int getFatherPartitionOffsetFromEndTag(int documentOffset) {
        try {
            ITypedRegion region = this.getPartition(documentOffset);
            int partitionOffset = region.getOffset();
            Stack<Integer> pilha = new Stack<Integer>();
            String text = this.get(region.getOffset(), region.getLength());
            region = this.getPartition(region.getOffset() - 1);
            partitionOffset = region.getOffset();
            while (true) {
                text = this.get(region.getOffset(), region.getLength());
                if (region.getType().equals("__xml_end_tag")) {
                    pilha.push(new Integer(1));
                } else if (region.getType().equals("__xml_start_tag") && !text.endsWith("/>")) {
                    if (pilha.size() == 0) break;
                    pilha.pop();
                }
                region = this.getPartition(--partitionOffset);
                partitionOffset = region.getOffset();
            }
            return partitionOffset;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public Vector<Integer> getChildrenOffsets(int offset) {
        try {
            Vector<Integer> offsets = new Vector<Integer>();
            ITypedRegion region = this.getPartition(offset);
            String tagname = this.getCurrentTagname(offset);
            if (tagname == null) {
                return offsets;
            }
            String text = this.get(region.getOffset(), region.getLength());
            if (text.endsWith("/>")) {
                return offsets;
            }
            do {
                region = this.getNextPartition(region);
                offset = region.getOffset();
                text = this.get(region.getOffset(), region.getLength());
                if (region.getType().equals("__xml_start_tag")) {
                    offsets.add(offset);
                    continue;
                }
                if (region.getType().equals("__xml_end_tag") && text.equals("</" + tagname + ">")) break;
            } while (!text.equals("</ncl>"));
            return offsets;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getFatherTagName(int documentOffset) {
        return this.getCurrentTagname(this.getFatherPartitionOffset(documentOffset));
    }

    public ITypedRegion getPreviousPartition(ITypedRegion r) {
        if (r == null) {
            return null;
        }
        if (r.getOffset() < 1) {
            return null;
        }
        ITypedRegion pr = null;
        try {
            pr = this.getPartition(r.getOffset() - 1);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return pr;
    }

    public ITypedRegion getPreviousTagPartition(int offset) throws BadLocationException {
        ITypedRegion partition = this.getPartition(offset);
        if (partition == null || partition.getType().equals("__xml_start_tag")) {
            return partition;
        }
        return this.getPreviousTagPartition(partition);
    }

    public ITypedRegion getPreviousTagPartition(ITypedRegion r) {
        ITypedRegion partition = this.getPreviousPartition(r);
        while (partition != null && !partition.getType().equals("__xml_start_tag")) {
            partition = this.getPreviousPartition(partition);
        }
        return partition;
    }

    public String getCurrentTagname(int documentOffset) {
        try {
            ITypedRegion region = this.getPartition(documentOffset);
            int partitionOffset = region.getOffset();
            int readLength = region.getLength();
            ColorManager colorManager = new ColorManager();
            this.scanner = new XMLTagScanner(colorManager);
            String text = this.get(partitionOffset, readLength);
            int p = 0;
            String tagname = "";
            char ch = text.charAt(0);
            while (p + 1 < text.length() && Character.isJavaIdentifierPart(text.charAt(p + 1))) {
                ch = text.charAt(++p);
                tagname = String.valueOf(tagname) + ch;
            }
            return tagname;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getAttributeValueFromCurrentTagName(int offset, String attribute) {
        int readLength;
        int partitionOffset;
        block14: {
            ITypedRegion region = this.getPartition(offset);
            partitionOffset = region.getOffset();
            readLength = region.getLength();
            if (attribute != null) break block14;
            return null;
        }
        try {
            String text = this.get(partitionOffset, readLength);
            boolean firstQuote = false;
            boolean equal = false;
            String attributeValue = "";
            String attributeName = "";
            int i = 0;
            while (i < text.length()) {
                if (text.charAt(i) == '\"' || text.charAt(i) == '\'') {
                    if (!firstQuote) {
                        firstQuote = true;
                    } else {
                        String[] str = attributeName.split(" ");
                        Vector<String> v = new Vector<String>();
                        String[] stringArray = str;
                        int n = str.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String s = stringArray[n2];
                            if (!s.equals("")) {
                                v.add(s);
                            }
                            ++n2;
                        }
                        if (((String)v.get(v.size() - 1)).equals(attribute)) {
                            return attributeValue;
                        }
                        attributeName = "";
                        attributeValue = "";
                        firstQuote = false;
                        equal = true;
                    }
                } else if (firstQuote) {
                    attributeValue = String.valueOf(attributeValue) + text.charAt(i);
                } else if (text.charAt(i) != '=') {
                    attributeName = String.valueOf(attributeName) + text.charAt(i);
                }
                ++i;
            }
            return null;
        }
        catch (BadLocationException e) {
            return "";
        }
    }

    private int getAttributeSize(int offset, String attr) {
        this.getAttributeValueFromCurrentTagName(offset, attr);
        return this.tamAttr;
    }

    public String getCurrentAttribute(int offset) {
        if (this.isAttributeValue(offset)) {
            return this.currentAttribute;
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isAttributeValue(int offset) {
        this.startAttributeValueOffset = -1;
        try {
            ITypedRegion region = this.getPartition(offset--);
            if (region.getType() == "__xml_start_tag") {
                int partitionOffset = region.getOffset();
                this.currentAttribute = "";
                boolean firstQuote = true;
                boolean findingAttributeName = false;
                int beginAttributeName = -1;
                int endAttributeName = -1;
                while (offset >= partitionOffset) {
                    char ch = this.getChar(offset--);
                    if (findingAttributeName) {
                        if (Character.isJavaIdentifierPart(ch)) {
                            if (endAttributeName != -1) continue;
                            endAttributeName = offset;
                            continue;
                        }
                        if (Character.isWhitespace(ch) && endAttributeName != -1) {
                            this.currentAttribute = this.get(offset + 2, endAttributeName - offset);
                            return true;
                        }
                        if (Character.isWhitespace(ch)) continue;
                        return false;
                    }
                    if (ch == '\'' || ch == '\"') {
                        if (!firstQuote) {
                            return false;
                        }
                        this.startAttributeValueOffset = offset + 1;
                        firstQuote = false;
                        continue;
                    }
                    if (ch != '=') continue;
                    findingAttributeName = true;
                }
            }
            return false;
        }
        catch (BadLocationException e) {
            return false;
        }
    }

    public int getStartAttributeValueOffset(int offset) {
        if (this.isAttributeValue(offset)) {
            return this.startAttributeValueOffset;
        }
        return -1;
    }

    public boolean isAttribute(int documentOffset) {
        try {
            ITypedRegion region = this.getPartition(documentOffset);
            if (region.getType() == "__xml_start_tag") {
                return !this.isTagname(documentOffset) && !this.isAttributeValue(documentOffset);
            }
            return false;
        }
        catch (BadLocationException e) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isTagname(int documentOffset) {
        boolean isTagname = false;
        try {
            char ch;
            ITypedRegion region = this.getPartition(documentOffset);
            String text = this.get(region.getOffset(), documentOffset - region.getOffset());
            int p = text.length() - 1;
            do {
                if ((ch = text.charAt(p--)) != '<') continue;
                return true;
            } while (Character.isLetter(ch));
            return false;
        }
        catch (BadLocationException e) {
            return false;
        }
    }

    public boolean isEndTagName(int documentOffset) {
        try {
            ITypedRegion region = this.getPartition(documentOffset);
            return region.getType() == "__xml_end_tag";
        }
        catch (BadLocationException e) {
            return false;
        }
    }

    public ITypedRegion getNextTagPartition(int offset) throws BadLocationException {
        ITypedRegion partition = this.getPartition(offset);
        if (partition == null || partition.getType().equals("__xml_start_tag")) {
            return partition;
        }
        return this.getNextTagPartition(partition);
    }

    public ITypedRegion getNextTagPartition(String tagname, int offset) throws BadLocationException {
        ITypedRegion partition = this.getPartition(offset);
        while (partition != null) {
            if (partition.getType().equals("__xml_start_tag") && this.getCurrentTagname(partition.getOffset()).equals(tagname)) {
                return partition;
            }
            partition = this.getNextTagPartition(partition);
        }
        return null;
    }

    public ITypedRegion getNextTagPartition(ITypedRegion r) {
        ITypedRegion partition = this.getNextPartition(r);
        while (partition != null && !partition.getType().equals("__xml_start_tag")) {
            partition = this.getNextPartition(partition);
        }
        return partition;
    }

    public String getCurrentEndTagName(int documentOffset) {
        ITypedRegion region;
        block4: {
            region = this.getPartition(documentOffset);
            if (region.getType().equals("__xml_end_tag")) break block4;
            return null;
        }
        try {
            int partitionOffset = region.getOffset();
            int readLength = region.getLength();
            String text = this.get(partitionOffset + 1, readLength);
            int p = 0;
            String tagname = "";
            char ch = text.charAt(0);
            while (p + 1 < text.length() && Character.isJavaIdentifierPart(text.charAt(p + 1))) {
                ch = text.charAt(++p);
                tagname = String.valueOf(tagname) + ch;
            }
            return tagname;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ITypedRegion getNextEndTagPartition(String tagname, int offset) {
        try {
            ITypedRegion partition = this.getPartition(offset);
            while (partition != null) {
                if (partition.getType().equals("__xml_end_tag") && this.getCurrentEndTagName(partition.getOffset()).equals(tagname)) {
                    return partition;
                }
                partition = this.getNextPartition(partition);
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public ITypedRegion getNextEndTagPartition(ITypedRegion r) {
        ITypedRegion partition = this.getNextPartition(r);
        while (partition != null && !partition.getType().equals("__xml_end_tag")) {
            partition = this.getNextPartition(partition);
        }
        return partition;
    }

    public ITypedRegion getNextPartition(ITypedRegion r) {
        if (r == null) {
            return null;
        }
        if (r.getOffset() > this.getLength()) {
            return null;
        }
        ITypedRegion pr = null;
        try {
            pr = this.getPartition(r.getLength() + r.getOffset() + 1);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return null;
        }
        return pr;
    }

    public boolean setAttribute(String id, String attr, String value) {
        return this.setAttribute(id, attr, value, 1);
    }

    public boolean setAttribute(String id, String attr, String value, int offset) {
        ITypedRegion region;
        block10: {
            try {
                region = this.getNextTagPartition(offset);
                if (region == null) {
                    throw new BadLocationException();
                }
                String startTag = this.get(region.getOffset(), region.getLength());
                String currentId = this.getAttributeValueFromCurrentTagName(region.getOffset(), "id");
                if (currentId == null || !currentId.equals(id)) break block10;
                String attrAtual = this.getAttributeValueFromCurrentTagName(region.getOffset(), attr);
                int begin = 0;
                String newValue = String.valueOf(attr) + "=\"" + value + "\"";
                if (attrAtual == null) {
                    begin = region.getOffset() + region.getLength() - 1;
                    if (startTag.endsWith("/>")) {
                        --begin;
                    }
                    if (!this.get(begin - 1, 1).equals(" ")) {
                        newValue = " " + newValue;
                    }
                    this.replace(begin, 0, newValue);
                } else {
                    String text = this.get(region.getOffset(), region.getLength());
                    int attrOffset = text.indexOf(attr);
                    int attrSizeAtual = this.getAttributeSize(offset, attr);
                    begin = region.getOffset() + attrOffset;
                    newValue = String.valueOf(attr) + "=\"" + value + "\"";
                    if (!this.get(begin - 1, 1).equals(" ")) {
                        newValue = " " + newValue;
                    }
                    if (!this.get(begin + attrSizeAtual, 1).equals(" ")) {
                        newValue = String.valueOf(newValue) + " ";
                    }
                    this.replace(begin, attrSizeAtual, newValue);
                }
                return true;
            }
            catch (BadLocationException e) {
                return false;
            }
        }
        this.setAttribute(id, attr, value, region.getOffset() + region.getLength() + 1);
        return true;
    }

    public boolean setAttributeFromTagname(String tagname, String attr, String value, int offset) {
        ITypedRegion region;
        block10: {
            try {
                region = this.getNextTagPartition(offset);
                if (region == null) {
                    throw new BadLocationException();
                }
                String startTag = this.get(region.getOffset(), region.getLength());
                String currentTagname = this.getCurrentTagname(region.getOffset());
                if (currentTagname == null || !currentTagname.equals(tagname)) break block10;
                String attrAtual = this.getAttributeValueFromCurrentTagName(region.getOffset(), attr);
                int begin = 0;
                String newValue = String.valueOf(attr) + "=\"" + value + "\"";
                if (attrAtual == null) {
                    begin = region.getOffset() + region.getLength() - 1;
                    if (startTag.endsWith("/>")) {
                        --begin;
                    }
                    if (!this.get(begin - 1, 1).equals(" ")) {
                        newValue = " " + newValue;
                    }
                    this.replace(begin, 0, newValue);
                } else {
                    String text = this.get(region.getOffset(), region.getLength());
                    int attrOffset = text.indexOf(attr);
                    int attrSizeAtual = this.getAttributeSize(offset, attr);
                    begin = region.getOffset() + attrOffset;
                    newValue = String.valueOf(attr) + "=\"" + value + "\"";
                    if (!this.get(begin - 1, 1).equals(" ")) {
                        newValue = " " + newValue;
                    }
                    if (!this.get(begin + attrSizeAtual, 1).equals(" ")) {
                        newValue = String.valueOf(newValue) + " ";
                    }
                    this.replace(begin, attrSizeAtual, newValue);
                }
                return true;
            }
            catch (BadLocationException e) {
                return false;
            }
        }
        this.setAttribute(tagname, attr, value, region.getOffset() + region.getLength() + 1);
        return true;
    }

    public List<String> getAttributesTyped(int offset) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            ITypedRegion region = this.getPartition(offset);
            if (region.getType() == "__xml_start_tag") {
                String currentPartition = this.get(region.getOffset(), region.getLength());
                Pattern p = Pattern.compile("\\s[a-zA-Z]+");
                Matcher m = p.matcher(currentPartition);
                while (m.find()) {
                    list.add(currentPartition.substring(m.start() + 1, m.end()));
                }
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return list;
    }

    public void removeElement(String id) {
        this.removeElement(id, 0);
    }

    public boolean removeElement(String id, int offset) {
        try {
            int elementOffset = this.getElementOffset(id, offset);
            ITypedRegion region = this.getPartition(offset);
            this.replace(region.getOffset(), region.getLength(), "");
            return true;
        }
        catch (BadLocationException e) {
            return true;
        }
    }

    public boolean addElement(String tagname, int offset) {
        try {
            this.replace(offset, 1, "<" + tagname + ">\n</" + tagname + ">\n");
        }
        catch (BadLocationException e) {
            return false;
        }
        return true;
    }

    public boolean addElement(String tagname, String id, int offset) {
        try {
            this.replace(offset, 1, "<" + tagname + " id=\"" + id + "\" >\n</" + tagname + ">\n");
        }
        catch (BadLocationException e) {
            return false;
        }
        return true;
    }

    public boolean hasElementWithId(String id) {
        return this.hasElementWithId(id, 1);
    }

    public boolean hasElementWithId(String id, int offset) {
        return this.hasElementWithAttribute("id", id, offset);
    }

    public boolean hasElementWithAttribute(String attr, String value, int offset) {
        return this.getElementOffset(attr, value, offset) != -1;
    }

    public int getElementOffset(String attr, String value, int offset) {
        try {
            ITypedRegion region = this.getNextTagPartition(offset);
            if (region == null) {
                throw new BadLocationException();
            }
            String startTag = this.get(region.getOffset(), region.getLength());
            String currentAttr = this.getAttributeValueFromCurrentTagName(region.getOffset(), attr);
            if (currentAttr != null && currentAttr.equals(value)) {
                return region.getOffset();
            }
            return this.getElementOffset(attr, value, region.getOffset() + region.getLength() + 1);
        }
        catch (BadLocationException e) {
            return -1;
        }
    }

    public int getElementOffset(String id) {
        try {
            return this.getElementOffset(id, 1);
        }
        catch (BadLocationException e) {
            return -1;
        }
    }

    public int getElementOffset(String id, int offset) throws BadLocationException {
        ITypedRegion region = this.getNextTagPartition(offset);
        if (region == null) {
            throw new BadLocationException();
        }
        String startTag = this.get(region.getOffset(), region.getLength());
        String currentId = this.getAttributeValueFromCurrentTagName(region.getOffset(), "id");
        if (currentId != null && currentId.equals(id)) {
            return offset;
        }
        return this.getElementOffset(id, region.getOffset() + region.getLength() + 1);
    }

    public static NCLSourceDocument createNCLSourceDocumentFromIDocument(IDocument doc) {
        if (doc instanceof NCLSourceDocument) {
            return (NCLSourceDocument)doc;
        }
        NCLSourceDocument document = new NCLSourceDocument();
        document.set(doc.get());
        XMLPartitioner partitioner = new XMLPartitioner((IPartitionTokenScanner)new XMLPartitionScanner(), new String[]{"__xml_start_tag", "__xml_pi", "__xml_doctype", "__xml_end_tag", "__xml_text", "__xml_cdata", "__xml_comment"});
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        return document;
    }

    public List<String> getParentList(int offset) {
        int parentOffset;
        ArrayList<String> parents = new ArrayList<String>();
        while ((parentOffset = this.getFatherPartitionOffset(offset)) >= 0) {
            parents.add(this.getAttributeValueFromCurrentTagName(parentOffset, "id"));
            offset = parentOffset;
        }
        return parents;
    }

    public String getComment(String id) {
        String beginComment;
        String info;
        block16: {
            info = null;
            if (id == null || id.equals("")) {
                return null;
            }
            beginComment = "@doc";
            int indexOf = id.indexOf(35);
            if (indexOf == -1) break block16;
            IWorkbench wb = PlatformUI.getWorkbench();
            IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
            IWorkbenchPage page = win.getActivePage();
            NCLEditor editor = ((NCLMultiPageEditor)page.getActiveEditor()).getNCLEditor();
            Vector aliasOffsset = this.getAllTagsWithAttribute("alias");
            Iterator iterator = aliasOffsset.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                String alias = this.getAttributeValueFromCurrentTagName(i, "alias");
                if (this.importedTags.contains(alias)) continue;
                this.importedTags.add(alias);
                String documentURI = this.getAttributeValueFromCurrentTagName(i, "documentURI");
                File importedFile = null;
                try {
                    if (documentURI != null && !documentURI.equals("") && !(importedFile = new File(documentURI)).isFile()) {
                        importedFile = new File(String.valueOf(editor.getCurrentFile().getParent()) + "/" + documentURI);
                    }
                    if (importedFile == null || !importedFile.isFile()) continue;
                    BufferedReader reader = new BufferedReader(new FileReader(importedFile));
                    String text = "";
                    while (reader.ready()) {
                        text = String.valueOf(text) + reader.readLine() + "\n";
                    }
                    NCLSourceDocument ncl = new NCLSourceDocument(text);
                    XMLPartitioner partitioner = new XMLPartitioner((IPartitionTokenScanner)new XMLPartitionScanner(), new String[]{"__xml_start_tag", "__xml_pi", "__xml_doctype", "__xml_end_tag", "__xml_text", "__xml_cdata", "__xml_comment"});
                    partitioner.connect((IDocument)ncl);
                    ncl.setDocumentPartitioner((IDocumentPartitioner)partitioner);
                    Vector ids = ncl.getAllTagsWithAttribute("id");
                    Iterator iterator2 = ids.iterator();
                    while (iterator2.hasNext()) {
                        int j = (Integer)iterator2.next();
                        String Id = ncl.getAttributeValueFromCurrentTagName(j, "id");
                        this.importedComments.put(String.valueOf(alias) + "#" + Id, ncl.getComment(Id));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (this.importedComments.containsKey(id)) {
                return (String)this.importedComments.get(id);
            }
            return null;
        }
        try {
            int off = this.getOffsetByID(id);
            if (off != -1) {
                String str;
                ITypedRegion r = this.getPartition(off);
                r = this.getPreviousPartition(r);
                do {
                    str = this.get(r.getOffset(), r.getLength());
                    str = str.trim();
                    if (r.getType().equals("__xml_comment")) {
                        int index = str.indexOf(beginComment);
                        if (index != -1) {
                            info = str.substring(index + beginComment.length() + 1, str.length() - 3).replace("\t", "");
                        }
                        return info;
                    }
                    r = this.getPreviousPartition(r);
                } while (str.equals(""));
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        if (info == null) {
            info = NCLEditorMessages.getInstance().getString("NCLDoc.Empty");
        }
        return info;
    }

    public int getOffsetByID(String id) {
        return this.getOffsetByValue("id", id);
    }

    public int getOffsetByValue(String attribute, String value) {
        block5: {
            if (attribute != null && value != null) break block5;
            return -1;
        }
        try {
            String t;
            ITypedRegion region = this.getPartition(0);
            do {
                String tagId;
                t = this.get(region.getOffset(), region.getLength());
                if (region.getType().equals("__xml_start_tag") && (tagId = this.getAttributeValueFromCurrentTagName(region.getOffset(), attribute)) != null && !tagId.equals("") && tagId.equals(value)) {
                    return region.getOffset();
                }
                region = this.getNextPartition(region);
            } while (!t.equals("</ncl>"));
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return -1;
    }

    public Vector<Integer> getAllTagsWithAttribute(String attribute) {
        Vector<Integer> aliasOffset = new Vector<Integer>();
        try {
            String t;
            ITypedRegion region = this.getPartition(0);
            do {
                String att;
                t = this.get(region.getOffset(), region.getLength());
                if (region.getType().equals("__xml_start_tag") && (att = this.getAttributeValueFromCurrentTagName(region.getOffset(), attribute)) != null && !att.equals("")) {
                    aliasOffset.add(region.getOffset());
                }
                region = this.getNextPartition(region);
            } while (!t.equals("</ncl>") && region != null);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return aliasOffset;
        }
        return aliasOffset;
    }

    public void setAttributefromTag(String id, String attr, String path, int offset) {
        try {
            if (offset == -1) {
                return;
            }
            ITypedRegion region = this.getPartition(offset);
            int off = region.getOffset();
            String text = this.get(region.getOffset(), region.getLength());
            boolean firstQuote = false;
            String attributeName = "";
            String attributeValue = "";
            int i = 0;
            while (i < text.length()) {
                if (text.charAt(i) == '\"' || text.charAt(i) == '\'') {
                    if (!firstQuote) {
                        firstQuote = true;
                    } else {
                        String[] str = attributeName.split(" ");
                        Vector<String> v = new Vector<String>();
                        String[] stringArray = str;
                        int n = str.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String s = stringArray[n2];
                            if (!s.equals("")) {
                                v.add(s);
                            }
                            ++n2;
                        }
                        if (((String)v.get(v.size() - 1)).equals(attr)) {
                            this.replace(off + i - attributeValue.length(), attributeValue.length(), path);
                            return;
                        }
                        attributeName = "";
                        attributeValue = "";
                        firstQuote = false;
                    }
                } else if (firstQuote) {
                    attributeValue = String.valueOf(attributeValue) + text.charAt(i);
                } else if (text.charAt(i) != '=') {
                    attributeName = String.valueOf(attributeName) + text.charAt(i);
                }
                ++i;
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }
}

