/*
 * Decompiled with CFR 0.152.
 */
package br.ufma.deinf.laws.ncleclipse.marker;

import br.ufma.deinf.gia.labmint.composer.NCLValidator;
import br.ufma.deinf.gia.labmint.message.Message;
import br.ufma.deinf.laws.ncleclipse.NCLEditorMessages;
import br.ufma.deinf.laws.ncleclipse.correction.MessagesUtilities;
import br.ufma.deinf.laws.ncleclipse.xml.XMLValidationError;
import br.ufma.deinf.laws.ncleclipse.xml.XMLValidationErrorHandler;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.xml.sax.SAXParseException;

public class MarkingErrorHandler
extends XMLValidationErrorHandler {
    public static String NCLValidatorMessage = "NCLValidatorMessageErrorID";
    public static String NCLSourceDocument = "NCLSourceDocument";
    public static String NCLMarkerError = "br.ufma.deinf.laws.ncleclipse.problemmarker";
    private static IDocument document;
    private IResource file;

    public MarkingErrorHandler(IResource file, IDocument document) {
        this.file = file;
        MarkingErrorHandler.document = document;
    }

    public static IDocument getDocument() {
        return document;
    }

    public void removeExistingMarkers() {
        try {
            this.file.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 0);
            MessagesUtilities.clear();
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
    }

    protected XMLValidationError nextError(SAXParseException e, boolean isFatal) {
        Integer charEnd;
        XMLValidationError validationError = super.nextError(e, isFatal);
        HashMap<String, Object> map = new HashMap<String, Object>();
        int lineNumber = e.getLineNumber();
        int columnNumber = e.getColumnNumber();
        MarkerUtilities.setLineNumber(map, (int)lineNumber);
        Object[] tmp = new Object[]{e.getMessage()};
        MarkerUtilities.setMessage(map, (String)NCLEditorMessages.getInstance().getString("NCLValidator.Error.XMLParserError", tmp));
        map.put("location", this.file.getFullPath().toString());
        Integer charStart = this.getCharStart(lineNumber, columnNumber);
        if (charStart != null) {
            map.put("charStart", charStart);
        }
        if ((charEnd = this.getCharEnd(lineNumber, columnNumber)) != null) {
            map.put("charEnd", charEnd);
        }
        map.put("severity", new Integer(2));
        MessagesUtilities.put((String)NCLEditorMessages.getInstance().getString("NCLValidator.Error.XMLParserError", tmp), null);
        map.put(NCLValidatorMessage, NCLEditorMessages.getInstance().getString("NCLValidator.Error.XMLParserError", tmp));
        map.put(NCLSourceDocument, document.get());
        try {
            MarkerUtilities.createMarker((IResource)this.file, map, (String)NCLMarkerError);
        }
        catch (CoreException ee) {
            ee.printStackTrace();
        }
        return validationError;
    }

    private Integer getCharEnd(int lineNumber, int columnNumber) {
        try {
            return new Integer(document.getLineOffset(lineNumber - 1) + columnNumber);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Integer getCharStart(int lineNumber, int columnNumber) {
        try {
            int lineStartChar = document.getLineOffset(lineNumber - 1);
            Integer charEnd = this.getCharEnd(lineNumber, columnNumber);
            if (charEnd != null) {
                ITypedRegion typedRegion = document.getPartition(charEnd - 2);
                int partitionStartChar = typedRegion.getOffset();
                return new Integer(partitionStartChar);
            }
            return new Integer(lineStartChar);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void MarkNCLValidatorErrorsAndWarnings() {
        Integer charEnd;
        Integer charStart;
        int columnNumber;
        int lineNumber;
        Vector warnings = NCLValidator.getWarnings();
        Vector erros = NCLValidator.getErrors();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("location", this.file.getFullPath().toString());
        map.put("severity", new Integer(1));
        int i = 0;
        while (i < warnings.size()) {
            try {
                lineNumber = new Integer((String)((Message)warnings.get(i)).getElement().getUserData("startLine"));
                columnNumber = new Integer((String)((Message)warnings.get(i)).getElement().getUserData("startColumn"));
                charStart = this.getCharStart(lineNumber, columnNumber);
                if (charStart != null) {
                    map.put("charStart", charStart);
                }
                if ((charEnd = this.getCharEnd(lineNumber, columnNumber)) != null) {
                    map.put("charEnd", charEnd);
                }
                MarkerUtilities.setMessage(map, (String)((Message)warnings.get(i)).getDescription());
                MarkerUtilities.setLineNumber(map, (int)new Integer((String)((Message)warnings.get(i)).getElement().getUserData("startLine")));
                MarkerUtilities.createMarker((IResource)this.file, map, (String)"org.eclipse.core.resources.problemmarker");
            }
            catch (CoreException ee) {
                ee.printStackTrace();
            }
            ++i;
        }
        map.put("severity", new Integer(2));
        i = 0;
        while (i < erros.size()) {
            try {
                lineNumber = new Integer((String)((Message)erros.get(i)).getElement().getUserData("startLine"));
                columnNumber = new Integer((String)((Message)erros.get(i)).getElement().getUserData("startColumn"));
                charStart = this.getCharStart(lineNumber, columnNumber);
                if (charStart != null) {
                    map.put("charStart", charStart);
                }
                if ((charEnd = this.getCharEnd(lineNumber, columnNumber)) != null) {
                    map.put("charEnd", charEnd);
                }
                MessagesUtilities.put((String)((Message)erros.get(i)).toString(), (Message)((Message)erros.get(i)));
                map.put(NCLValidatorMessage, ((Message)erros.get(i)).toString());
                map.put(NCLSourceDocument, document.get());
                MarkerUtilities.setMessage(map, (String)((Message)erros.get(i)).getDescription());
                MarkerUtilities.setLineNumber(map, (int)new Integer((String)((Message)erros.get(i)).getElement().getUserData("startLine")));
                MarkerUtilities.createMarker((IResource)this.file, map, (String)NCLMarkerError);
            }
            catch (CoreException ee) {
                ee.printStackTrace();
            }
            ++i;
        }
    }
}

