/*
 * Decompiled with CFR 0.152.
 */
package br.ufma.deinf.laws.ncleclipse.correction;

import br.ufma.deinf.gia.labmint.message.Message;
import br.ufma.deinf.laws.ncl.NCLReference;
import br.ufma.deinf.laws.ncl.NCLStructure;
import br.ufma.deinf.laws.ncleclipse.correction.FixType;
import br.ufma.deinf.laws.ncleclipse.correction.MessagesUtilities;
import br.ufma.deinf.laws.ncleclipse.correction.QuickFix;
import br.ufma.deinf.laws.ncleclipse.document.NCLSourceDocument;
import br.ufma.deinf.laws.ncleclipse.marker.MarkingErrorHandler;
import br.ufma.deinf.laws.ncleclipse.ncl.NCLContentHandler;
import br.ufma.deinf.laws.ncleclipse.ncl.NCLDocument;
import br.ufma.deinf.laws.ncleclipse.ncl.NCLElement;
import br.ufma.deinf.laws.ncleclipse.ncl.NCLParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator2;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.xml.sax.ContentHandler;

public class NCLErrorFixer
implements IMarkerResolutionGenerator2 {
    public IMarkerResolution[] getResolutions(IMarker mk) {
        try {
            Object nclValidatorErrorMsg = mk.getAttribute(MarkingErrorHandler.NCLValidatorMessage);
            Message message = null;
            NCLSourceDocument nclDoc = (NCLSourceDocument)MarkingErrorHandler.getDocument();
            ArrayList fixes = new ArrayList();
            String key = (String)nclValidatorErrorMsg;
            if (nclValidatorErrorMsg != null) {
                message = MessagesUtilities.get((String)key);
            }
            if (message == null) {
                if (nclValidatorErrorMsg != null && nclDoc != null && key.startsWith("XML sintatic error")) {
                    fixes.add(new QuickFix("Try to correct NCL structure", null, nclDoc, 0, 0, null));
                }
            } else {
                ArrayList fixMessages = new ArrayList();
                int msgId = message.getMsgID();
                String description = message.getDescription();
                int offset = 0;
                int lineNumber = (Integer)mk.getAttribute("lineNumber");
                try {
                    offset = nclDoc.getPreviousTagPartition(nclDoc.getLineInformation(lineNumber).getOffset()).getOffset();
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
                String tagname = nclDoc.getCurrentTagname(offset);
                switch (msgId) {
                    case 2002: {
                        fixes.add(this.removeAttributeResolution(message, nclDoc, description.substring(description.indexOf("'") + 1, description.lastIndexOf("'")), offset));
                        break;
                    }
                    case 2003: {
                        fixes.add(this.addAttributeResolution(message, nclDoc, description.substring(description.indexOf("'") + 1, description.lastIndexOf("'")), offset));
                        break;
                    }
                    case 2005: {
                        fixes.add(this.removeElementResolution(message, nclDoc, offset));
                        break;
                    }
                    case 2006: {
                        break;
                    }
                    case 2007: {
                        fixes.add(this.addChildResolution(message, nclDoc, description.substring(description.lastIndexOf(61), description.lastIndexOf(62)), "", "", offset));
                        break;
                    }
                    case 2008: {
                        break;
                    }
                    case 2009: {
                        break;
                    }
                    case 2010: {
                        break;
                    }
                    case 2011: {
                        break;
                    }
                    case 2012: {
                        break;
                    }
                    case 3001: {
                        fixes.add(this.removeElementResolution(message, nclDoc, offset));
                        break;
                    }
                    case 3002: {
                        fixes.add(this.removeElementResolution(message, nclDoc, offset));
                        break;
                    }
                    case 3102: {
                        fixes.add(this.addAttributeResolution(message, nclDoc, "alias", offset));
                        break;
                    }
                    case 3201: {
                        int interfaceOffset = nclDoc.getOffsetByID(nclDoc.getAttributeValueFromCurrentTagName(offset, "interface"));
                        if (interfaceOffset == -1) {
                            fixes = this.referenceErrorWithPerspective(message, nclDoc, tagname, "component", offset);
                            break;
                        }
                        int fatherOffset = nclDoc.getFatherPartitionOffset(interfaceOffset);
                        String fatherId = nclDoc.getAttributeValueFromCurrentTagName(fatherOffset, "id");
                        fixes.add(this.addAttributeResolution(message, nclDoc, "component", fatherId, offset));
                        break;
                    }
                    case 3202: {
                        fixes = this.interfaceReferenceError(message, nclDoc, offset);
                        break;
                    }
                    case 3203: {
                        fixes = this.simpleReferenceError(message, nclDoc, "descriptor", offset);
                        break;
                    }
                    case 3204: {
                        fixes = this.referenceErrorWithPerspective(message, nclDoc, tagname, "component", offset);
                        fixes.add(this.addElementResolution(message, nclDoc, "context", offset));
                        fixes.add(this.addElementResolution(message, nclDoc, "media", offset));
                        fixes.add(this.addElementResolution(message, nclDoc, "switch", offset));
                        break;
                    }
                    case 3401: {
                        fixes = this.referErrorReference(message, nclDoc, tagname, offset);
                        break;
                    }
                    case 3501: 
                    case 3502: {
                        fixes = this.referenceErrorWithPerspective(message, nclDoc, tagname, "component", offset);
                        break;
                    }
                    case 3601: {
                        fixes = this.simpleReferenceError(message, nclDoc, "descriptor", offset);
                        break;
                    }
                    case 3701: {
                        fixes = this.simpleReferenceError(message, nclDoc, "region", offset);
                        break;
                    }
                    case 3904: {
                        int index = description.lastIndexOf("'");
                        String role = "";
                        int i = index - 1;
                        while (i >= 0 && description.charAt(i) != '\'') {
                            role = String.valueOf(description.charAt(i)) + role;
                            --i;
                        }
                        fixes.add(this.addChildResolution(message, nclDoc, "bind", "role", role, offset));
                        break;
                    }
                    case 3905: {
                        fixes = this.simpleReferenceError(message, nclDoc, "causalConnector", offset);
                        break;
                    }
                    case 4001: 
                    case 4002: {
                        fixes = this.interfaceReferenceError(message, nclDoc, offset);
                        break;
                    }
                    case 4003: {
                        fixes = this.referenceErrorWithPerspective(message, nclDoc, tagname, "component", offset);
                        fixes.add(this.addElementResolution(message, nclDoc, "context", offset));
                        fixes.add(this.addElementResolution(message, nclDoc, "media", offset));
                        fixes.add(this.addElementResolution(message, nclDoc, "switch", offset));
                        break;
                    }
                    case 4102: {
                        fixes = this.referErrorReference(message, nclDoc, tagname, offset);
                        break;
                    }
                    case 4104: {
                        fixes = this.simpleAttributeError(message, nclDoc, "type", offset);
                        fixes.add(this.addAttributeResolution(message, nclDoc, "src", offset));
                        break;
                    }
                    case 4106: {
                        fixes = this.simpleReferenceError(message, nclDoc, "descriptor", offset);
                        break;
                    }
                    case 4108: {
                        fixes = this.simpleAttributeError(message, nclDoc, "type", offset);
                        fixes.add(this.addAttributeResolution(message, nclDoc, "src", offset));
                        break;
                    }
                    case 4201: 
                    case 4202: {
                        int anchorffset = nclDoc.getOffsetByID(nclDoc.getAttributeValueFromCurrentTagName(offset, "interface"));
                        if (anchorffset == -1) {
                            fixes = this.referenceErrorWithPerspective(message, nclDoc, tagname, "component", offset);
                            break;
                        }
                        int fatherOffset = nclDoc.getFatherPartitionOffset(anchorffset);
                        String fatherId = nclDoc.getAttributeValueFromCurrentTagName(fatherOffset, "id");
                        fixes.add(this.addAttributeResolution(message, nclDoc, "component", fatherId, offset));
                        break;
                    }
                    case 4203: {
                        int elementOffset = nclDoc.getOffsetByID(nclDoc.getAttributeValueFromCurrentTagName(offset, "interface"));
                        if (elementOffset == -1) {
                            fixes.add(this.addAttributeResolution(message, nclDoc, "component", offset));
                            break;
                        }
                        int fatherOffset = nclDoc.getFatherPartitionOffset(elementOffset);
                        String fatherId = nclDoc.getAttributeValueFromCurrentTagName(fatherOffset, "id");
                        fixes.add(this.addAttributeResolution(message, nclDoc, "component", fatherId, offset));
                        break;
                    }
                    case 4204: 
                    case 4205: {
                        fixes = this.interfaceReferenceError(message, nclDoc, offset);
                        break;
                    }
                    case 4501: {
                        fixes = this.referErrorReference(message, nclDoc, tagname, offset);
                        break;
                    }
                    case 4701: 
                    case 4703: {
                        fixes = this.referenceErrorWithPerspective(message, nclDoc, tagname, "constituent", offset);
                        break;
                    }
                    case 4704: {
                        fixes = this.simpleReferenceError(message, nclDoc, "rule", offset);
                        break;
                    }
                    default: {
                        return new IMarkerResolution[0];
                    }
                }
            }
            if (fixes.size() == 0) {
                return new IMarkerResolution[0];
            }
            IMarkerResolution[] resolutions = new IMarkerResolution[fixes.size()];
            fixes.toArray(resolutions);
            return resolutions;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return new IMarkerResolution[0];
        }
    }

    private ArrayList<IMarkerResolution> interfaceReferenceError(Message message, NCLSourceDocument nclDoc, int offset) {
        ArrayList<IMarkerResolution> fixes = new ArrayList<IMarkerResolution>();
        int componentOffset = nclDoc.getOffsetByID(nclDoc.getAttributeValueFromCurrentTagName(offset, "component"));
        if (componentOffset == -1) {
            return fixes;
        }
        String tag = nclDoc.getCurrentTagname(componentOffset);
        Vector childrenOffsets = nclDoc.getChildrenOffsets(componentOffset);
        Iterator iterator = childrenOffsets.iterator();
        while (iterator.hasNext()) {
            int Offset = (Integer)iterator.next();
            String id = "";
            if (!(tag.equals("media") && nclDoc.getCurrentTagname(Offset).equals("area") || tag.equals("context") && nclDoc.getCurrentTagname(Offset).equals("port")) && (!tag.equals("switch") || !nclDoc.getCurrentTagname(Offset).equals("switchPort")) || (id = nclDoc.getAttributeValueFromCurrentTagName(Offset, "id")) == null || id.equals("")) continue;
            fixes.add(this.changeAttributeResolution(message, nclDoc, "interface", id, offset));
        }
        fixes.add(this.removeAttributeResolution(message, nclDoc, "interface", offset));
        return fixes;
    }

    private ArrayList<IMarkerResolution> simpleReferenceError(Message message, NCLSourceDocument nclDoc, String element, int offset) {
        ArrayList<IMarkerResolution> fixes = new ArrayList<IMarkerResolution>();
        fixes.add(this.addElementResolution(message, nclDoc, element, offset));
        fixes.add(this.removeElementResolution(message, nclDoc, offset));
        ArrayList IDs = nclDoc.getAllElementsOfType(element);
        for (String id : IDs) {
            fixes.add(this.changeAttributeResolution(message, nclDoc, element.equals("causalConnector") ? "xconnector" : element, id, offset));
        }
        int baseOffset = -1;
        if (element.equals("causalConnector")) {
            baseOffset = nclDoc.getBaseOffset("connectorBase", "");
        } else if (element.equals("region")) {
            baseOffset = nclDoc.getBaseOffset("regionBase", "");
        } else if (element.equals("descriptor")) {
            baseOffset = nclDoc.getBaseOffset("descriptorBase", "");
        } else if (element.equals("rule")) {
            baseOffset = nclDoc.getBaseOffset("ruleBase", "");
        } else if (element.equals("transition")) {
            baseOffset = nclDoc.getBaseOffset("transitionBase", "");
        }
        if (baseOffset != -1) {
            String alias = "";
            Vector childrenOffsets = nclDoc.getChildrenOffsets(baseOffset);
            Iterator iterator = childrenOffsets.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                String tag = nclDoc.getCurrentTagname(i);
                if (!tag.equals("importBase")) continue;
                String fileName = nclDoc.getAttributeValueFromCurrentTagName(i, "documentURI");
                alias = nclDoc.getAttributeValueFromCurrentTagName(i, "alias");
                if (fileName.equals("")) continue;
                File file = new File(fileName);
                if (!file.isFile()) {
                    IWorkbench wb = PlatformUI.getWorkbench();
                    IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
                    IWorkbenchPage page = win.getActivePage();
                    IEditorPart editor = page.getActiveEditor();
                    IFile iFile = (IFile)editor.getEditorInput().getAdapter(IFile.class);
                    String path = String.valueOf(iFile.getProject().getParent().getLocation().toString()) + iFile.getParent().getFullPath().toString() + "/" + fileName;
                    file = new File(path);
                }
                if (!file.isFile()) continue;
                try {
                    BufferedReader reader = new BufferedReader(new FileReader(file));
                    String newNCL = "";
                    while (reader.ready()) {
                        newNCL = String.valueOf(newNCL) + reader.readLine() + "\n";
                    }
                    NCLSourceDocument newNCLDoc = new NCLSourceDocument(newNCL);
                    IDs = newNCLDoc.getAllElementsOfType(element);
                    for (String id : IDs) {
                        if (alias != null) {
                            id = String.valueOf(alias) + "#" + id;
                        }
                        fixes.add(this.changeAttributeResolution(message, nclDoc, element.equals("causalConnector") ? "xconnector" : element, id, offset));
                    }
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (element.equals("descriptor")) {
            IDs = nclDoc.getAllElementsOfType("descriptorSwitch");
            for (String id : IDs) {
                fixes.add(this.changeAttributeResolution(message, nclDoc, element, id, offset));
            }
        }
        return fixes;
    }

    private ArrayList<IMarkerResolution> simpleReferenceError(Message message, NCLSourceDocument nclDoc, ArrayList<String> element, int offset) {
        ArrayList<IMarkerResolution> fixes = new ArrayList<IMarkerResolution>();
        for (String str : element) {
            fixes.addAll(this.simpleReferenceError(message, nclDoc, str, offset));
        }
        return fixes;
    }

    private ArrayList<IMarkerResolution> simpleAttributeError(Message message, NCLSourceDocument nclDoc, String attribute, int offset) {
        ArrayList<IMarkerResolution> fixes = new ArrayList<IMarkerResolution>();
        fixes.add(this.addAttributeResolution(message, nclDoc, attribute, offset));
        fixes.add(this.removeElementResolution(message, nclDoc, offset));
        return fixes;
    }

    private ArrayList<IMarkerResolution> referErrorReference(Message message, NCLSourceDocument nclDoc, String tagname, int offset) {
        ArrayList<IMarkerResolution> fixes = new ArrayList<IMarkerResolution>();
        ArrayList elementsIds = nclDoc.getAllElementsOfType(tagname);
        for (String id : elementsIds) {
            int elementOffset = nclDoc.getOffsetByID(id);
            String refer = nclDoc.getAttributeValueFromCurrentTagName(elementOffset, "refer");
            if (refer != null) continue;
            fixes.add(this.changeAttributeResolution(message, nclDoc, "refer", id, offset));
        }
        fixes.add(this.removeAttributeResolution(message, nclDoc, "refer", offset));
        fixes.add(this.removeElementResolution(message, nclDoc, offset));
        return fixes;
    }

    private ArrayList<IMarkerResolution> referenceErrorWithPerspective(Message message, NCLSourceDocument nclDoc, String tagname, String attribute, int offset) {
        String elementId;
        Collection elements;
        Collection nclReference;
        ArrayList<IMarkerResolution> fixes = new ArrayList<IMarkerResolution>();
        File currentFile = null;
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
        IWorkbenchPage page = win.getActivePage();
        IEditorPart editor = page.getActiveEditor();
        try {
            currentFile = editor.getEditorInput() instanceof IFileEditorInput ? new File(((IFileEditorInput)editor.getEditorInput()).getFile().getLocationURI()) : new File(((IURIEditorInput)editor.getEditorInput()).getURI());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String nclText = nclDoc.get();
        NCLContentHandler nclContentHandler = new NCLContentHandler();
        NCLDocument nclDocument = new NCLDocument();
        nclDocument.setParentURI(currentFile.getParentFile().toURI());
        nclContentHandler.setNclDocument(nclDocument);
        NCLParser parser = new NCLParser();
        parser.setContentHandler((ContentHandler)nclContentHandler);
        try {
            parser.doParse(nclText);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        String fatherTagName = nclDoc.getFatherTagName(offset);
        String perspective = nclDoc.getAttributeValueFromCurrentTagName(nclDoc.getFatherPartitionOffset(offset), "id");
        if ((tagname.equals("mapping") || tagname.equals("bind")) && attribute.equals("component")) {
            perspective = nclDoc.getAttributeValueFromCurrentTagName(nclDoc.getFatherPartitionOffset(nclDoc.getFatherPartitionOffset(offset)), "id");
        }
        if (perspective == null && fatherTagName.equals("body")) {
            perspective = nclDoc.getAttributeValueFromCurrentTagName(nclDoc.getFatherPartitionOffset(nclDoc.getFatherPartitionOffset(offset)), "id");
        }
        if ((nclReference = NCLStructure.getInstance().getNCLReference(tagname, attribute)) == null) {
            return fixes;
        }
        Object proposal = null;
        Iterator it = null;
        if (perspective != null) {
            for (NCLReference nclRefAtual : nclReference) {
                elements = nclDocument.getElementsFromPerspective(nclRefAtual.getRefTagname(), perspective);
                if (elements == null) continue;
                for (NCLElement nclElement : elements) {
                    elementId = nclElement.getAttributeValue(nclRefAtual.getRefAttribute());
                    if (elementId == null) continue;
                    fixes.add(this.changeAttributeResolution(message, nclDoc, attribute, elementId, offset));
                }
            }
        }
        it = nclReference.iterator();
        if (perspective == null) {
            for (NCLReference nclRefAtual : nclReference) {
                elements = nclDocument.getElements().get(nclRefAtual.getRefTagname());
                if (elements == null) continue;
                for (NCLElement refElement : elements) {
                    elementId = refElement.getAttributeValue(nclRefAtual.getRefAttribute());
                    if (elementId == null || elementId.endsWith("#null")) continue;
                    fixes.add(this.changeAttributeResolution(message, nclDoc, attribute, elementId, offset));
                }
            }
        }
        return fixes;
    }

    public boolean hasResolutions(IMarker marker) {
        System.out.println("NCLErrorFixer::hasResolutions");
        return true;
    }

    private IMarkerResolution addElementResolution(Message message, NCLSourceDocument nclDoc, String element, int offset) {
        String newElement = element;
        String tagname = nclDoc.getCurrentTagname(offset);
        if (element.equals("causalConnector")) {
            newElement = "xconnector";
        }
        if (tagname.equals("bind") && !element.equals("descriptor") || tagname.equals("port")) {
            newElement = "component";
        }
        if (tagname.equals("bindRule")) {
            newElement = "constituent";
        }
        String idNewElement = message.getElement().getAttribute(newElement);
        String label = "Add a <" + element + "> with identifier \"" + idNewElement + "\"";
        return new QuickFix(label, message, nclDoc, FixType.ADD_ELEMENT, offset, new String[]{element, idNewElement});
    }

    private IMarkerResolution addChildResolution(Message message, NCLSourceDocument nclDoc, String element, String attribute, String value, int offset) {
        String newElement = element;
        String fatherId = nclDoc.getCurrentTagname(offset);
        String idNewElement = message.getElement().getAttribute(newElement);
        String label = "Add a <" + element + "> in element \"" + fatherId + "\"";
        return new QuickFix(label, message, nclDoc, FixType.ADD_CHILD, offset, new String[]{element, attribute, value});
    }

    private IMarkerResolution addAttributeResolution(Message message, NCLSourceDocument nclDoc, String attribute, int offset) {
        String id = message.getId();
        if (id == null || id.equals("")) {
            id = message.getElement().getTagName();
        }
        String label = "Add \"" + attribute + "\" attribute in element \"" + id + "\"";
        return new QuickFix(label, message, nclDoc, FixType.SET_ATTRIBUTE, offset, new String[]{attribute, ""});
    }

    private IMarkerResolution addAttributeResolution(Message message, NCLSourceDocument nclDoc, String attribute, String value, int offset) {
        String id = message.getId();
        if (id == null || id.equals("")) {
            id = message.getElement().getTagName();
        }
        String label = "Add \"" + attribute + "\" attribute in element \"" + id + "\" with value \"" + value + "\"";
        return new QuickFix(label, message, nclDoc, FixType.SET_ATTRIBUTE, offset, new String[]{attribute, value});
    }

    private IMarkerResolution removeAttributeResolution(Message message, NCLSourceDocument nclDoc, String attribute, int offset) {
        String id = message.getId();
        if (id == null || id.equals("")) {
            id = message.getElement().getTagName();
        }
        String label = "Remove \"" + attribute + "\" attribute of the element \"" + id + "\"";
        return new QuickFix(label, message, nclDoc, FixType.REMOVE_ATTRIBUTE, offset, new String[]{attribute});
    }

    private IMarkerResolution removeElementResolution(Message message, NCLSourceDocument nclDoc, int offset) {
        String id = message.getId();
        if (id == null) {
            id = "";
        }
        String label = "Remove <" + message.getElement().getTagName() + "> element with identifier \"" + id + "\"";
        return new QuickFix(label, message, nclDoc, FixType.REMOVE_ELEMENT, offset, new String[]{message.getId()});
    }

    private IMarkerResolution changeAttributeResolution(Message message, NCLSourceDocument nclDoc, String attribute, String value, int offset) {
        String label = "Change \"" + attribute + "\" attribute to \"" + value + "\"";
        return new QuickFix(label, message, nclDoc, FixType.SET_ATTRIBUTE, offset, new String[]{attribute, value});
    }
}

