/*
 * Decompiled with CFR 0.152.
 */
package br.ufma.deinf.laws.ncleclipse.launch.util;

import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.SCPClient;
import ch.ethz.ssh2.SFTPv3Client;
import ch.ethz.ssh2.Session;
import ch.ethz.ssh2.StreamGobbler;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.ui.console.MessageConsoleStream;

public class RemoteUtility {
    private String hostName;
    private String userName;
    private String userPassword;
    private Connection connection;
    private SCPClient scp;
    private SFTPv3Client sftp;
    private boolean verboseMode;
    private MessageConsoleStream consoleStream;

    public RemoteUtility(String hostName, String userName, String userPassword, MessageConsoleStream consoleStream) {
        this.setHostName(hostName);
        this.setUserName(userName);
        this.setUserPassword(userPassword);
        this.setConsoleStream(consoleStream);
        this.setConnection(new Connection(this.getHostName()));
        this.setVerboseMode(false);
    }

    public void connect() throws IOException {
        this.connection.connect();
        if (!this.connection.authenticateWithPassword(this.userName, this.userPassword)) {
            throw new IOException();
        }
        this.setSCP(new SCPClient(this.connection));
        this.setSFTP(new SFTPv3Client(this.connection));
    }

    public void put(String localFile, String remoteDirectory) throws IOException {
        this.scp.put(localFile, remoteDirectory);
    }

    public void get(String remoteFile, String localDirectory) throws IOException {
        this.scp.get(remoteFile, localDirectory);
    }

    public void sync(String localPath, String remotePath) {
    }

    public void update(String remotePath, String localDirectory) {
    }

    public String format(String path) {
        return path.replace(' ', '_');
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void commit(String localPath, String remoteDirectory) throws IOException {
        File localFile = new File(localPath);
        String localFileName = localFile.getName();
        String localFilePath = localFile.getAbsolutePath();
        String localSeparator = System.getProperty("file.separator");
        if (remoteDirectory.charAt(remoteDirectory.length() - 1) == localSeparator.charAt(0)) {
            remoteDirectory = remoteDirectory.substring(0, remoteDirectory.length() - 1);
        }
        if (localFile.isDirectory()) {
            String[] subFilesNames;
            try {
                this.sftp.lstat(this.format(String.valueOf(remoteDirectory) + localSeparator + localFileName));
            }
            catch (IOException e) {
                if (this.verboseMode) {
                    this.consoleStream.println("Copying '" + localFilePath + "'" + " " + "to" + " " + "'" + this.format(remoteDirectory) + "'" + ".");
                }
                this.sftp.mkdir(this.format(String.valueOf(remoteDirectory) + localSeparator + localFileName), 644);
            }
            String[] stringArray = subFilesNames = localFile.list();
            int n = subFilesNames.length;
            int n2 = 0;
            while (n2 < n) {
                String subFileName = stringArray[n2];
                this.commit(String.valueOf(localFilePath) + localSeparator + subFileName, String.valueOf(remoteDirectory) + localSeparator + localFileName);
                ++n2;
            }
            return;
        }
        try {
            long localFileLastModified = localFile.lastModified() / 1000L;
            long remoteFileLastModified = this.sftp.stat((String)this.format((String)new StringBuilder((String)String.valueOf((Object)remoteDirectory)).append((String)localSeparator).append((String)localFileName).toString())).mtime.intValue();
            if (localFileLastModified <= remoteFileLastModified) return;
            if (this.verboseMode) {
                this.consoleStream.println("Copying '" + localFilePath + "'" + " " + "to" + " " + "'" + this.format(remoteDirectory) + "/" + this.format(localFileName) + "'" + ".");
            }
            this.scp.put(localFilePath, this.format(localFileName), this.format(remoteDirectory), "0644");
            return;
        }
        catch (IOException e) {
            if (this.verboseMode) {
                this.consoleStream.println("Copying '" + localFilePath + "'" + " " + "to" + " " + "'" + this.format(remoteDirectory) + "/" + this.format(localFileName) + "'" + ".");
            }
            this.scp.put(localFilePath, this.format(localFileName), this.format(remoteDirectory), "0644");
        }
    }

    public void exec(String command) throws IOException {
        String line;
        if (this.verboseMode) {
            this.consoleStream.println("Executing '" + command + "'" + ".");
        }
        Session session = this.connection.openSession();
        session.execCommand(command);
        StreamGobbler remoteStdout = new StreamGobbler(session.getStdout());
        BufferedReader remoteStdoutReader = new BufferedReader(new InputStreamReader((InputStream)remoteStdout));
        while ((line = remoteStdoutReader.readLine()) != null) {
            this.consoleStream.println(line);
        }
        session.close();
    }

    public void close() {
        this.connection.close();
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public void setUserPassword(String userPassword) {
        this.userPassword = userPassword;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public SCPClient getSCP() {
        return this.scp;
    }

    public void setSCP(SCPClient scp) {
        this.scp = scp;
    }

    public SFTPv3Client getSFTP() {
        return this.sftp;
    }

    public void setSFTP(SFTPv3Client sftp) {
        this.sftp = sftp;
    }

    public MessageConsoleStream getConsoleStream() {
        return this.consoleStream;
    }

    public void setConsoleStream(MessageConsoleStream consoleStream) {
        this.consoleStream = consoleStream;
    }

    public void setVerboseMode(boolean verboseMode) {
        this.verboseMode = verboseMode;
    }
}

