/*
 * Decompiled with CFR 0.152.
 */
package br.ufma.deinf.laws.ncleclipse.ncl;

import br.ufma.deinf.laws.ncleclipse.ncl.NCLDocument;
import br.ufma.deinf.laws.ncleclipse.ncl.NCLElement;
import br.ufma.deinf.laws.ncleclipse.ncl.NCLParser;
import br.ufma.deinf.laws.util.MultiHashMap;
import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;

public class NCLContentHandler
extends DefaultHandler2 {
    private NCLDocument nclDocument = null;
    private Stack<String> perspective;
    private String perspectiveSemId = "0";
    private String completePerspective = "";
    private Locator locator;
    private String doc;

    @Override
    public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endElement(String localName, String arg1, String arg2) throws SAXException {
        if (arg1.equals("body") || arg1.equals("ncl") || arg1.equals("context") || arg1.equals("media") || arg1.equals("switch") || arg1.equals("causalConnector") || arg1.equals("descriptorSwitch")) {
            this.perspective.pop();
        }
    }

    @Override
    public void endPrefixMapping(String arg0) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
    }

    @Override
    public void processingInstruction(String arg0, String arg1) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator arg0) {
        this.locator = arg0;
    }

    @Override
    public void skippedEntity(String arg0) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.nclDocument == null) {
            this.nclDocument = new NCLDocument();
        }
        if (this.perspective == null) {
            this.perspective = new Stack();
        }
    }

    @Override
    public void startElement(String URI2, String localName, String qName, Attributes atts) throws SAXException {
        String strPerspective = "";
        if (this.perspective.size() > 0) {
            strPerspective = (String)this.perspective.lastElement();
        }
        this.completePerspective = "";
        Iterator itStack = this.perspective.iterator();
        while (itStack.hasNext()) {
            this.completePerspective = String.valueOf(this.completePerspective) + "/" + itStack.next();
        }
        NCLElement nclElement = new NCLElement(localName, strPerspective, this.locator.getLineNumber() - 1);
        int i = 0;
        while (i < atts.getLength()) {
            nclElement.setAttributeValue(atts.getLocalName(i), atts.getValue(i));
            ++i;
        }
        nclElement.setDoc(this.doc);
        this.doc = "";
        nclElement.setCompletePerspective(this.completePerspective);
        this.nclDocument.addElement(nclElement, atts.getValue("id"));
        if (localName.equals("body") || localName.equals("ncl") || localName.equals("context") || localName.equals("media") || localName.equals("switch") || localName.equals("causalConnector") || localName.equals("descriptorSwitch")) {
            String strNewPerspective = "";
            if (this.nclDocument.alias != null && !this.nclDocument.alias.equals("")) {
                strNewPerspective = String.valueOf(this.nclDocument.alias) + "#";
            }
            if (atts.getValue("id") != null) {
                strNewPerspective = String.valueOf(strNewPerspective) + atts.getValue("id");
            } else if (this.perspective.size() > 0) {
                strNewPerspective = String.valueOf(strNewPerspective) + (String)this.perspective.lastElement();
            } else {
                Integer pTmp = new Integer(this.perspectiveSemId);
                pTmp = pTmp + 1;
                this.perspectiveSemId = pTmp.toString();
                strNewPerspective = String.valueOf(strNewPerspective) + this.perspectiveSemId;
            }
            this.perspective.push(strNewPerspective);
        }
        if (localName.equals("importBase") || localName.equals("importNCL")) {
            String alias_ant = this.nclDocument.getAlias();
            String alias = alias_ant;
            alias = alias != null && !alias.equals("") ? String.valueOf(alias) + atts.getValue("alias") : atts.getValue("alias");
            NCLParser parser = new NCLParser();
            NCLContentHandler contentHandlerTmp = new NCLContentHandler();
            contentHandlerTmp.getNclDocument().setAlias(alias);
            parser.setContentHandler((ContentHandler)contentHandlerTmp);
            try {
                if (atts.getValue("documentURI") != null && !atts.getValue("documentURI").equals("")) {
                    URI uri = new URI(atts.getValue("documentURI"));
                    if (uri.isAbsolute()) {
                        parser.doParse(new File(uri));
                    } else {
                        parser.doParse(new File(new URI(String.valueOf(this.nclDocument.getParentURI().toString()) + "/" + atts.getValue("documentURI"))));
                    }
                }
            }
            catch (Exception e) {
                System.out.println("Nao foi possivel fazer o parse do documento " + atts.getValue("documentURI"));
            }
            MultiHashMap currentElements = this.nclDocument.getElements();
            MultiHashMap importedElements = contentHandlerTmp.getNclDocument().getElements();
            Set keySet = importedElements.keySet();
            Iterator it = keySet.iterator();
            while (it.hasNext()) {
                Collection elements = importedElements.get((String)it.next());
                if (elements == null) continue;
                for (NCLElement importedNclElement : elements) {
                    importedNclElement.setCompletePerspective(String.valueOf(this.completePerspective) + importedNclElement.getCompletePerspective());
                    this.nclDocument.addElement(importedNclElement, (String)importedNclElement.getAttributes().get("id"));
                }
            }
        }
    }

    @Override
    public void startPrefixMapping(String arg0, String arg1) throws SAXException {
    }

    public NCLDocument getNclDocument() {
        if (this.nclDocument == null) {
            this.nclDocument = new NCLDocument();
        }
        return this.nclDocument;
    }

    public void setNclDocument(NCLDocument nclDocument) {
        this.nclDocument = nclDocument;
    }

    @Override
    public void comment(char[] arg0, int arg1, int arg2) throws SAXException {
        this.doc = "";
        int i = arg1;
        while (i < arg2) {
            this.doc = String.valueOf(this.doc) + arg0[i];
            ++i;
        }
    }
}

