/*
 * Decompiled with CFR 0.152.
 */
package br.ufma.deinf.laws.ncleclipse.wizards;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class NCLNewWizardPage
extends WizardPage {
    protected Text containerText;
    protected Text fileText;
    protected Text fileId;
    protected ISelection selection;
    protected String extension;

    public NCLNewWizardPage(ISelection selection) {
        super("wizardPage");
        this.setTitle("NCL Document Wizard");
        this.setExtension(".ncl");
        this.setDescription("This wizard creates a new NCL document that can be opened by the ncl-eclipse Plugin.");
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        Label label = new Label(container, 0);
        label.setText("&Container:");
        this.containerText = new Text(container, 2052);
        GridData gd = new GridData(768);
        this.containerText.setLayoutData((Object)gd);
        this.containerText.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        Button button = new Button(container, 8);
        button.setText("Browse...");
        button.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        label = new Label(container, 0);
        label.setText("&Id:");
        this.fileId = new Text(container, 2052);
        gd = new GridData(768);
        this.fileId.setLayoutData((Object)gd);
        this.fileId.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        label = new Label(container, 0);
        label = new Label(container, 0);
        label.setText("&File name:");
        this.fileText = new Text(container, 2052);
        gd = new GridData(768);
        this.fileText.setLayoutData((Object)gd);
        this.fileText.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.initialize();
        this.setControl((Control)container);
    }

    protected void initialize() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof IResource) {
                IContainer container = obj instanceof IContainer ? (IContainer)obj : ((IResource)obj).getParent();
                this.containerText.setText(container.getFullPath().toString());
            }
        }
        this.fileId.setText("new_ncl_file");
    }

    protected void handleBrowse() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, "Select new file container");
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.containerText.setText(((Path)result[0]).toString());
        }
    }

    protected void containerChanged() {
        IResource container = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.getContainerName()));
        if (this.getContainerName().length() == 0) {
            this.updateStatus("File container must be specified");
            return;
        }
        if (container == null || (container.getType() & 6) == 0) {
            this.updateStatus("File container must exist");
            return;
        }
        if (!container.isAccessible()) {
            this.updateStatus("Project must be writable");
            return;
        }
        this.updateStatus(null);
    }

    protected void fileNameChanged() {
        String fileName = this.getFileName();
        if (fileName.length() == 0) {
            this.updateStatus("File name must be specified");
            return;
        }
        if (fileName.replace('\\', '/').indexOf(47, 1) > 0) {
            this.updateStatus("File name must be valid");
            return;
        }
        if (!fileName.endsWith(".ncl")) {
            this.updateStatus("File extension must be \"" + this.getExtension() + "\"");
            return;
        }
        this.updateStatus(null);
    }

    protected void fileIdChanged() {
        String fileId = this.getFileId();
        this.fileText.setText(String.valueOf(fileId) + this.getExtension());
        if (fileId.length() == 0) {
            this.updateStatus("File id must be specified.");
            return;
        }
        this.updateStatus(null);
    }

    protected void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getContainerName() {
        return this.containerText.getText();
    }

    public String getFileName() {
        return this.fileText.getText();
    }

    public String getFileId() {
        return this.fileId.getText();
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String ext) {
        this.extension = ext;
    }
}

