/*
 * Decompiled with CFR 0.152.
 */
package br.ufma.deinf.laws.ncleclipse.ncl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.StringReader;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class NCLParser {
    private ErrorHandler errorHandler;
    private ContentHandler contentHandler;
    public static final String VALIDATION_FEATURE = "http://xml.org/sax/features/validation";

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public void doParse(File xmlFilePath) throws RuntimeException {
        InputSource inputSource = null;
        try {
            inputSource = new InputSource(new FileReader(xmlFilePath));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        this.doParse(inputSource);
    }

    public void doParse(String xmlText) throws RuntimeException {
        InputSource inputSource = new InputSource(new StringReader(xmlText));
        this.doParse(inputSource);
    }

    public void doParse(InputSource inputSource) throws RuntimeException {
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setProperty("http://xml.org/sax/properties/lexical-handler", this.contentHandler);
            reader.setErrorHandler(this.errorHandler);
            reader.setContentHandler(this.contentHandler);
            reader.parse(inputSource);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

