/*
 * Decompiled with CFR 0.152.
 */
package br.ufma.deinf.gia.labmint.schemas;

import br.ufma.deinf.gia.labmint.schemas.SchemaErrorChecker;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class SchemaJaxp {
    static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";

    public void Validate(String file, String sch) throws SAXException, IOException, ParserConfigurationException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance(W3C_XML_SCHEMA);
        StreamSource schemaSource = new StreamSource(new File(sch));
        Schema schema = schemaFactory.newSchema(schemaSource);
        SchemaErrorChecker mySchemaErrorHandler = new SchemaErrorChecker();
        Validator validator = schema.newValidator();
        validator.setErrorHandler((ErrorHandler)mySchemaErrorHandler);
        validator.setProperty(JAXP_SCHEMA_SOURCE, sch);
        validator.validate(new StreamSource(file));
    }

    public static void main(String[] args) {
        SchemaJaxp sch = new SchemaJaxp();
        try {
            sch.Validate("testes/tmp.ncl", "schemas/profiles/NCL30BDTV.xsd");
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }
}

