/*
 * Decompiled with CFR 0.152.
 */
package br.ufma.deinf.laws.ncleclipse.correction;

import br.ufma.deinf.gia.labmint.message.Message;
import br.ufma.deinf.laws.ncleclipse.correction.FixType;
import br.ufma.deinf.laws.ncleclipse.document.NCLSourceDocument;
import org.eclipse.core.resources.IMarker;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMarkerResolution2;

public class QuickFix
implements IMarkerResolution2 {
    private String label;
    private Message message;
    private NCLSourceDocument nclSourceDoc;
    private int type;
    private int offset;
    private String[] params;

    QuickFix(String label, Message message, NCLSourceDocument nclSourceDoc) {
        this.label = label;
        this.message = message;
        this.nclSourceDoc = nclSourceDoc;
        this.type = FixType.UNKNOW;
        this.params = null;
    }

    QuickFix(String label, Message message, NCLSourceDocument nclSourceDoc, int type, int offset, String[] params) {
        this.label = label;
        this.message = message;
        this.nclSourceDoc = nclSourceDoc;
        this.type = type;
        this.params = params;
        this.offset = offset;
    }

    public String getLabel() {
        return this.label;
    }

    public void run(IMarker marker) {
        if (this.type == FixType.ADD_ELEMENT) {
            if (this.params == null || this.params.length < 2) {
                return;
            }
            String tagname = this.params[0];
            String id = this.params[1];
            this.nclSourceDoc.addElement(tagname, id, this.offset);
        } else if (this.type == FixType.ADD_CHILD) {
            if (this.params == null || this.params.length < 3) {
                return;
            }
            String child = this.params[0];
            String attribute = this.params[1];
            String value = this.params[2];
            this.nclSourceDoc.addChild(child, attribute, value, this.offset);
        } else if (this.type != FixType.REMOVE_CHILD) {
            if (this.type == FixType.REMOVE_ELEMENT) {
                this.nclSourceDoc.removeElement(this.offset);
            } else if (this.type == FixType.SET_ATTRIBUTE) {
                if (this.params == null || this.params.length < 2) {
                    return;
                }
                String attribute = this.params[0];
                String value = this.params[1];
                this.nclSourceDoc.setAttribute(attribute, value, this.offset);
            } else if (this.type == FixType.REMOVE_ATTRIBUTE) {
                if (this.params == null || this.params.length < 1) {
                    return;
                }
                String attribute = this.params[0];
                this.nclSourceDoc.removeAttribute(attribute, this.offset);
            } else if (this.type == 0) {
                this.nclSourceDoc.correctNCLStructure();
            }
        }
    }

    public String getDescription() {
        return "Roberto Gerson";
    }

    public Image getImage() {
        return null;
    }
}

